/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.analysis.AnalysisScope;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandLineInspectionProjectConfigurator {
    public static final ExtensionPointName<CommandLineInspectionProjectConfigurator> EP_NAME = ExtensionPointName.create((String)"com.intellij.commandLineInspectionProjectConfigurator");

    @NotNull
    public String getName();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription();

    default public boolean isApplicable(@NotNull ConfiguratorContext context) {
        return true;
    }

    default public void configureEnvironment(@NotNull ConfiguratorContext context) {
    }

    default public void configureProject(@NotNull Project project, @NotNull ConfiguratorContext context) {
    }

    public static interface ConfiguratorContext {
        @NotNull
        public CommandLineInspectionProgressReporter getLogger();

        @NotNull
        public ProgressIndicator getProgressIndicator();

        @NotNull
        public Path getProjectPath();

        @NotNull
        public Predicate<Path> getFilesFilter();

        @NotNull
        default public Predicate<VirtualFile> getVirtualFilesFilter() {
            Predicate<Path> filesPredicate = this.getFilesFilter();
            return file2 -> {
                Path path = file2.getFileSystem().getNioPath(file2);
                return path != null && filesPredicate.test(path);
            };
        }

        @Nullable
        default public AnalysisScope getAnalyzerScope() {
            return null;
        }
    }
}

