/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectionIndex
extends ScalarIndexExtension<Integer> {
    private static final Logger LOG = Logger.getInstance(FrameworkDetectionIndex.class);
    public static final ID<Integer, Void> NAME = ID.create((String)"FrameworkDetectionIndex");
    private final EventDispatcher<FrameworkDetectionIndexListener> myDispatcher = EventDispatcher.create(FrameworkDetectionIndexListener.class);

    public static FrameworkDetectionIndex getInstance() {
        return (FrameworkDetectionIndex)((Object)EXTENSION_POINT_NAME.findExtension(FrameworkDetectionIndex.class));
    }

    @NotNull
    public ID<Integer, Void> getName() {
        return NAME;
    }

    public void addListener(@NotNull FrameworkDetectionIndexListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @NotNull
    public DataIndexer<Integer, Void, FileContent> getIndexer() {
        return new DataIndexer<Integer, Void, FileContent>(){

            @NotNull
            public Map<Integer, Void> map(@NotNull FileContent inputData) {
                FileType fileType = inputData.getFileType();
                MultiMap<FileType, Pair<ElementPattern<FileContent>, Integer>> detectors = FrameworkDetectorRegistry.getInstance().getDetectorsMap();
                if (!detectors.containsKey((Object)fileType)) {
                    return Collections.emptyMap();
                }
                Map<Integer, Void> result2 = null;
                for (Pair pair : detectors.get((Object)fileType)) {
                    if (!((ElementPattern)pair.getFirst()).accepts((Object)inputData)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(inputData.getFile() + " accepted by detector " + pair.getSecond());
                    }
                    if (result2 == null) {
                        result2 = new HashMap<Integer, Void>();
                    }
                    ((FrameworkDetectionIndexListener)FrameworkDetectionIndex.this.myDispatcher.getMulticaster()).fileUpdated(inputData.getFile(), (Integer)pair.getSecond());
                    result2.put((Integer)pair.getSecond(), null);
                }
                return result2 != null ? result2 : Collections.emptyMap();
            }
        };
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file2 -> file2.isInLocalFileSystem() && FrameworkDetectorRegistry.getInstance().getAcceptedFileTypes().contains(file2.getFileType());
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return FrameworkDetectorRegistry.getInstance().getDetectorsVersion();
    }
}

