/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class SelectedTextFormatter {
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final String myTextBefore;
    private final RangeMarker mySelectionRangeMarker;

    public SelectedTextFormatter(Project project, Editor editor, PsiFile file2) {
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file2;
        this.myTextBefore = this.myEditor.getSelectionModel().getSelectedText();
        this.mySelectionRangeMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
    }

    public void restoreSelectedText() {
        Document document = this.myEditor.getDocument();
        if (!this.mySelectionRangeMarker.isValid()) {
            return;
        }
        int start2 = this.mySelectionRangeMarker.getStartOffset();
        int end = this.mySelectionRangeMarker.getEndOffset();
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(LangBundle.message((String)"command.name.configure.code.style.on.selected.fragment.restore.text.before", (Object[])new Object[0])).run(() -> document.replaceString(start2, end, (CharSequence)this.myTextBefore));
        this.myEditor.getSelectionModel().setSelection(start2, start2 + this.myTextBefore.length());
    }

    void reformatSelectedText(@NotNull CodeStyleSettings reformatSettings) {
        SelectionModel model = this.myEditor.getSelectionModel();
        if (model.hasSelection()) {
            CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)reformatSettings, () -> SelectedTextFormatter.reformatRange(this.myFile, this.getSelectedRange()));
        }
    }

    void reformatWholeFile() {
        SelectedTextFormatter.reformatRange(this.myFile, this.myFile.getTextRange());
    }

    private static void reformatRange(@NotNull PsiFile file2, @NotNull TextRange range2) {
        Project project = file2.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance((Project)project).reformatText(file2, range2.getStartOffset(), range2.getEndOffset())), LangBundle.message((String)"command.name.reformat", (Object[])new Object[0]), null);
    }

    @NotNull
    TextRange getSelectedRange() {
        SelectionModel model = this.myEditor.getSelectionModel();
        int start2 = model.getSelectionStart();
        int end = model.getSelectionEnd();
        return TextRange.create((int)start2, (int)end);
    }
}

