/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupDirectoryChooser
extends JPanel {
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FindPopupPanel myFindPopupPanel;
    @NotNull
    private final ComboBox<String> myDirectoryComboBox;

    public FindPopupDirectoryChooser(@NotNull FindPopupPanel panel2) {
        super(new BorderLayout());
        this.myHelper = panel2.getHelper();
        this.myProject = panel2.getProject();
        this.myFindPopupPanel = panel2;
        this.myDirectoryComboBox = new ComboBox(200);
        this.myDirectoryComboBox.setEditable(true);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    FindPopupDirectoryChooser.this.myFindPopupPanel.scheduleResultsUpdate();
                }
            });
            field.setColumns(40);
        }
        this.myDirectoryComboBox.setMaximumRowCount(8);
        ActionListener restartSearchListener = e -> this.myFindPopupPanel.scheduleResultsUpdate();
        this.myDirectoryComboBox.addActionListener(restartSearchListener);
        FixedSizeButton mySelectDirectoryButton = new FixedSizeButton(this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)mySelectDirectoryButton, this.myDirectoryComboBox);
        mySelectDirectoryButton.setMargin((Insets)JBUI.emptyInsets());
        mySelectDirectoryButton.addActionListener(__ -> {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor2.setForcedToUseIdeaFileChooser(true);
            this.myFindPopupPanel.getCanClose().set(false);
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)this.myProject, null, (VirtualFile)VfsUtil.findFileByIoFile((File)new File(this.getDirectory()), (boolean)true), (Consumer)new FileChooser.FileChooserConsumer(){

                public void consume(List<VirtualFile> files2) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(true);
                        IdeFocusManager.getInstance((Project)FindPopupDirectoryChooser.this.myProject).requestFocus(FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().getEditorComponent(), true);
                        FindPopupDirectoryChooser.this.myHelper.getModel().setDirectoryName(((VirtualFile)files2.get(0)).getPresentableUrl());
                        FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().setItem(((VirtualFile)files2.get(0)).getPresentableUrl());
                    });
                }

                public void cancelled() {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(true);
                        IdeFocusManager.getInstance((Project)FindPopupDirectoryChooser.this.myProject).requestFocus(FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().getEditorComponent(), true);
                    });
                }
            });
        });
        MyRecursiveDirectoryAction recursiveDirectoryAction = new MyRecursiveDirectoryAction();
        int mnemonicModifiers = SystemInfo.isMac ? 640 : 512;
        recursiveDirectoryAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(89, mnemonicModifiers)), (JComponent)((Object)this.myFindPopupPanel));
        this.add((Component)this.myDirectoryComboBox, "Center");
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        buttonsPanel.add((Component)mySelectDirectoryButton);
        buttonsPanel.add(FindPopupPanel.createToolbar(new AnAction[]{recursiveDirectoryAction}).getComponent());
        this.add((Component)buttonsPanel, "East");
    }

    public void initByModel(@NotNull FindModel findModel) {
        String directoryName = findModel.getDirectoryName();
        List strings = FindInProjectSettings.getInstance((Project)this.myProject).getRecentDirectories();
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myDirectoryComboBox.removeAllItems();
        }
        if (directoryName != null && !directoryName.isEmpty()) {
            strings.remove(directoryName);
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i2 = strings.size() - 1; i2 >= 0; --i2) {
            this.myDirectoryComboBox.addItem(strings.get(i2));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    @NotNull
    public ComboBox getComboBox() {
        return this.myDirectoryComboBox;
    }

    @NotNull
    public String getDirectory() {
        return (String)this.myDirectoryComboBox.getEditor().getItem();
    }

    @Nullable
    public ValidationInfo validate(@NotNull FindModel model) {
        VirtualFile directory = FindInProjectUtil.getDirectory(model);
        if (directory == null) {
            return new ValidationInfo(FindBundle.message("find.directory.not.found.error", new Object[0]), this.myDirectoryComboBox);
        }
        return null;
    }

    private class MyRecursiveDirectoryAction
    extends DumbAwareToggleAction {
        MyRecursiveDirectoryAction() {
            super(FindBundle.messagePointer("find.recursively.hint", new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.ShowAsTree);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return FindPopupDirectoryChooser.this.myHelper.getModel().isWithSubdirectories();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            FindPopupDirectoryChooser.this.myHelper.getModel().setWithSubdirectories(state);
            FindPopupDirectoryChooser.this.myFindPopupPanel.scheduleResultsUpdate();
        }
    }
}

