/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FindInProjectSettingsBase
implements PersistentStateComponent<FindInProjectSettingsBase> {
    private static final int MAX_RECENT_SIZE = 30;
    @XCollection(style=XCollection.Style.v2, elementName="find", valueAttributeName="")
    public List<String> findStrings = new ArrayList<String>();
    @XCollection(style=XCollection.Style.v2, elementName="replace", valueAttributeName="")
    public List<String> replaceStrings = new ArrayList<String>();
    @XCollection(style=XCollection.Style.v2, elementName="dir", valueAttributeName="")
    public List<String> dirStrings = new ArrayList<String>();

    public void loadState(@NotNull FindInProjectSettingsBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        LinkedHashSet<String> tmp = new LinkedHashSet<String>(this.findStrings);
        this.findStrings.clear();
        this.findStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.replaceStrings);
        this.replaceStrings.clear();
        this.replaceStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.dirStrings);
        this.dirStrings.clear();
        this.dirStrings.addAll(tmp);
    }

    public FindInProjectSettingsBase getState() {
        return this;
    }

    public void addDirectory(@NotNull String s) {
        if (s.isEmpty()) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.dirStrings);
    }

    @NotNull
    public List<String> getRecentDirectories() {
        return new ArrayList<String>(this.dirStrings);
    }

    public void addStringToFind(@NotNull String s) {
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.findStrings);
    }

    public void addStringToReplace(@NotNull String s) {
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.replaceStrings);
    }

    public String @NotNull [] getRecentFindStrings() {
        return ArrayUtilRt.toStringArray(this.findStrings);
    }

    public String @NotNull [] getRecentReplaceStrings() {
        return ArrayUtilRt.toStringArray(this.replaceStrings);
    }

    static void addRecentStringToList(@NotNull String str, @NotNull List<? super String> list2) {
        list2.remove(str);
        list2.add(str);
        while (list2.size() > 30) {
            list2.remove(0);
        }
    }

    static class FindInProjectPathMacroFilter
    extends PathMacroFilter {
        FindInProjectPathMacroFilter() {
        }

        public boolean skipPathMacros(@NotNull Element element2) {
            String tag2 = element2.getName();
            if (tag2.equals("findStrings") || tag2.equals("replaceStrings")) {
                String component2 = FileStorageCoreUtil.findComponentName(element2);
                return component2 != null && (component2.equals("FindSettings") || component2.equals("FindInProjectRecents"));
            }
            return false;
        }
    }
}

