/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.LastSearchData;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.findUsages.UsageHistory;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindUsagesManager {
    private static final Logger LOG = Logger.getInstance(FindUsagesManager.class);
    private static final Key<String> KEY_START_USAGE_AGAIN = Key.create((String)"KEY_START_USAGE_AGAIN");
    @NonNls
    private static final String VALUE_START_USAGE_AGAIN = "START_AGAIN";
    private final Project myProject;
    private LastSearchData myLastSearchInFileData;
    private final UsageHistory myHistory = new UsageHistory();

    public FindUsagesManager(@NotNull Project project) {
        this.myProject = project;
    }

    @Deprecated
    public FindUsagesManager(@NotNull Project project, UsageViewManager anotherManager) {
        DeprecatedMethodException.report((String)"Please use FindUsagesManager(Project) instead");
        this.myProject = project;
    }

    public boolean canFindUsages(@NotNull PsiElement element2) {
        for (FindUsagesHandlerFactory factory2 : (FindUsagesHandlerFactory[])FindUsagesHandlerFactory.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            try {
                if (!factory2.canFindUsages(element2)) continue;
                return true;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    public void clearFindingNextUsageInFile() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = null;
    }

    public boolean findNextUsageInFile(@NotNull Editor editor) {
        return this.findUsageInFile(editor, FileSearchScope.AFTER_CARET);
    }

    public boolean findPreviousUsageInFile(@NotNull Editor editor) {
        return this.findUsageInFile(editor, FileSearchScope.BEFORE_CARET);
    }

    private boolean findUsageInFile(@NotNull Editor editor, @NotNull FileSearchScope direction) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLastSearchInFileData == null) {
            return false;
        }
        PsiElement[] primaryElements = this.myLastSearchInFileData.getPrimaryElements();
        PsiElement[] secondaryElements = this.myLastSearchInFileData.getSecondaryElements();
        if (primaryElements.length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.searched.elements.have.been.changed.error", new Object[0]), (String)FindBundle.message("cannot.search.for.usages.title", new Object[0]), (Icon)Messages.getInformationIcon());
            return false;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FindUsagesHandler handler2 = this.getFindUsagesHandler(primaryElements[0], false);
        if (handler2 == null) {
            return false;
        }
        this.findUsagesInEditor(primaryElements, secondaryElements, handler2, psiFile, direction, this.myLastSearchInFileData.getOptions(), editor);
        return true;
    }

    private void initLastSearchElement(@NotNull FindUsagesOptions findUsagesOptions, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLastSearchInFileData = new LastSearchData(primaryElements, secondaryElements, findUsagesOptions);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        return this.getFindUsagesHandler(element2, forHighlightUsages ? FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES : FindUsagesHandlerFactory.OperationMode.DEFAULT);
    }

    @Nullable
    public FindUsagesHandler getFindUsagesHandler(@NotNull PsiElement element2, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        for (FindUsagesHandlerFactory factory2 : (FindUsagesHandlerFactory[])FindUsagesHandlerFactory.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (!factory2.canFindUsages(element2)) continue;
            FindUsagesHandler handler2 = factory2.createFindUsagesHandler(element2, operationMode);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    public FindUsagesHandler getNewFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        for (FindUsagesHandlerFactory factory2 : (FindUsagesHandlerFactory[])FindUsagesHandlerFactory.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            if (!factory2.canFindUsages(element2)) continue;
            Class<?> aClass = factory2.getClass();
            FindUsagesHandlerFactory copy2 = (FindUsagesHandlerFactory)new CachingConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(this.myProject.getPicoContainer());
            FindUsagesHandler handler2 = copy2.createFindUsagesHandler(element2, forHighlightUsages);
            if (handler2 == FindUsagesHandler.NULL_HANDLER) {
                return null;
            }
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    public void findUsages(@NotNull PsiElement psiElement, @Nullable PsiFile scopeFile, FileEditor editor, boolean showDialog, @Nullable(value="null means default (stored in options)") @Nullable(value="null means default (stored in options)") SearchScope searchScope) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, showDialog ? FindUsagesHandlerFactory.OperationMode.DEFAULT : FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS);
        if (handler2 == null) {
            return;
        }
        boolean singleFile = scopeFile != null;
        AbstractFindUsagesDialog dialog2 = handler2.getFindUsagesDialog(singleFile, this.shouldOpenInNewTab(), this.mustOpenInNewTab());
        if (showDialog) {
            if (!dialog2.showAndGet()) {
                return;
            }
        } else {
            dialog2.close(0);
        }
        this.setOpenInNewTab(dialog2.isShowInSeparateWindow());
        FindUsagesOptions findUsagesOptions = dialog2.calcFindUsagesOptions();
        if (searchScope != null) {
            findUsagesOptions.searchScope = searchScope;
        }
        this.clearFindingNextUsageInFile();
        this.startFindUsages(findUsagesOptions, handler2, scopeFile, editor);
    }

    void startFindUsages(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions findUsagesOptions) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindUsagesHandler handler2 = this.getFindUsagesHandler(psiElement, false);
        if (handler2 == null) {
            return;
        }
        this.startFindUsages(findUsagesOptions, handler2, null, null);
    }

    private void startFindUsages(@NotNull FindUsagesOptions findUsagesOptions, @NotNull FindUsagesHandler handler2, PsiFile scopeFile, FileEditor fileEditor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean singleFile = scopeFile != null;
        this.clearFindingNextUsageInFile();
        LOG.assertTrue(handler2.getPsiElement().isValid());
        PsiElement[] primaryElements = handler2.getPrimaryElements();
        FindUsagesManager.checkNotNull(primaryElements, handler2, "getPrimaryElements()");
        PsiElement[] secondaryElements = handler2.getSecondaryElements();
        FindUsagesManager.checkNotNull(secondaryElements, handler2, "getSecondaryElements()");
        if (singleFile && fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            editor.putUserData(KEY_START_USAGE_AGAIN, null);
            this.findUsagesInEditor(primaryElements, secondaryElements, handler2, scopeFile, FileSearchScope.FROM_START, findUsagesOptions.clone(), editor);
        } else {
            boolean skipResultsWithOneUsage = FindSettings.getInstance().isSkipResultsWithOneUsage();
            this.findUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, skipResultsWithOneUsage);
        }
    }

    public static void showSettingsAndFindUsages(NavigationItem @NotNull [] targets2) {
        if (targets2.length == 0) {
            return;
        }
        NavigationItem target2 = targets2[0];
        if (!(target2 instanceof ConfigurableUsageTarget)) {
            return;
        }
        ((ConfigurableUsageTarget)target2).showSettings();
    }

    private static void checkNotNull(PsiElement @NotNull [] elements2, @NotNull FindUsagesHandler handler2, @NonNls @NotNull String methodName) {
        for (PsiElement element2 : elements2) {
            if (element2 != null) continue;
            LOG.error(handler2 + "." + methodName + " has returned array with null elements: " + Arrays.asList(elements2));
        }
    }

    @NotNull
    public static ProgressIndicator startProcessUsages(@NotNull FindUsagesHandlerBase handler2, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull Processor<? super Usage> processor2, @NotNull FindUsagesOptions findUsagesOptions, @NotNull Runnable onComplete) {
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        FindUsagesManager.startProcessUsages(indicator, handler2, primaryElements, secondaryElements, processor2, findUsagesOptions, onComplete);
        return indicator;
    }

    private static void startProcessUsages(@NotNull ProgressIndicator indicator, @NotNull FindUsagesHandlerBase handler2, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull Processor<? super Usage> processor2, @NotNull FindUsagesOptions findUsagesOptions, @NotNull Runnable onComplete) {
        FindUsagesManager.startProcessUsages(indicator, handler2.getProject(), FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, findUsagesOptions), processor2, onComplete);
    }

    @ApiStatus.Internal
    public static UsageSearcher createUsageSearcher(@NotNull FindUsagesHandlerBase handler2, PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesOptions findUsagesOptions) {
        return (UsageSearcher)ReadAction.compute(() -> {
            PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
            PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(secondaryElements);
            return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
        });
    }

    public static void startProcessUsages(@NotNull ProgressIndicator indicator, @NotNull Project project, final @NotNull UsageSearcher usageSearcher, final @NotNull Processor<? super Usage> processor2, @NotNull Runnable onComplete) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Task.Backgroundable task2 = new Task.Backgroundable(project, FindBundle.message("progress.title.finding.usages", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                usageSearcher.generate(processor2);
            }
        };
        ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, indicator, onComplete);
    }

    @NotNull
    public UsageViewPresentation createPresentation(@NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions findUsagesOptions) {
        PsiElement element2 = handler2.getPsiElement();
        LOG.assertTrue(element2.isValid());
        return FindUsagesManager.createPresentation(element2, findUsagesOptions, FindSettings.getInstance().isShowResultsInSeparateView());
    }

    private void setOpenInNewTab(boolean toOpenInNewTab) {
        if (!this.mustOpenInNewTab()) {
            FindSettings.getInstance().setShowResultsInSeparateView(toOpenInNewTab);
        }
    }

    private boolean shouldOpenInNewTab() {
        return this.mustOpenInNewTab() || FindSettings.getInstance().isShowResultsInSeparateView();
    }

    private boolean mustOpenInNewTab() {
        Content selectedContent = UsageViewContentManager.getInstance((Project)this.myProject).getSelectedContent(true);
        return selectedContent != null && selectedContent.isPinned();
    }

    @NotNull
    private static UsageSearcher createUsageSearcher(PsiElement2UsageTargetAdapter @NotNull [] primaryTargets, PsiElement2UsageTargetAdapter @NotNull [] secondaryTargets, @NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions options2, PsiFile scopeFile) throws PsiInvalidElementAccessException {
        ReadAction.run(() -> {
            PsiElement[] primaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets);
            PsiElement[] secondaryElements = PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets);
            ContainerUtil.concat((Object[][])new PsiElement[][]{primaryElements, secondaryElements}).forEach(psi -> {
                if (psi == null || !psi.isValid()) {
                    throw new PsiInvalidElementAccessException(psi);
                }
            });
        });
        FindUsagesOptions optionsClone = options2.clone();
        return processor2 -> {
            Object[] primaryElements = (PsiElement[])ReadAction.compute(() -> PsiElement2UsageTargetAdapter.convertToPsiElements(primaryTargets));
            Object[] secondaryElements = (PsiElement[])ReadAction.compute(() -> PsiElement2UsageTargetAdapter.convertToPsiElements(secondaryTargets));
            Project project = (Project)ReadAction.compute(() -> scopeFile != null ? scopeFile.getProject() : primaryTargets[0].getProject());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            LOG.assertTrue(indicator != null, (Object)"Must run under progress. see ProgressManager.run*");
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).dropResolveCacheRegularly(indicator);
            if (scopeFile != null) {
                optionsClone.searchScope = new LocalSearchScope((PsiElement)scopeFile);
            }
            CommonProcessors.UniqueProcessor usageInfoProcessor = new CommonProcessors.UniqueProcessor(arg_0 -> FindUsagesManager.lambda$null$7((PsiElement[])primaryElements, processor2, arg_0));
            PsiElement[] elements2 = (PsiElement[])ArrayUtil.mergeArrays((Object[])primaryElements, (Object[])secondaryElements, (ArrayFactory)PsiElement.ARRAY_FACTORY);
            optionsClone.fastTrack = new SearchRequestCollector(new SearchSession(elements2));
            if (optionsClone.searchScope instanceof GlobalSearchScope) {
                optionsClone.searchScope = optionsClone.searchScope.union((SearchScope)GlobalSearchScope.projectScope((Project)project));
            }
            try {
                for (PsiElement element2 : elements2) {
                    if (!handler2.processElementUsages(element2, (Processor<? super UsageInfo>)usageInfoProcessor, optionsClone)) {
                        return;
                    }
                    for (CustomUsageSearcher searcher : CustomUsageSearcher.EP_NAME.getExtensionList()) {
                        try {
                            searcher.processElementUsages(element2, (Processor<? super Usage>)processor2, optionsClone);
                        }
                        catch (IndexNotReadyException e) {
                            DumbService.getInstance((Project)element2.getProject()).showDumbModeNotification(FindBundle.message("notification.find.usages.is.not.available.during.indexing", new Object[0]));
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                PsiSearchHelper.getInstance((Project)project).processRequests(optionsClone.fastTrack, arg_0 -> FindUsagesManager.lambda$null$9((Processor)usageInfoProcessor, arg_0));
            }
            finally {
                optionsClone.fastTrack = null;
            }
        };
    }

    private static PsiElement2UsageTargetAdapter @NotNull [] convertToUsageTargets(@NotNull Iterable<? extends PsiElement> elementsToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        List targets2 = ContainerUtil.map(elementsToSearch, element2 -> FindUsagesManager.convertToUsageTarget(element2, findUsagesOptions));
        return targets2.toArray(new PsiElement2UsageTargetAdapter[0]);
    }

    public void findUsages(PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        this.doFindUsages(primaryElements, secondaryElements, handler2, findUsagesOptions, toSkipUsagePanelWhenOneUsage);
    }

    public UsageView doFindUsages(PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesHandlerBase handler2, @NotNull FindUsagesOptions findUsagesOptions, boolean toSkipUsagePanelWhenOneUsage) {
        if (primaryElements.length == 0) {
            throw new AssertionError((Object)(handler2 + " " + findUsagesOptions));
        }
        Object[] primaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(primaryElements), findUsagesOptions);
        Object[] secondaryTargets = FindUsagesManager.convertToUsageTargets(Arrays.asList(secondaryElements), findUsagesOptions);
        PsiElement2UsageTargetAdapter[] targets2 = (PsiElement2UsageTargetAdapter[])ArrayUtil.mergeArrays((Object[])primaryTargets, (Object[])secondaryTargets);
        Factory factory2 = () -> FindUsagesManager.lambda$doFindUsages$12((PsiElement2UsageTargetAdapter[])primaryTargets, (PsiElement2UsageTargetAdapter[])secondaryTargets, handler2, findUsagesOptions);
        UsageView usageView = UsageViewManager.getInstance((Project)this.myProject).searchAndShowUsages((UsageTarget[])targets2, factory2, !toSkipUsagePanelWhenOneUsage, true, FindUsagesManager.createPresentation(primaryElements[0], findUsagesOptions, this.shouldOpenInNewTab()), null);
        this.myHistory.add(targets2[0]);
        return usageView;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull PsiElement psiElement, @NotNull FindUsagesOptions options2, boolean toOpenInNewTab) {
        String usagesString = FindUsagesManager.generateUsagesString(options2);
        String longName = UsageViewUtil.getLongName(psiElement);
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        String scopeString = options2.searchScope.getDisplayName();
        presentation2.setScopeText(scopeString);
        presentation2.setSearchString(FindBundle.message("find.usages.of.element.tab.name", usagesString, longName));
        presentation2.setTabText(FindBundle.message("find.usages.of.element.in.scope.panel.title", usagesString, longName, scopeString));
        presentation2.setTabName(FindBundle.message("find.usages.of.element.tab.name", usagesString, UsageViewUtil.getShortName(psiElement)));
        presentation2.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)));
        presentation2.setOpenInNewTab(toOpenInNewTab);
        return presentation2;
    }

    private void findUsagesInEditor(final PsiElement @NotNull [] primaryElements, PsiElement @NotNull [] secondaryElements, @NotNull FindUsagesHandler handler2, final @NotNull PsiFile scopeFile, final @NotNull FileSearchScope direction, @NotNull FindUsagesOptions findUsagesOptions, final @NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.initLastSearchElement(findUsagesOptions, primaryElements, secondaryElements);
        this.clearStatusBar();
        PsiElement2UsageTargetAdapter[] primaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
        PsiElement2UsageTargetAdapter[] secondaryTargets = PsiElement2UsageTargetAdapter.convert(primaryElements);
        final UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, scopeFile);
        final AtomicBoolean usagesWereFound = new AtomicBoolean();
        final int startOffset = editor.getCaretModel().getOffset();
        new Task.Backgroundable(this.myProject, FindBundle.message("find.progress.searching.message", "editor")){
            private Usage myUsage;

            public void run(@NotNull ProgressIndicator indicator) {
                this.myUsage = FindUsagesManager.findSiblingUsage(usageSearcher, direction, startOffset, usagesWereFound, editor);
            }

            public void onFinished() {
                if (FindUsagesManager.this.myProject.isDisposed() || editor.isDisposed()) {
                    return;
                }
                if (this.myUsage != null) {
                    this.myUsage.navigate(true);
                    this.myUsage.selectInEditor();
                } else if (!usagesWereFound.get()) {
                    String message = FindUsagesManager.getNoUsagesFoundMessage(primaryElements[0]) + " in " + scopeFile.getName();
                    FindUsagesManager.showEditorHint(message, editor);
                } else {
                    editor.putUserData(KEY_START_USAGE_AGAIN, (Object)FindUsagesManager.VALUE_START_USAGE_AGAIN);
                    FindUsagesManager.showEditorHint(FindUsagesManager.getSearchAgainMessage(primaryElements[0], direction), editor);
                }
            }
        }.queue();
    }

    @NotNull
    private static String getNoUsagesFoundMessage(@NotNull PsiElement psiElement) {
        String elementType = UsageViewUtil.getType(psiElement);
        String elementName = UsageViewUtil.getShortName(psiElement);
        return FindBundle.message("find.usages.of.element_type.element_name.not.found.message", elementType, elementName);
    }

    private void clearStatusBar() {
        StatusBar.Info.set((String)"", (Project)this.myProject);
    }

    @NotNull
    private static String getSearchAgainMessage(@NotNull PsiElement element2, @NotNull FileSearchScope direction) {
        String shortcutsText;
        AnAction action2;
        String shortcutsText2;
        String message = FindUsagesManager.getNoUsagesFoundMessage(element2);
        message = direction == FileSearchScope.AFTER_CARET ? ((shortcutsText2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action2 = ActionManager.getInstance().getAction("FindNext")))).isEmpty() ? FindBundle.message("find.search.again.from.top.action.message", message) : FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText2)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("FindPrevious"))).isEmpty() ? FindBundle.message("find.search.again.from.bottom.action.message", message) : FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText));
        return message;
    }

    private static Usage findSiblingUsage(@NotNull UsageSearcher usageSearcher, @NotNull FileSearchScope dir, int startOffset, @NotNull AtomicBoolean usagesWereFound, @NotNull Editor editor) {
        if (editor.getUserData(KEY_START_USAGE_AGAIN) != null) {
            dir = dir == FileSearchScope.AFTER_CARET ? FileSearchScope.FROM_START : FileSearchScope.FROM_END;
        }
        FileSearchScope direction = dir;
        AtomicReference foundUsage = new AtomicReference();
        usageSearcher.generate(usage -> {
            usagesWereFound.set(true);
            int usageOffset = usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getNavigationRange().getStartOffset() : 0;
            switch (direction) {
                case FROM_START: {
                    foundUsage.compareAndSet(null, usage);
                    return false;
                }
                case FROM_END: {
                    foundUsage.set(usage);
                    break;
                }
                case AFTER_CARET: {
                    if (usageOffset <= startOffset) break;
                    foundUsage.set(usage);
                    return false;
                }
                case BEFORE_CARET: {
                    int foundOffset;
                    Usage found;
                    if (usageOffset >= startOffset) {
                        return false;
                    }
                    while (!((found = (Usage)foundUsage.get()) == null ? foundUsage.compareAndSet(null, usage) : (foundOffset = found instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)found).getNavigationRange().getStartOffset() : 0) < usageOffset && foundUsage.compareAndSet(found, usage))) {
                    }
                    break;
                }
            }
            return true;
        });
        editor.putUserData(KEY_START_USAGE_AGAIN, null);
        return (Usage)foundUsage.get();
    }

    @NotNull
    private static PsiElement2UsageTargetAdapter convertToUsageTarget(@NotNull PsiElement elementToSearch, @NotNull FindUsagesOptions findUsagesOptions) {
        if (elementToSearch instanceof NavigationItem) {
            return new PsiElement2UsageTargetAdapter(elementToSearch, findUsagesOptions);
        }
        throw new IllegalArgumentException("Wrong usage target:" + elementToSearch + "; " + elementToSearch.getClass());
    }

    @NotNull
    private static String generateUsagesString(@NotNull FindUsagesOptions selectedOptions) {
        return selectedOptions.generateUsagesString();
    }

    private static void showEditorHint(@NotNull String message, @NotNull Editor editor) {
        JComponent component2 = HintUtil.createInformationLabel(message);
        LightweightHint hint = new LightweightHint(component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    public static String getHelpID(@NotNull PsiElement element2) {
        return LanguageFindUsages.getHelpId((PsiElement)element2);
    }

    public void rerunAndRecallFromHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        usageTarget.findUsages();
        this.addToHistory(usageTarget);
    }

    public void addToHistory(@NotNull ConfigurableUsageTarget usageTarget) {
        this.myHistory.add(usageTarget);
    }

    @NotNull
    public UsageHistory getHistory() {
        return this.myHistory;
    }

    @NotNull
    public static GlobalSearchScope getMaximalScope(@NotNull FindUsagesHandlerBase handler2) {
        PsiElement element2 = handler2.getPsiElement();
        Project project = element2.getProject();
        PsiFile file2 = element2.getContainingFile();
        if (file2 != null && ProjectFileIndex.SERVICE.getInstance((Project)project).isInContent(file2.getViewProvider().getVirtualFile())) {
            return GlobalSearchScope.projectScope((Project)project);
        }
        return GlobalSearchScope.allScope((Project)project);
    }

    private static /* synthetic */ UsageSearcher lambda$doFindUsages$12(PsiElement2UsageTargetAdapter[] primaryTargets, PsiElement2UsageTargetAdapter[] secondaryTargets, FindUsagesHandlerBase handler2, FindUsagesOptions findUsagesOptions) {
        return FindUsagesManager.createUsageSearcher(primaryTargets, secondaryTargets, handler2, findUsagesOptions, null);
    }

    private static /* synthetic */ boolean lambda$null$9(Processor usageInfoProcessor, PsiReference ref) {
        UsageInfo info = (UsageInfo)ReadAction.compute(() -> {
            if (!ref.getElement().isValid()) {
                return null;
            }
            return new UsageInfo(ref);
        });
        return info == null || usageInfoProcessor.process((Object)info);
    }

    private static /* synthetic */ boolean lambda$null$7(PsiElement[] primaryElements, Processor processor2, UsageInfo usageInfo) {
        Usage usage = (Usage)ReadAction.compute(() -> UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo)usageInfo));
        return processor2.process((Object)usage);
    }

    private static enum FileSearchScope {
        FROM_START,
        FROM_END,
        AFTER_CARET,
        BEFORE_CARET;

    }
}

