/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesHandlerBase {
    @NotNull
    protected final PsiElement myPsiElement;

    public FindUsagesHandlerBase(@NotNull PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @NotNull
    public final Project getProject() {
        return this.myPsiElement.getProject();
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        return new PsiElement[]{this.myPsiElement};
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        return this.getFindUsagesOptions(null);
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions options2 = FindUsagesHandlerBase.createFindUsagesOptions(this.getProject(), dataContext);
        options2.isSearchForTextOccurrences &= this.isSearchForTextOccurrencesAvailable(this.getPsiElement(), false);
        return options2;
    }

    public boolean processElementUsages(@NotNull PsiElement element2, final @NotNull Processor<? super UsageInfo> processor2, @NotNull FindUsagesOptions options2) {
        boolean success;
        boolean searchText;
        ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                return processor2.process((Object)new UsageInfo(ref));
            }
        };
        SearchScope scope = options2.searchScope;
        boolean bl = searchText = options2.isSearchForTextOccurrences && scope instanceof GlobalSearchScope;
        if (options2.isUsages && !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters(element2, scope, options2)).forEach((Processor)refProcessor))) {
            return false;
        }
        if (searchText) {
            if (options2.fastTrack != null) {
                options2.fastTrack.searchCustom(consumer -> this.processUsagesInText(element2, processor2, (GlobalSearchScope)scope));
            } else {
                return this.processUsagesInText(element2, processor2, (GlobalSearchScope)scope);
            }
        }
        return true;
    }

    public boolean processUsagesInText(@NotNull PsiElement element2, @NotNull Processor<? super UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
        Collection stringToSearch = (Collection)ReadAction.compute(() -> this.getStringsToSearch(element2));
        if (stringToSearch == null) {
            return true;
        }
        return FindUsagesHelper.processUsagesInText(element2, stringToSearch, false, searchScope, processor2);
    }

    @Nullable
    protected Collection<String> getStringsToSearch(@NotNull PsiElement element2) {
        if (element2 instanceof PsiNamedElement) {
            return ContainerUtil.createMaybeSingletonList((Object)((PsiNamedElement)element2).getName());
        }
        return Collections.singleton(element2.getText());
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        return this.isSearchForTextOccurencesAvailable(psiElement, isSingleFile);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        return false;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target2, @NotNull SearchScope searchScope) {
        return ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters(target2, searchScope, null)).findAll();
    }

    @NotNull
    protected ReferencesSearch.SearchParameters createSearchParameters(@NotNull PsiElement target2, @NotNull SearchScope searchScope, @Nullable FindUsagesOptions findUsagesOptions) {
        return new ReferencesSearch.SearchParameters(target2, searchScope, false, findUsagesOptions == null ? null : findUsagesOptions.fastTrack);
    }

    @NotNull
    public static FindUsagesOptions createFindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project, dataContext);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isSearchForTextOccurrences = true;
        return findUsagesOptions;
    }
}

