/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.ui.awt.RelativePoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowUsagesParameters {
    @NotNull
    final Project project;
    @Nullable
    final Editor editor;
    @NotNull
    final RelativePoint popupPosition;
    @NotNull
    final IntRef minWidth;
    final int maxUsages;

    private ShowUsagesParameters(@NotNull Project project, @Nullable Editor editor, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, int maxUsages) {
        this.project = project;
        this.editor = editor;
        this.popupPosition = popupPosition;
        this.minWidth = minWidth;
        this.maxUsages = maxUsages;
    }

    @NotNull
    ShowUsagesParameters moreUsages() {
        return new ShowUsagesParameters(this.project, this.editor, this.popupPosition, this.minWidth, this.maxUsages + ShowUsagesAction.getUsagesPageSize());
    }

    @NotNull
    ShowUsagesParameters withEditor(@NotNull Editor editor) {
        return new ShowUsagesParameters(this.project, editor, this.popupPosition, this.minWidth, this.maxUsages);
    }

    @NotNull
    static ShowUsagesParameters initial(@NotNull Project project, @Nullable Editor editor, @NotNull RelativePoint popupPosition) {
        return new ShowUsagesParameters(project, editor, popupPosition, new IntRef(0), ShowUsagesAction.getUsagesPageSize());
    }
}

