/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.SearchTarget2UsageTarget;
import com.intellij.find.actions.UsageOptionsDialog;
import com.intellij.find.usages.SearchTarget;
import com.intellij.find.usages.UsageHandler;
import com.intellij.find.usages.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.find.usages.impl.TextSearchKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import kotlin.Metadata;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a:\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0014H\u0000\u001aB\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0014H\u0002\u001a<\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0006\u001a&\u0010\u0018\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0014H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "displayString", "", "Lcom/intellij/find/usages/SearchTarget;", "getDisplayString", "(Lcom/intellij/find/usages/SearchTarget;)Ljava/lang/String;", "canReuseTab", "", "project", "Lcom/intellij/openapi/project/Project;", "findUsages", "", "O", "target", "handler", "Lcom/intellij/find/usages/UsageHandler;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "showDialog", "selectedScope", "Lcom/intellij/psi/search/SearchScope;", "getSearchString", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class FindUsagesKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.actions");

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    public static final void findUsages(boolean showDialog, @NotNull Project project, @NotNull SearchScope selectedScope, @NotNull SearchTarget target2) {
        FindUsagesKt.findUsages(showDialog, project, target2, target2.getUsageHandler(), selectedScope);
    }

    private static final <O> void findUsages(boolean showDialog, Project project, SearchTarget target2, UsageHandler<O> handler2, SearchScope selectedScope) {
        AllSearchOptions<O> allOptions = new AllSearchOptions<O>(UsageOptions.createOptions(true, selectedScope), TextSearchKt.hasTextSearchStrings(target2) ? Boolean.valueOf(false) : null, handler2.getCustomOptions(UsageHandler.UsageAction.FIND_USAGES));
        FindUsagesKt.findUsages(showDialog, project, target2, handler2, allOptions);
    }

    private static final <O> void findUsages(boolean showDialog, Project project, SearchTarget target2, UsageHandler<O> handler2, AllSearchOptions<O> allOptions) {
        if (showDialog) {
            boolean canReuseTab = FindUsagesKt.canReuseTab(project);
            UsageOptionsDialog<O> dialog2 = new UsageOptionsDialog<O>(project, FindUsagesKt.getDisplayString(target2), handler2, allOptions, canReuseTab);
            if (!dialog2.showAndGet()) {
                return;
            }
            FindUsagesKt.findUsages(project, target2, handler2, dialog2.result());
        } else {
            FindUsagesKt.findUsages(project, target2, handler2, allOptions);
        }
    }

    public static final <O> void findUsages(@NotNull Project project, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler2, @NotNull AllSearchOptions<O> allOptions) {
        Query<Usage> query = ImplKt.buildQuery(project, target2, handler2, allOptions);
        Factory factory2 = (Factory)new Factory<UsageSearcher>(project, query){
            final /* synthetic */ Project $project;
            final /* synthetic */ Query $query;

            public final UsageSearcher create() {
                return new UsageSearcher(this){
                    final /* synthetic */ findUsages.factory.1 this$0;

                    public final void generate(@NotNull Processor<? super Usage> it) {
                        HelperKt.runSearch(this.this$0.$project, this.this$0.$query, it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.$project = project;
                this.$query = query;
            }
        };
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        boolean bl = false;
        boolean bl2 = false;
        UsageViewPresentation $this$apply = usageViewPresentation;
        boolean bl3 = false;
        $this$apply.setSearchString(FindUsagesKt.getSearchString(handler2, allOptions));
        $this$apply.setScopeText(allOptions.getOptions().getSearchScope().getDisplayName());
        $this$apply.setTabText(UsageViewBundle.message((String)"search.title.0.in.1", (Object[])new Object[]{$this$apply.getSearchString(), $this$apply.getScopeText()}));
        $this$apply.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView() || !FindUsagesKt.canReuseTab(project));
        UsageViewPresentation usageViewPresentation2 = usageViewPresentation;
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        ((UsageViewManager)$this$service$iv.getService(UsageViewManager.class)).searchAndShowUsages((UsageTarget[])new SearchTarget2UsageTarget[]{new SearchTarget2UsageTarget<O>(project, target2, allOptions)}, factory2, false, true, usageViewPresentation2, null);
    }

    private static final boolean canReuseTab(Project project) {
        UsageViewContentManager contentManager2 = UsageViewContentManager.getInstance((Project)project);
        Content selectedContent = contentManager2.getSelectedContent(true);
        return selectedContent == null ? contentManager2.getReusableContentsCount() != 0 : !selectedContent.isPinned();
    }

    @Nullable
    public static final String getDisplayString(@NotNull SearchTarget $this$displayString) {
        return $this$displayString.getPresentation().getPresentableText();
    }

    @NotNull
    public static final <O> String getSearchString(@NotNull UsageHandler<O> $this$getSearchString, @NotNull AllSearchOptions<O> allOptions) {
        return $this$getSearchString.getSearchString(allOptions.getOptions(), allOptions.getCustomOptions());
    }
}

