/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.PluginException;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrowableDescription {
    private static final String UNKNOWN = "unknown";
    private static final String THIRD_PARTY = "third.party";
    @Nullable
    private final Throwable myThrowable;
    private final StackTraceElement @Nullable [] myStacktrace;

    public ThrowableDescription(@Nullable Throwable throwable) {
        this.myThrowable = throwable != null ? ThrowableDescription.getCause(throwable) : null;
        this.myStacktrace = this.myThrowable != null ? ThrowableDescription.getStacktrace(this.myThrowable) : null;
    }

    private static StackTraceElement @Nullable [] getStacktrace(@NotNull Throwable throwable) {
        try {
            return throwable.getStackTrace();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @NotNull
    public String getClassName() {
        if (this.myThrowable == null) {
            return UNKNOWN;
        }
        Class<?> throwableClass = this.myThrowable.getClass();
        PluginInfo throwableLocation = PluginInfoDetectorKt.getPluginInfo(throwableClass);
        return throwableLocation.isSafeToReport() ? throwableClass.getName() : THIRD_PARTY;
    }

    public int getSize() {
        if (this.myStacktrace == null) {
            return -1;
        }
        return this.myStacktrace.length;
    }

    @NotNull
    public List<String> getLastFrames(int frameCount) {
        if (this.myStacktrace == null) {
            return Collections.emptyList();
        }
        int size = Math.min(this.myStacktrace.length, frameCount);
        ArrayList<String> result2 = new ArrayList<String>(size);
        HashMap<String, PluginInfo> pluginInfoCache = new HashMap<String, PluginInfo>();
        for (int i2 = 0; i2 < size; ++i2) {
            StackTraceElement element2 = this.myStacktrace[i2];
            PluginInfo pluginInfo = (PluginInfo)pluginInfoCache.get(element2.getClassName());
            if (pluginInfo == null) {
                pluginInfo = PluginInfoDetectorKt.getPluginInfo((String)element2.getClassName());
                pluginInfoCache.put(element2.getClassName(), pluginInfo);
            }
            if (pluginInfo.isSafeToReport()) {
                result2.add(element2.getClassName() + "." + element2.getMethodName());
                continue;
            }
            result2.add(THIRD_PARTY);
        }
        return result2;
    }

    @NotNull
    private static Throwable getCause(@NotNull Throwable throwable) {
        boolean isPluginException = throwable instanceof PluginException && throwable.getCause() != null;
        return isPluginException ? throwable.getCause() : throwable;
    }
}

