/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.idea.Main;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EAPUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "user.advanced.info";
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return EAPUsageCollector.collectMetrics();
    }

    @NotNull
    private static Set<MetricEvent> collectMetrics() {
        try {
            if (!Main.isHeadless()) {
                HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
                if (ApplicationInfoEx.getInstanceEx().isEAP()) {
                    result2.add(MetricEventFactoryKt.newMetric((String)"eap"));
                    result2.add(EAPUsageCollector.newBuildMetric("eap"));
                } else {
                    result2.add(MetricEventFactoryKt.newMetric((String)"release"));
                    result2.add(EAPUsageCollector.newBuildMetric("release"));
                }
                LicensingFacade facade = LicensingFacade.getInstance();
                if (facade != null) {
                    if (facade.isEvaluationLicense()) {
                        result2.add(MetricEventFactoryKt.newMetric((String)"evaluation"));
                        result2.add(EAPUsageCollector.newLicencingMetric("evaluation", facade.metadata));
                    } else if (!StringUtil.isEmpty((String)facade.getLicensedToMessage())) {
                        result2.add(MetricEventFactoryKt.newMetric((String)"license"));
                        result2.add(EAPUsageCollector.newLicencingMetric("license", facade.metadata));
                    }
                }
                return result2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @NotNull
    private static MetricEvent newLicencingMetric(@NotNull String value2, @Nullable String metadata) {
        FeatureUsageData data2 = new FeatureUsageData();
        if (StringUtil.isNotEmpty((String)metadata)) {
            data2.addData("metadata", metadata);
        }
        return MetricEventFactoryKt.newMetric((String)"licencing", (String)value2, (FeatureUsageData)data2);
    }

    @NotNull
    private static MetricEvent newBuildMetric(@NotNull String value2) {
        return MetricEventFactoryKt.newMetric((String)"build", (String)value2);
    }
}

