/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private volatile Map<FacetTypeId<?>, Collection<Facet<?>>> myType2Facets;
    private volatile Map<FacetAndType, Collection<Facet<?>>> myChildFacets;
    private volatile Facet<?>[] mySortedFacets;

    public Facet<?> @NotNull [] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet facets2 = new LinkedHashSet();
                for (Facet facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets2, facet);
                }
                this.mySortedFacets = facets2.toArray(Facet.EMPTY_ARRAY);
            }
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<? super Facet<?>> facets2, Facet<?> facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets2.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets2, underlyingFacet);
        }
        facets2.add(facet);
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets2;
        if (this.myChildFacets == null) {
            MultiMap children2 = new MultiMap();
            for (Facet facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children2.putValue((Object)new FacetAndType(underlying, facet.getTypeId()), (Object)facet);
            }
            this.myChildFacets = children2.freezeValues();
        }
        return (facets2 = this.myChildFacets.get(new FacetAndType(underlyingFacet, typeId))) != null ? facets2 : Collections.emptyList();
    }

    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        return facet.getName();
    }

    @Nullable
    public <F extends Facet<?>> F findFacet(FacetTypeId<F> type, String name) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f : fs) {
            if (!f.getName().equals(name)) continue;
            return (F)f;
        }
        return null;
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<F> fs = this.getFacetsByType(underlyingFacet, typeId);
        return (F)(fs.isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> facets2 = this.getFacetsByType(typeId);
        return (F)(facets2.isEmpty() ? null : (Facet)facets2.iterator().next());
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets2;
        if (this.myType2Facets == null) {
            MultiMap typeToFacets = new MultiMap();
            for (Facet facet : this.getAllFacets()) {
                typeToFacets.putValue((Object)facet.getTypeId(), (Object)facet);
            }
            this.myType2Facets = typeToFacets.freezeValues();
        }
        return (facets2 = this.myType2Facets.get(typeId)) != null ? facets2 : Collections.emptyList();
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }

    private static final class FacetAndType {
        final Facet<?> myFacet;
        final FacetTypeId<?> myTypeId;

        private FacetAndType(Facet<?> facet, FacetTypeId<?> id2) {
            this.myFacet = facet;
            this.myTypeId = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FacetAndType type = (FacetAndType)o;
            return Objects.equals(this.myFacet, type.myFacet) && Objects.equals(this.myTypeId, type.myTypeId);
        }

        public int hashCode() {
            return Objects.hash(this.myFacet, this.myTypeId);
        }
    }
}

