/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.FacetEventsPublisher;
import com.intellij.facet.impl.FacetLoadingErrorDescription;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@ApiStatus.Internal
public abstract class FacetManagerBase
extends FacetManager {
    private static final Logger LOG = Logger.getInstance(FacetManagerBase.class);

    @NotNull
    public <F extends Facet<?>, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @NotNull C configuration, @Nullable Facet<?> underlying) {
        return FacetManagerBase.createFacet(this.getModule(), type, name, configuration, underlying);
    }

    @ApiStatus.Internal
    public static void setFacetName(Facet<?> facet, String newName) {
        facet.setName(newName);
    }

    @NotNull
    protected static <F extends Facet<?>, C extends FacetConfiguration> F createFacet(@NotNull Module module, @NotNull FacetType<F, C> type, @NotNull String name, @NotNull C configuration, @Nullable Facet<?> underlying) {
        Facet facet = type.createFacet(module, name, configuration, underlying);
        FacetManagerBase.assertTrue(facet.getModule() == module, facet, "module");
        FacetManagerBase.assertTrue(facet.getConfiguration() == configuration, facet, "configuration");
        FacetManagerBase.assertTrue(Objects.equals(facet.getName(), name), facet, "name");
        FacetManagerBase.assertTrue(facet.getUnderlyingFacet() == underlying, facet, "underlyingFacet");
        return (F)facet;
    }

    @NotNull
    public <F extends Facet<?>, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet<?> underlying) {
        FacetConfiguration configuration = ProjectFacetManager.getInstance((Project)this.getModule().getProject()).createDefaultConfiguration(type);
        return this.createFacet(type, name, configuration, underlying);
    }

    @NotNull
    public <F extends Facet<?>, C extends FacetConfiguration> F addFacet(@NotNull FacetType<F, C> type, @NotNull String name, @Nullable Facet<?> underlying) {
        ModifiableFacetModel model = this.createModifiableModel();
        F facet = this.createFacet(type, name, underlying);
        model.addFacet(facet);
        model.commit();
        return facet;
    }

    public void facetConfigurationChanged(@NotNull Facet<?> facet) {
        FacetEventsPublisher.getInstance(facet.getModule().getProject()).fireFacetConfigurationChanged(facet);
    }

    public Facet<?> @NotNull [] getAllFacets() {
        return this.getModel().getAllFacets();
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(FacetTypeId<F> typeId) {
        return (F)this.getModel().getFacetByType(typeId);
    }

    protected abstract FacetModel getModel();

    @Nullable
    public <F extends Facet<?>> F findFacet(FacetTypeId<F> type, String name) {
        return (F)this.getModel().findFacet(type, name);
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        return (F)this.getModel().getFacetByType(underlyingFacet, typeId);
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        return this.getModel().getFacetsByType(underlyingFacet, typeId);
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        return this.getModel().getFacetsByType(typeId);
    }

    public Facet<?> @NotNull [] getSortedFacets() {
        return this.getModel().getSortedFacets();
    }

    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        return this.getModel().getFacetName(facet);
    }

    protected abstract Module getModule();

    @ApiStatus.Internal
    @NotNull
    public static InvalidFacet createInvalidFacet(@NotNull Module module, @NotNull FacetState state, @Nullable Facet<?> underlyingFacet, @NotNull String errorMessage, boolean unknownType, boolean reportError) {
        InvalidFacetManager invalidFacetManager;
        Project project = module.getProject();
        InvalidFacetType type = InvalidFacetType.getInstance();
        InvalidFacetConfiguration configuration = new InvalidFacetConfiguration(state, errorMessage);
        InvalidFacet facet = FacetManagerBase.createFacet(module, type, StringUtil.notNullize((String)state.getName()), configuration, underlyingFacet);
        if (reportError && !(invalidFacetManager = InvalidFacetManager.getInstance(project)).isIgnored(facet)) {
            FacetLoadingErrorDescription description = new FacetLoadingErrorDescription(facet);
            ProjectLoadingErrorsNotifier.getInstance(project).registerError(description);
            if (unknownType) {
                UnknownFeaturesCollector.getInstance(project).registerUnknownFeature("com.intellij.facetType", state.getFacetType(), "Facet");
            }
        }
        return facet;
    }

    private static void assertTrue(boolean value2, Facet<?> facet, String parameter) {
        if (!value2) {
            LOG.error("Facet type " + facet.getType().getClass().getName() + " violates the contract of FacetType.createFacet method about '" + parameter + "' parameter");
        }
    }

    public void checkConsistency() {
    }
}

