/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.concurrency.Semaphore;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseContentCloseListener
implements VetoableProjectManagerListener,
ContentManagerListener {
    private static final Key<Boolean> PROJECT_DISPOSING = Key.create((String)"Project disposing is in progress");
    private static final Logger LOG = Logger.getInstance(BaseContentCloseListener.class);
    private Content myContent;
    private final Project myProject;

    public BaseContentCloseListener(@NotNull Content content2, @NotNull Project project) {
        this.myContent = content2;
        this.myProject = project;
        ContentManager contentManager2 = content2.getManager();
        if (contentManager2 != null) {
            contentManager2.addContentManagerListener((ContentManagerListener)this);
        }
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)this);
    }

    public void contentRemoved(@NotNull ContentManagerEvent event) {
        Content content2 = event.getContent();
        if (content2 == this.myContent) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.myContent == null) {
            return;
        }
        Content content2 = this.myContent;
        this.myContent = null;
        ContentManager contentManager2 = content2.getManager();
        if (contentManager2 != null) {
            contentManager2.removeContentManagerListener((ContentManagerListener)this);
        }
        ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)this);
        this.disposeContent(content2);
    }

    protected abstract void disposeContent(@NotNull Content var1);

    public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
        boolean canClose;
        if (event.getContent() == this.myContent && !(canClose = this.closeQuery(this.myContent, Boolean.TRUE.equals(this.myProject.getUserData(PROJECT_DISPOSING))))) {
            event.consume();
        }
    }

    public void projectClosed(@NotNull Project project) {
        if (this.myContent == null || project != this.myProject) {
            return;
        }
        ContentManager contentManager2 = this.myContent.getManager();
        if (contentManager2 != null) {
            contentManager2.removeContent(this.myContent, true);
        }
        this.dispose();
    }

    public void projectClosing(@NotNull Project project) {
        project.putUserData(PROJECT_DISPOSING, (Object)true);
    }

    public boolean canClose(@NotNull Project project) {
        if (this.myContent == null || project != this.myProject) {
            return true;
        }
        boolean canClose = this.closeQuery(this.myContent, true);
        if (canClose && this.myContent != null) {
            Objects.requireNonNull(this.myContent.getManager()).removeContent(this.myContent, true);
            this.myContent = null;
        }
        return canClose;
    }

    protected boolean askUserAndWait(@NotNull ProcessHandler processHandler2, @NotNull String sessionName, @NotNull WaitForProcessTask task2) {
        boolean destroyProcess;
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            processHandler2.destroyProcess();
            LOG.info("Destroying process under write action (name: " + sessionName + ", " + processHandler2.getClass() + ", " + processHandler2.toString() + ")");
            return true;
        }
        GeneralSettings.ProcessCloseConfirmation rc = TerminateRemoteProcessDialog.show(this.myProject, sessionName, processHandler2);
        if (rc == null) {
            return false;
        }
        boolean bl = destroyProcess = rc == GeneralSettings.ProcessCloseConfirmation.TERMINATE;
        if (destroyProcess) {
            processHandler2.destroyProcess();
        } else {
            processHandler2.detachProcess();
        }
        ProgressManager.getInstance().run((Task)task2);
        return true;
    }

    protected abstract boolean closeQuery(@NotNull Content var1, boolean var2);

    protected static abstract class WaitForProcessTask
    extends Task.Backgroundable {
        final ProcessHandler myProcessHandler;
        final boolean myModal;

        protected WaitForProcessTask(@NotNull ProcessHandler processHandler2, @NotNull String processName, boolean modal, @Nullable Project project) {
            super(project, ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{processName}));
            this.myProcessHandler = processHandler2;
            this.myModal = modal;
        }

        public boolean isConditionalModal() {
            return this.myModal;
        }

        public boolean shouldStartInBackground() {
            return !this.myModal;
        }

        public void run(final @NotNull ProgressIndicator progressIndicator2) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.myProcessHandler.waitFor();
                }
                finally {
                    semaphore.up();
                }
            });
            progressIndicator2.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (progressIndicator2.isCanceled() || !progressIndicator2.isRunning()) break;
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(2000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    semaphore.up();
                }
            });
            semaphore.waitFor();
        }

        public abstract void onCancel();
    }
}

