/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.DeferingPrinter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsOutputConsolePrinter
implements Printer,
Disposable {
    private final ConsoleView myConsole;
    private final TestConsoleProperties myProperties;
    private final AbstractTestProxy myUnboundOutputRoot;
    private AbstractTestProxy myCurrentTest;
    private final DeferingPrinter myPausedPrinter = new DeferingPrinter();
    private boolean myPaused = false;
    private int myMarkOffset = 0;
    private final TestFrameworkPropertyListener<Boolean> myPropertyListener = new TestFrameworkPropertyListener<Boolean>(){

        @Override
        public void onChanged(Boolean value2) {
            if (!value2.booleanValue()) {
                TestsOutputConsolePrinter.this.myMarkOffset = 0;
            }
        }
    };

    public TestsOutputConsolePrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, TestConsoleProperties properties, AbstractTestProxy unboundOutputRoot) {
        this.myConsole = testsOutputConsoleView.getConsole();
        this.myProperties = properties;
        this.myUnboundOutputRoot = unboundOutputRoot;
        this.myProperties.addListener(TestConsoleProperties.SCROLL_TO_STACK_TRACE, this.myPropertyListener);
    }

    public ConsoleView getConsole() {
        return this.myConsole;
    }

    public boolean isPaused() {
        return this.myPaused;
    }

    public void pause(boolean doPause) {
        this.myPaused = doPause;
        if (!doPause) {
            this.myPausedPrinter.printAndForget(this);
        }
    }

    @Override
    public void print(String text, ConsoleViewContentType contentType) {
        this.myConsole.print(text, contentType);
    }

    @Override
    public void onNewAvailable(@NotNull Printable printable) {
        if (this.myPaused) {
            printable.printOn(this.myPausedPrinter);
        } else {
            printable.printOn(this);
        }
    }

    public void updateOnTestSelected(AbstractTestProxy test) {
        if (this.myCurrentTest == test) {
            return;
        }
        if (this.myCurrentTest != null) {
            this.myCurrentTest.setPrinter(null);
        }
        this.myMarkOffset = 0;
        Runnable clearRunnable = () -> this.myConsole.clear();
        if (test == null) {
            this.myCurrentTest = null;
            CompositePrintable.invokeInAlarm(clearRunnable);
            return;
        }
        this.myCurrentTest = test;
        this.myCurrentTest.setPrinter(this);
        Runnable scrollRunnable = () -> this.scrollToBeginning();
        AbstractTestProxy currentProxyOrRoot = this.getCurrentProxyOrRoot();
        CompositePrintable.invokeInAlarm(clearRunnable);
        currentProxyOrRoot.printOn(this);
        currentProxyOrRoot.printFromFrameworkOutputFile(this);
        CompositePrintable.invokeInAlarm(scrollRunnable);
    }

    private AbstractTestProxy getCurrentProxyOrRoot() {
        return this.isRoot() && this.myUnboundOutputRoot != null ? this.myUnboundOutputRoot : this.myCurrentTest;
    }

    public boolean isCurrent(CompositePrintable printable) {
        return this.myCurrentTest == printable || this.isRoot();
    }

    private boolean isRoot() {
        return this.isRoot(this.myCurrentTest);
    }

    private boolean isRoot(@Nullable AbstractTestProxy proxy) {
        return proxy != null && proxy.getParent() == this.myUnboundOutputRoot;
    }

    @Override
    public void printHyperlink(String text, HyperlinkInfo info) {
        this.myConsole.printHyperlink(text, info);
    }

    @Override
    public void mark() {
        if (TestConsoleProperties.SCROLL_TO_STACK_TRACE.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myMarkOffset = this.myConsole.getContentSize();
        }
    }

    public void dispose() {
        this.myProperties.removeListener(TestConsoleProperties.SCROLL_TO_STACK_TRACE, this.myPropertyListener);
    }

    public boolean canPause() {
        return this.myCurrentTest != null && this.myCurrentTest.isInProgress();
    }

    protected void scrollToBeginning() {
        this.myConsole.performWhenNoDeferredOutput(() -> {
            AbstractTestProxy currentProxyOrRoot = this.getCurrentProxyOrRoot();
            if (currentProxyOrRoot != null && !currentProxyOrRoot.isInProgress()) {
                this.myConsole.scrollTo(this.myMarkOffset);
            }
        });
    }

    @Override
    public void printWithAnsiColoring(@NotNull String text, @NotNull Key processOutputType) {
        if (this.myConsole instanceof TerminalExecutionConsole) {
            this.print(text, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
        } else {
            Printer.super.printWithAnsiColoring(text, processOutputType);
        }
    }

    @Override
    public void printExpectedActualHeader(String expected, String actual) {
        this.myProperties.printExpectedActualHeader(this, expected, actual);
    }
}

