/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.autotest.AutoTestManager;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjustAutotestDelayActionGroup
extends ActionGroup {
    public static final int MAX_DELAY = 10;
    private final DataContext myDataContext;

    public AdjustAutotestDelayActionGroup(@NotNull JComponent parent) {
        super(TestRunnerBundle.message("action.AdjustAutotestDelayActionGroup.set.autotest.delay.text", new Object[0]), true);
        this.myDataContext = DataManager.getInstance().getDataContext((Component)parent);
    }

    public void update(@NotNull AnActionEvent e) {
        RunContentDescriptor descriptor2 = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(this.myDataContext);
        boolean visible = false;
        if (descriptor2 != null) {
            for (AnAction action2 : descriptor2.getRestartActions()) {
                if (!(action2 instanceof ToggleAutoTestAction)) continue;
                visible = ((ToggleAutoTestAction)action2).isDelayApplicable();
                break;
            }
        }
        e.getPresentation().setVisible(visible);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] actions = new AnAction[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            actions[i2] = new SetAutoTestDelayAction(i2 + 1);
        }
        return actions;
    }

    private static class SetAutoTestDelayAction
    extends ToggleAction {
        private final int myDelay;

        SetAutoTestDelayAction(int delay) {
            super(TestRunnerBundle.message("action.seconds.text", delay));
            this.myDelay = delay * 1000;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            return project != null && AutoTestManager.getInstance(project).getDelay() == this.myDelay;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Project project = e.getProject();
            if (project != null) {
                AutoTestManager.getInstance(project).setDelay(this.myDelay);
            }
        }
    }
}

