/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentDetailsConfigurable;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.target.TargetEnvironmentsMasterDetails;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0014J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0014J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;", "Lcom/intellij/openapi/ui/MasterDetailsComponent;", "project", "Lcom/intellij/openapi/project/Project;", "initialSelectedName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "addTargetNode", "Lcom/intellij/openapi/ui/MasterDetailsComponent$MyNode;", "config", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "allTargets", "", "apply", "", "createActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "fromPopup", "", "deletedTargets", "", "getConfiguredTargets", "getDisplayName", "getEmptySelectionString", "isModified", "processRemovedItems", "reset", "wasObjectStored", "editableObject", "", "CreateNewTargetAction", "CreateNewTargetGroup", "DuplicateAction", "intellij.platform.execution.impl"})
public final class TargetEnvironmentsMasterDetails
extends MasterDetailsComponent {
    private final Project project;
    private final String initialSelectedName;

    @NotNull
    public String getDisplayName() {
        return "Remote Targets";
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select target to configure";
    }

    public void reset() {
        block1: {
            this.myRoot.removeAllChildren();
            Iterable $this$forEach$iv = this.allTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TargetEnvironmentConfiguration nextTarget = (TargetEnvironmentConfiguration)element$iv;
                boolean bl = false;
                this.addTargetNode(nextTarget);
            }
            super.reset();
            String string = this.initialSelectedName;
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.selectNodeInTree(this.initialSelectedName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (this.allTargets().size() != this.getConfiguredTargets().size()) return true;
        Collection collection = this.deletedTargets();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!super.isModified()) return false;
        return true;
    }

    @NotNull
    protected List<AnAction> createActions(boolean fromPopup) {
        return CollectionsKt.mutableListOf((Object[])new AnAction[]{(AnAction)new CreateNewTargetGroup(), (AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this), (AnAction)new DuplicateAction()});
    }

    protected void processRemovedItems() {
        Set<TargetEnvironmentConfiguration> deletedTargets = this.deletedTargets();
        Iterable $this$forEach$iv = deletedTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
            boolean bl = false;
            TargetEnvironmentsManager.Companion.getInstance().getTargets().removeConfig((ContributedConfigurationBase)it);
        }
        super.processRemovedItems();
    }

    protected boolean wasObjectStored(@Nullable Object editableObject) {
        return CollectionsKt.contains((Iterable)TargetEnvironmentsManager.Companion.getInstance().getTargets().resolvedConfigs(), (Object)editableObject);
    }

    private final Set<TargetEnvironmentConfiguration> deletedTargets() {
        return SetsKt.minus((Set)CollectionsKt.toSet((Iterable)this.allTargets()), (Iterable)this.getConfiguredTargets());
    }

    public void apply() {
        super.apply();
        List addedConfigs = CollectionsKt.minus((Iterable)this.getConfiguredTargets(), (Iterable)TargetEnvironmentsManager.Companion.getInstance().getTargets().resolvedConfigs());
        Iterable $this$forEach$iv = addedConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
            boolean bl = false;
            TargetEnvironmentsManager.Companion.getInstance().addTarget(it);
        }
    }

    private final List<TargetEnvironmentConfiguration> allTargets() {
        return TargetEnvironmentsManager.Companion.getInstance().getTargets().resolvedConfigs();
    }

    private final MasterDetailsComponent.MyNode addTargetNode(TargetEnvironmentConfiguration config2) {
        TargetEnvironmentDetailsConfigurable configurable2 = new TargetEnvironmentDetailsConfigurable(this.project, config2);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable2);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
        return this.myRoot;
    }

    private final List<TargetEnvironmentConfiguration> getConfiguredTargets() {
        Enumeration enumeration = this.myRoot.children();
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration)), (Function1)getConfiguredTargets.1.INSTANCE)));
    }

    @JvmOverloads
    public TargetEnvironmentsMasterDetails(@NotNull Project project, @Nullable String initialSelectedName) {
        this.project = project;
        this.initialSelectedName = initialSelectedName;
        this.initTree();
        this.myTree.getEmptyText().setText("No targets added");
        this.myTree.getEmptyText().appendSecondaryText("Add new target", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent $noName_0) {
                ActionPopupMenu popup2 = ActionManager.getInstance().createActionPopupMenu("TargetEnvironmentsConfigurable.EmptyListText", (ActionGroup)new CreateNewTargetGroup());
                Dimension size = myTree.getEmptyText().getPreferredSize();
                int textY = myTree.getHeight() / (myTree.getEmptyText().isShowAboveCenter() ? 3 : 2);
                popup2.getComponent().show((Component)myTree, (myTree.getWidth() - size.width) / 2, textY + size.height);
            }
        });
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        this.myTree.getEmptyText().appendSecondaryText(" (" + shortcutText + ')', StatusText.DEFAULT_ATTRIBUTES, null);
    }

    public /* synthetic */ TargetEnvironmentsMasterDetails(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(project, string);
    }

    @JvmOverloads
    public TargetEnvironmentsMasterDetails(@NotNull Project project) {
        this(project, null, 2, null);
    }

    public static final /* synthetic */ List access$getConfiguredTargets(TargetEnvironmentsMasterDetails $this) {
        return $this.getConfiguredTargets();
    }

    public static final /* synthetic */ void access$setMyTree$p(TargetEnvironmentsMasterDetails $this, Tree tree) {
        $this.myTree = tree;
    }

    public static final /* synthetic */ void access$setSelectedNode(TargetEnvironmentsMasterDetails $this, MasterDetailsComponent.MyNode p0) {
        $this.setSelectedNode(p0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$CreateNewTargetAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "type", "Lcom/intellij/execution/target/TargetEnvironmentType;", "(Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;Lcom/intellij/execution/target/TargetEnvironmentType;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.execution.impl"})
    private final class CreateNewTargetAction
    extends DumbAwareAction {
        private final TargetEnvironmentType<?> type;

        public void actionPerformed(@NotNull AnActionEvent e) {
            TargetEnvironmentConfiguration newConfig = (TargetEnvironmentConfiguration)this.type.createDefaultConfig();
            newConfig.setDisplayName(UniqueNameGenerator.generateUniqueName((String)this.type.getDisplayName(), (Condition)((Condition)new Condition<String>(this){
                final /* synthetic */ CreateNewTargetAction this$0;

                public final boolean value(String curName) {
                    boolean bl;
                    block3: {
                        Iterable $this$none$iv = TargetEnvironmentsMasterDetails.access$getConfiguredTargets(this.this$0.TargetEnvironmentsMasterDetails.this);
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)curName)) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
                {
                    this.this$0 = createNewTargetAction;
                }
            })));
            TargetEnvironmentsManager.Companion.getInstance().ensureUniqueName(newConfig);
            MasterDetailsComponent.MyNode newNode = TargetEnvironmentsMasterDetails.this.addTargetNode(newConfig);
            TargetEnvironmentsMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)newNode, true, true);
        }

        public CreateNewTargetAction(TargetEnvironmentType<?> type) {
            super(type.getDisplayName(), null, type.getIcon());
            this.type = type;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0001H\u0016J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$CreateNewTargetGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/ui/MasterDetailsComponent$ActionGroupWithPreselection;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;)V", "getActionGroup", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.execution.impl"})
    private final class CreateNewTargetGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection,
    DumbAware {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = TargetEnvironmentType.EXTENSION_NAME.getExtensionList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TargetEnvironmentType targetEnvironmentType = (TargetEnvironmentType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CreateNewTargetAction createNewTargetAction = new CreateNewTargetAction((TargetEnvironmentType<?>)it);
                collection.add(createNewTargetAction);
            }
            return (AnAction[])UtilKt.toArray((Collection)((List)destination$iv$iv), (Object[])AnAction.EMPTY_ARRAY);
        }

        @NotNull
        public ActionGroup getActionGroup() {
            return this;
        }

        public CreateNewTargetGroup() {
            super("Add", "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD), (JComponent)TargetEnvironmentsMasterDetails.this.myTree);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails$DuplicateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/execution/target/TargetEnvironmentsMasterDetails;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "duplicateSelected", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getSelectedTarget", "update", "intellij.platform.execution.impl"})
    private final class DuplicateAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            this.getTemplatePresentation().setEnabled(this.getSelectedTarget() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block0: {
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.duplicateSelected();
                if (targetEnvironmentConfiguration == null) break block0;
                TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration;
                boolean bl = false;
                boolean bl2 = false;
                TargetEnvironmentConfiguration copy2 = targetEnvironmentConfiguration2;
                boolean bl3 = false;
                TargetEnvironmentsManager.Companion.getInstance().addTarget(copy2);
                MasterDetailsComponent.MyNode newNode = TargetEnvironmentsMasterDetails.this.addTargetNode(copy2);
                TargetEnvironmentsMasterDetails.this.selectNodeInTree((DefaultMutableTreeNode)newNode, true, true);
            }
        }

        private final TargetEnvironmentConfiguration duplicateSelected() {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration;
            TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = this.getSelectedTarget();
            if (targetEnvironmentConfiguration2 != null) {
                TargetEnvironmentConfiguration targetEnvironmentConfiguration3 = targetEnvironmentConfiguration2;
                boolean bl = false;
                boolean bl2 = false;
                TargetEnvironmentConfiguration it = targetEnvironmentConfiguration3;
                boolean bl3 = false;
                targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)it).duplicateConfig((ContributedConfigurationBase)it);
            } else {
                targetEnvironmentConfiguration = null;
            }
            return targetEnvironmentConfiguration;
        }

        private final TargetEnvironmentConfiguration getSelectedTarget() {
            Object object;
            MasterDetailsComponent.MyNode myNode = TargetEnvironmentsMasterDetails.this.getSelectedNode();
            if (!((myNode != null && (myNode = myNode.getConfigurable()) != null ? myNode.getEditableObject() : (object = null)) instanceof TargetEnvironmentConfiguration)) {
                object = null;
            }
            return (TargetEnvironmentConfiguration)object;
        }

        public DuplicateAction() {
            super("Duplicate", "Duplicate", PlatformIcons.COPY_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), (JComponent)TargetEnvironmentsMasterDetails.this.myTree);
        }
    }
}

