/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class ServiceViewNavBarPanel
extends NavBarPanel {
    private final Consumer<ServiceModel.ServiceViewItem> mySelector;
    private boolean myRebuildNeeded = true;

    ServiceViewNavBarPanel(@NotNull Project project, boolean docked, @NotNull ServiceViewModel viewModel, @NotNull Consumer<ServiceModel.ServiceViewItem> selector) {
        super(project, docked);
        this.mySelector = selector;
        Disposer.register((Disposable)viewModel, (Disposable)this);
        ((ServiceViewNavBarModel)this.getModel()).setViewModel(viewModel);
    }

    @Override
    protected boolean isDisposeOnRemove() {
        return false;
    }

    @Override
    protected NavBarModel createModel() {
        NavBarModelListener listener2 = new NavBarModelListener(){

            @Override
            public void modelChanged() {
                ServiceViewNavBarPanel.this.myRebuildNeeded = true;
                ServiceViewNavBarPanel.this.getUpdateQueue().queueRebuildUi();
            }

            @Override
            public void selectionChanged() {
                ServiceViewNavBarPanel.this.updateItems();
                ServiceViewNavBarPanel.this.scrollSelectionToVisible();
            }
        };
        return new ServiceViewNavBarModel(this.myProject, listener2);
    }

    @Override
    public boolean isRebuildUiNeeded() {
        if (this.myRebuildNeeded) {
            this.myRebuildNeeded = false;
            return true;
        }
        return super.isRebuildUiNeeded();
    }

    @Override
    protected void doubleClick(Object object) {
        if (object instanceof ServiceModel.ServiceViewItem) {
            this.mySelector.accept((ServiceModel.ServiceViewItem)object);
        }
        this.hideHint(true);
    }

    void hidePopup() {
        this.hideHint(false);
    }

    static class ServiceViewNavBarRoot {
        ServiceViewNavBarRoot() {
        }
    }

    private static class ServiceViewNavBarModel
    extends NavBarModel {
        private ServiceViewModel myViewModel;
        private final ServiceViewNavBarRoot myRoot = new ServiceViewNavBarRoot();

        ServiceViewNavBarModel(@NotNull Project project, @NotNull NavBarModelListener notificator) {
            super(project, notificator, null);
        }

        void setViewModel(@NotNull ServiceViewModel viewModel) {
            this.myViewModel = viewModel;
        }

        @Override
        protected void updateModel(DataContext dataContext) {
        }

        @Override
        protected void updateModel(PsiElement psiElement, NavBarModelExtension ownerExtension) {
        }

        @Override
        public void updateModel(Object object) {
            ArrayList<Object> path = new ArrayList<Object>();
            if (object instanceof ServiceModel.ServiceViewItem) {
                ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)object;
                List<? extends ServiceModel.ServiceViewItem> roots = this.myViewModel.getVisibleRoots();
                do {
                    path.add(item);
                } while ((item = roots.contains(item) ? null : item.getParent()) != null);
            }
            path.add(this.myRoot);
            Collections.reverse(path);
            this.setModel(path, true);
        }

        @Override
        protected boolean hasChildren(Object object) {
            return !this.getChildren(object).isEmpty();
        }

        @Override
        protected List<Object> getChildren(Object object) {
            if (object == this.myRoot) {
                return new ArrayList<Object>(this.myViewModel.getVisibleRoots());
            }
            if (object instanceof ServiceModel.ServiceViewItem) {
                ServiceModel.ServiceNode service;
                if (object instanceof ServiceModel.ServiceNode && (service = (ServiceModel.ServiceNode)object).getProvidingContributor() != null && !service.isChildrenInitialized()) {
                    this.myViewModel.getInvoker().invoke(() -> service.getChildren());
                    return Collections.emptyList();
                }
                return new ArrayList<Object>(this.myViewModel.getChildren((ServiceModel.ServiceViewItem)object));
            }
            return Collections.emptyList();
        }
    }
}

