/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceViewActionProvider {
    @NonNls
    private static final String SERVICE_VIEW_ITEM_TOOLBAR = "ServiceViewItemToolbar";
    @NonNls
    static final String SERVICE_VIEW_ITEM_POPUP = "ServiceViewItemPopup";
    @NonNls
    private static final String SERVICE_VIEW_TREE_TOOLBAR = "ServiceViewTreeToolbar";
    private static final ServiceViewActionProvider ourInstance = new ServiceViewActionProvider();
    private static final AnAction EMPTY_ACTION = new DumbAwareAction(EmptyIcon.ICON_16){

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
        }
    };

    ServiceViewActionProvider() {
    }

    static ServiceViewActionProvider getInstance() {
        return ourInstance;
    }

    ActionToolbar createServiceToolbar(@NotNull JComponent component2) {
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_TOOLBAR);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", actions, false);
        toolbar.setTargetComponent(component2);
        return toolbar;
    }

    JComponent wrapServiceToolbar(@NotNull ActionToolbar toolbar) {
        final JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)toolbar.getComponent(), "Center");
        toolbar.getComponent().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                wrapper2.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                wrapper2.setVisible(false);
            }
        });
        ActionToolbar prototypeToolbar = ServiceViewActionProvider.createPrototypeToolbar();
        JLabel spacer = new JLabel();
        spacer.setPreferredSize(new Dimension(prototypeToolbar.getComponent().getPreferredSize().width, 0));
        wrapper2.add((Component)spacer, "South");
        return wrapper2;
    }

    void installPopupHandler(@NotNull JComponent component2) {
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_POPUP);
        PopupHandler.installPopupHandler((JComponent)component2, (ActionGroup)actions, (String)"ServicesPopup", (ActionManager)ActionManager.getInstance());
    }

    ActionToolbar createMasterComponentToolbar(@NotNull JComponent component2) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (component2 instanceof JTree) {
            ServiceViewTreeExpander treeExpander = new ServiceViewTreeExpander((JTree)component2);
            AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, component2);
            group.add(expandAllAction);
            AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, component2);
            group.add(collapseAllAction);
            group.addSeparator();
        }
        group.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(SERVICE_VIEW_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet(component2, null);
        group.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", (ActionGroup)group, true);
        treeActionsToolBar.setTargetComponent(component2);
        return treeActionsToolBar;
    }

    List<AnAction> getAdditionalGearActions() {
        AnAction showServicesActions = ActionManager.getInstance().getAction("ServiceView.ShowServices");
        return showServicesActions == null ? Collections.emptyList() : Collections.singletonList(showServicesActions);
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull AnActionEvent e) {
        return ServiceViewActionProvider.getSelectedView((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull DataProvider provider) {
        return ServiceViewActionProvider.getSelectedView((Component)ObjectUtils.tryCast((Object)provider.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName()), Component.class));
    }

    @Nullable
    private static ServiceView getSelectedView(@Nullable Component contextComponent) {
        while (contextComponent != null && !(contextComponent instanceof ServiceView)) {
            contextComponent = contextComponent.getParent();
        }
        return (ServiceView)contextComponent;
    }

    private static ActionToolbar createPrototypeToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(EMPTY_ACTION);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup, false);
        toolbar.updateActionsImmediately();
        return toolbar;
    }

    private static AnAction @NotNull [] doGetActions(@Nullable AnActionEvent e, boolean toolbar) {
        ServiceViewDescriptor descriptor2;
        if (e == null) {
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            return AnAction.EMPTY_ARRAY;
        }
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        if (serviceView == null) {
            return AnAction.EMPTY_ARRAY;
        }
        List<ServiceModel.ServiceViewItem> selectedItems = serviceView.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        if (selectedItems.size() == 1) {
            descriptor2 = selectedItems.get(0).getViewDescriptor();
        } else {
            ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selectedItems);
            ServiceViewDescriptor serviceViewDescriptor = descriptor2 = contributor == null ? null : contributor.getViewDescriptor(project);
        }
        if (descriptor2 == null) {
            return AnAction.EMPTY_ARRAY;
        }
        ActionGroup group = toolbar ? descriptor2.getToolbarActions() : descriptor2.getPopupActions();
        return group == null ? AnAction.EMPTY_ARRAY : group.getChildren(e);
    }

    public static class ItemPopupActionGroup
    extends ActionGroup {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return ServiceViewActionProvider.doGetActions(e, false);
        }
    }

    public static class ItemToolbarActionGroup
    extends ActionGroup {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return ServiceViewActionProvider.doGetActions(e, true);
        }
    }

    private static class ServiceViewTreeExpander
    extends DefaultTreeExpander {
        private boolean myFlat;

        ServiceViewTreeExpander(final JTree tree) {
            super(tree);
            TreeModelAdapter listener2 = new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    myFlat = ServiceViewTreeExpander.isFlat(tree.getModel());
                }
            };
            tree.getModel().addTreeModelListener((TreeModelListener)listener2);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener((TreeModelListener)listener2){
                final /* synthetic */ TreeModelListener val$listener;
                {
                    this.val$listener = treeModelListener;
                }

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    Object newValue2;
                    Object oldValue = event.getOldValue();
                    if (oldValue instanceof TreeModel) {
                        ((TreeModel)oldValue).removeTreeModelListener(this.val$listener);
                    }
                    if ((newValue2 = event.getNewValue()) instanceof TreeModel) {
                        ((TreeModel)newValue2).addTreeModelListener(this.val$listener);
                    }
                }
            };
            tree.addPropertyChangeListener("model", propertyChangeListener);
        }

        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private static boolean isFlat(TreeModel treeModel) {
            Object root = treeModel.getRoot();
            if (root == null) {
                return false;
            }
            int childCount = treeModel.getChildCount(root);
            for (int i2 = 0; i2 < childCount; ++i2) {
                Object child2 = treeModel.getChild(root, i2);
                if (treeModel.isLeaf(child2)) continue;
                return false;
            }
            return true;
        }
    }
}

