/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewNavBarPanel;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.execution.services.ServiceViewTree;
import com.intellij.execution.services.ServiceViewTreeModel;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceTreeView
extends ServiceView {
    private static final String ADD_SERVICE_ACTION_ID = "ServiceView.AddService";
    private final ServiceViewTree myTree;
    private final ServiceViewTreeModel myTreeModel;
    private final ServiceViewModel.ServiceViewModelListener myListener;
    private final ServiceViewNavBarPanel myNavBarPanel;
    private volatile ServiceModel.ServiceViewItem myLastSelection;
    private boolean mySelected;
    private volatile Promise<?> myUpdateSelectionPromise;

    ServiceTreeView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui, @NotNull ServiceViewState state) {
        super(new BorderLayout(), project, model, ui);
        this.myTreeModel = new ServiceViewTreeModel(model);
        this.myTree = new ServiceViewTree((TreeModel)((Object)this.myTreeModel), this);
        this.myListener = new ServiceViewTreeModelListener();
        model.addModelListener(this.myListener);
        ServiceViewActionProvider actionProvider = ServiceViewActionProvider.getInstance();
        ui.setServiceToolbar(actionProvider);
        ui.setMasterComponent((JComponent)((Object)this.myTree), actionProvider);
        this.myTree.setDragEnabled(true);
        DnDManager.getInstance().registerSource(ServiceViewDragHelper.createSource(this), (JComponent)((Object)this.myTree));
        DnDManager.getInstance().registerTarget(ServiceViewDragHelper.createTarget((JTree)((Object)this.myTree)), (JComponent)((Object)this.myTree));
        this.add((Component)this.myUi.getComponent(), "Center");
        this.myTree.addTreeSelectionListener(new RestoreSelectionListener());
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        Consumer<ServiceModel.ServiceViewItem> selector = item -> this.select(item.getValue(), item.getRootContributor().getClass()).onSuccess(result2 -> ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            JComponent component2 = this.getUi().getDetailsComponent();
            if (component2 != null) {
                IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)component2, false);
            }
        }));
        this.myNavBarPanel = new ServiceViewNavBarPanel(this.getProject(), true, this.getModel(), selector);
        this.myNavBarPanel.getModel().updateModel((Object)null);
        this.myUi.setNavBar(this.myNavBarPanel);
        if (model instanceof ServiceViewModel.AllServicesModel) {
            ServiceTreeView.setEmptyText((JComponent)((Object)this.myTree), this.myTree.getEmptyText());
        }
        if (state.expandedPaths.isEmpty()) {
            state.treeState.applyTo((JTree)((Object)this.myTree), this.myTreeModel.getRoot());
        } else {
            THashSet roots = new THashSet(model.getVisibleRoots());
            List<TreePath> adjusted = ServiceTreeView.adjustPaths(state.expandedPaths, (Collection<? extends ServiceModel.ServiceViewItem>)roots, this.myTreeModel.getRoot());
            if (!adjusted.isEmpty()) {
                TreeUtil.promiseExpand((JTree)((Object)this.myTree), (TreeVisitor)new PathExpandVisitor(adjusted));
            }
        }
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
        super.dispose();
    }

    @Override
    void saveState(@NotNull ServiceViewState state) {
        super.saveState(state);
        this.myUi.saveState(state);
        state.treeState = TreeState.createOn((JTree)((Object)this.myTree));
        state.expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)this.myTree));
    }

    @Override
    @NotNull
    List<ServiceModel.ServiceViewItem> getSelectedItems() {
        int[] rows = this.myTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            return Collections.emptyList();
        }
        List objects = TreeUtil.collectSelectedUserObjects((JTree)((Object)this.myTree));
        if (objects.size() != rows.length) {
            return ContainerUtil.mapNotNull((Collection)objects, o -> (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)o, ServiceModel.ServiceViewItem.class));
        }
        ArrayList<Pair> objectRows = new ArrayList<Pair>();
        for (int i2 = 0; i2 < rows.length; ++i2) {
            objectRows.add(Pair.create(objects.get(i2), (Object)rows[i2]));
        }
        objectRows.sort(Comparator.comparing(pair -> (Integer)pair.second));
        return ContainerUtil.mapNotNull(objectRows, pair -> (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)pair.first, ServiceModel.ServiceViewItem.class));
    }

    @Override
    Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem selectedItem = this.myLastSelection;
        if (selectedItem == null || !selectedItem.getValue().equals(service)) {
            AsyncPromise result2 = new AsyncPromise();
            this.myTreeModel.findPath(service, contributorClass).onError(arg_0 -> ((AsyncPromise)result2).setError(arg_0)).onSuccess(path -> {
                TreeUtil.promiseSelect((JTree)((Object)this.myTree), (TreeVisitor)new PathSelectionVisitor((TreePath)path)).onError(arg_0 -> ((AsyncPromise)result2).setError(arg_0)).onSuccess(selectedPath -> {
                    result2.setResult(null);
                    this.cancelSelectionUpdate();
                });
                this.cancelSelectionUpdate();
            });
            return result2;
        }
        return Promises.resolvedPromise();
    }

    @Override
    Promise<Void> expand(@NotNull Object service, @NotNull Class<?> contributorClass) {
        AsyncPromise result2 = new AsyncPromise();
        this.myTreeModel.findPath(service, contributorClass).onError(arg_0 -> ((AsyncPromise)result2).setError(arg_0)).onSuccess(path -> TreeUtil.promiseExpand((JTree)((Object)this.myTree), (TreeVisitor)new PathSelectionVisitor((TreePath)path)).onError(arg_0 -> ((AsyncPromise)result2).setError(arg_0)).onSuccess(expandedPath -> result2.setResult(null)));
        return result2;
    }

    @Override
    void onViewSelected() {
        this.mySelected = true;
        if (this.myLastSelection != null) {
            ServiceViewDescriptor descriptor2 = this.myLastSelection.getViewDescriptor();
            this.onViewSelected(descriptor2);
            this.myUi.setDetailsComponent(descriptor2.getContentComponent());
        } else {
            this.myUi.setDetailsComponent(null);
        }
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        if (this.myLastSelection != null) {
            this.myLastSelection.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    void jumpToServices() {
        if (this.myTree.isShowing()) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)((Object)this.myTree), false);
        } else {
            this.myNavBarPanel.rebuildAndSelectTail(true);
        }
    }

    private void onSelectionChanged() {
        ServiceViewDescriptor newDescriptor;
        ServiceViewDescriptor oldDescriptor;
        List<ServiceModel.ServiceViewItem> selected2 = this.getSelectedItems();
        ServiceModel.ServiceViewItem newSelection = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selected2);
        if (Comparing.equal((Object)newSelection, (Object)this.myLastSelection)) {
            return;
        }
        ServiceViewDescriptor serviceViewDescriptor = oldDescriptor = this.myLastSelection == null ? null : this.myLastSelection.getViewDescriptor();
        if (oldDescriptor != null && this.mySelected) {
            oldDescriptor.onNodeUnselected();
        }
        this.myLastSelection = newSelection;
        this.myNavBarPanel.getModel().updateModel(newSelection);
        if (!this.mySelected) {
            return;
        }
        ServiceViewDescriptor serviceViewDescriptor2 = newDescriptor = newSelection == null ? null : newSelection.getViewDescriptor();
        if (newDescriptor != null) {
            newDescriptor.onNodeSelected();
        }
        this.myUi.setDetailsComponent(newDescriptor == null ? null : newDescriptor.getContentComponent());
    }

    private void selectFirstItemIfNeeded() {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            ServiceModel.ServiceViewItem item;
            List<ServiceModel.ServiceViewItem> selected2 = this.getSelectedItems();
            if (selected2.isEmpty() && (item = (ServiceModel.ServiceViewItem)ContainerUtil.getFirstItem(this.getModel().getRoots())) != null) {
                this.select(item.getValue(), item.getRootContributor().getClass());
            }
        });
    }

    private void updateLastSelection() {
        ServiceModel.ServiceViewItem lastSelection = this.myLastSelection;
        WeakReference<Object> itemRef = new WeakReference<Object>((lastSelection == null ? null : this.getModel().findItem(lastSelection)));
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            ServiceModel.ServiceViewItem item;
            List<ServiceModel.ServiceViewItem> selected2 = this.getSelectedItems();
            if (selected2.isEmpty() && (item = (ServiceModel.ServiceViewItem)ContainerUtil.getFirstItem(this.getModel().getRoots())) != null) {
                this.select(item.getValue(), item.getRootContributor().getClass());
                return;
            }
            ServiceModel.ServiceViewItem updatedItem = (ServiceModel.ServiceViewItem)itemRef.get();
            ServiceModel.ServiceViewItem newSelection = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selected2);
            if (Comparing.equal((Object)newSelection, (Object)updatedItem)) {
                newSelection = updatedItem;
            }
            if (Comparing.equal((Object)newSelection, (Object)this.myLastSelection)) {
                this.myLastSelection = newSelection;
                if (this.mySelected && (updatedItem == null || !updatedItem.isRemoved())) {
                    ServiceViewDescriptor descriptor2 = newSelection == null || newSelection.isRemoved() && updatedItem == null ? null : newSelection.getViewDescriptor();
                    this.myUi.setDetailsComponent(descriptor2 == null ? null : descriptor2.getContentComponent());
                }
            }
        });
    }

    private void updateNavBar() {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            ServiceModel.ServiceViewItem item = this.getNavBarItem();
            if (item == null) {
                return;
            }
            WeakReference<ServiceModel.ServiceViewItem> itemRef = new WeakReference<ServiceModel.ServiceViewItem>(item);
            this.getModel().getInvoker().invoke(() -> {
                ServiceModel.ServiceViewItem viewItem = (ServiceModel.ServiceViewItem)itemRef.get();
                if (viewItem == null) {
                    return;
                }
                ServiceModel.ServiceViewItem updatedItem = this.getModel().findItem(viewItem);
                if (updatedItem != null) {
                    WeakReference<ServiceModel.ServiceViewItem> updatedRef = new WeakReference<ServiceModel.ServiceViewItem>(updatedItem);
                    ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
                        ServiceModel.ServiceViewItem updatedViewItem = (ServiceModel.ServiceViewItem)updatedRef.get();
                        if (updatedViewItem == null) {
                            return;
                        }
                        ServiceModel.ServiceViewItem navBarItem = this.getNavBarItem();
                        if (updatedViewItem.equals(navBarItem) && !updatedViewItem.isRemoved()) {
                            this.myNavBarPanel.getModel().updateModel(updatedItem);
                        }
                    });
                }
            });
        });
    }

    private ServiceModel.ServiceViewItem getNavBarItem() {
        NavBarModel navBarModel = this.myNavBarPanel.getModel();
        if (navBarModel.isEmpty()) {
            return null;
        }
        return (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)navBarModel.getElement(navBarModel.size() - 1), ServiceModel.ServiceViewItem.class);
    }

    private void updateSelectionPaths() {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            TreePath[] currentPaths = this.myTree.getSelectionPaths();
            List selectedPaths = currentPaths == null || currentPaths.length == 0 ? Collections.emptyList() : Arrays.asList(currentPaths);
            this.myTreeModel.rootsChanged();
            if (selectedPaths.isEmpty()) {
                return;
            }
            this.myTreeModel.getInvoker().invokeLater(() -> {
                List pathPromises = ContainerUtil.mapNotNull((Collection)selectedPaths, path -> {
                    ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)ObjectUtils.tryCast((Object)path.getLastPathComponent(), ServiceModel.ServiceViewItem.class);
                    return item == null ? null : this.myTreeModel.findPath(item.getValue(), item.getRootContributor().getClass());
                });
                Promises.collectResults((Collection)pathPromises, (boolean)true).onProcessed(paths -> {
                    if (paths != null && !paths.isEmpty()) {
                        if (!paths.equals(selectedPaths)) {
                            Promise newSelectPromise = TreeUtil.promiseSelect((JTree)((Object)this.myTree), paths.stream().map(PathSelectionVisitor::new));
                            this.cancelSelectionUpdate();
                            if (newSelectPromise instanceof AsyncPromise) {
                                ((AsyncPromise)newSelectPromise).onError(t -> {
                                    if (t instanceof CancellationException) {
                                        TreeUtil.promiseExpand((JTree)((Object)this.myTree), paths.stream().map(path -> new PathSelectionVisitor(path.getParentPath())));
                                    }
                                });
                            }
                            this.myUpdateSelectionPromise = newSelectPromise;
                        } else {
                            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
                                Object[] selectionPaths = this.myTree.getSelectionPaths();
                                if (selectionPaths != null && ServiceTreeView.isSelectionUpdateNeeded((List<TreePath>)new SmartList(selectionPaths), paths)) {
                                    this.myTree.setSelectionPaths(paths.toArray(new TreePath[0]));
                                }
                            });
                        }
                    }
                });
            });
        });
    }

    private static boolean isSelectionUpdateNeeded(List<TreePath> selectionPaths, List<TreePath> updatedPaths) {
        if (selectionPaths.size() != updatedPaths.size()) {
            return false;
        }
        boolean result2 = false;
        for (int i2 = 0; i2 < selectionPaths.size(); ++i2) {
            TreePath selectionPath = selectionPaths.get(i2);
            TreePath updatedPath = updatedPaths.get(i2);
            do {
                Object updatedComponent;
                if (updatedPath == null) {
                    return false;
                }
                Object selectedComponent = selectionPath.getLastPathComponent();
                if (selectedComponent != (updatedComponent = updatedPath.getLastPathComponent())) {
                    if (!selectedComponent.equals(updatedComponent)) {
                        return false;
                    }
                    result2 = true;
                }
                selectionPath = selectionPath.getParentPath();
                updatedPath = updatedPath.getParentPath();
            } while (selectionPath != null);
            if (updatedPath == null) continue;
            return false;
        }
        return result2;
    }

    @Override
    void setAutoScrollToSourceHandler(@NotNull AutoScrollToSourceHandler autoScrollToSourceHandler) {
        super.setAutoScrollToSourceHandler(autoScrollToSourceHandler);
        autoScrollToSourceHandler.install((JTree)((Object)this.myTree));
    }

    @Override
    List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath) {
        LinkedList<Object> values2 = new LinkedList<Object>(valueSubPath);
        Object visibleRoot = values2.poll();
        if (visibleRoot == null) {
            return Collections.emptyList();
        }
        int count = this.myTree.getRowCount();
        for (int i2 = 0; i2 < count; ++i2) {
            ServiceModel.ServiceViewItem item;
            TreePath path = this.myTree.getPathForRow(i2);
            Object node = path.getLastPathComponent();
            if (!(node instanceof ServiceModel.ServiceViewItem) || !visibleRoot.equals((item = (ServiceModel.ServiceViewItem)node).getValue())) continue;
            while (!values2.isEmpty()) {
                Object value2 = values2.poll();
                item = (ServiceModel.ServiceViewItem)ContainerUtil.find(this.getModel().getChildren(item), child2 -> value2.equals(child2.getValue()));
                if (item != null) continue;
                return Collections.emptyList();
            }
            return ContainerUtil.map(this.getModel().getChildren(item), ServiceModel.ServiceViewItem::getValue);
        }
        return Collections.emptyList();
    }

    private void cancelSelectionUpdate() {
        Promise<?> selectPromise = this.myUpdateSelectionPromise;
        if (selectPromise instanceof AsyncPromise) {
            ((AsyncPromise)selectPromise).cancel();
        }
    }

    private static void setEmptyText(final JComponent component2, StatusText emptyText) {
        Shortcut shortcut;
        emptyText.setText(ExecutionBundle.message((String)"service.view.empty.tree.text", (Object[])new Object[0]));
        emptyText.appendSecondaryText(ExecutionBundle.message((String)"service.view.add.service.action.name", (Object[])new Object[0]), new SimpleTextAttributes(0, JBUI.CurrentTheme.Link.linkColor()), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionGroup addActionGroup = (ActionGroup)ObjectUtils.tryCast((Object)ActionManager.getInstance().getAction(ServiceTreeView.ADD_SERVICE_ACTION_ID), ActionGroup.class);
                if (addActionGroup == null) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)component2);
                JBPopupFactory.getInstance().createActionGroupPopup(addActionGroup.getTemplatePresentation().getText(), addActionGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, null, ActionPlaces.getActionGroupPopupPlace((String)ServiceTreeView.ADD_SERVICE_ACTION_ID)).show(new RelativePoint((Component)component2, component2.getMousePosition()));
            }
        });
        AnAction addAction = ActionManager.getInstance().getAction(ADD_SERVICE_ACTION_ID);
        ShortcutSet shortcutSet = addAction == null ? null : addAction.getShortcutSet();
        Shortcut shortcut2 = shortcut = shortcutSet == null ? null : (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts());
        if (shortcut != null) {
            emptyText.appendSecondaryText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
    }

    private static List<TreePath> adjustPaths(List<TreePath> paths, Collection<? extends ServiceModel.ServiceViewItem> roots, Object treeRoot) {
        SmartList result2 = new SmartList();
        block0: for (TreePath path : paths) {
            Object[] items = path.getPath();
            for (int i2 = 1; i2 < items.length; ++i2) {
                if (!roots.contains(items[i2])) continue;
                Object[] adjustedItems = new Object[items.length - i2 + 1];
                adjustedItems[0] = treeRoot;
                System.arraycopy(items, i2, adjustedItems, 1, items.length - i2);
                result2.add(new TreePath(adjustedItems));
                continue block0;
            }
        }
        return result2;
    }

    private static class PathExpandVisitor
    implements TreeVisitor {
        private final List<TreePath> myPaths;

        PathExpandVisitor(List<TreePath> paths) {
            this.myPaths = paths;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            if (path.getParentPath() == null) {
                return TreeVisitor.Action.CONTINUE;
            }
            for (TreePath treePath : this.myPaths) {
                if (!treePath.equals(path)) continue;
                this.myPaths.remove(treePath);
                return this.myPaths.isEmpty() ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
            }
            return TreeVisitor.Action.SKIP_CHILDREN;
        }
    }

    private static class PathSelectionVisitor
    implements TreeVisitor {
        private final Queue<Object> myPath;

        PathSelectionVisitor(TreePath path) {
            this.myPath = ContainerUtil.newLinkedList((Object[])path.getPath());
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            Object node = path.getLastPathComponent();
            if (node.equals(this.myPath.peek())) {
                this.myPath.poll();
                return this.myPath.isEmpty() ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
            }
            return TreeVisitor.Action.SKIP_CHILDREN;
        }
    }

    private class ServiceViewTreeModelListener
    implements ServiceViewModel.ServiceViewModelListener {
        private ServiceViewTreeModelListener() {
        }

        @Override
        public void eventProcessed(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ServiceEventListener.ServiceEvent e) {
            if (e.type == ServiceEventListener.EventType.SYNC_RESET) {
                TreeModel model = ServiceTreeView.this.myTree.getModel();
                if (model instanceof Disposable) {
                    Disposer.dispose((Disposable)((Disposable)model));
                }
                ServiceTreeView.this.myTree.setModel(null);
                AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)ServiceTreeView.this.myTreeModel), ServiceTreeView.this);
                ServiceTreeView.this.myTree.setModel((TreeModel)((Object)asyncTreeModel));
                ServiceTreeView.this.myNavBarPanel.hidePopup();
                ServiceTreeView.this.myNavBarPanel.getModel().updateModel((Object)null);
                ServiceTreeView.this.myNavBarPanel.getUpdateQueue().rebuildUi();
                ServiceTreeView.this.updateLastSelection();
            } else {
                ServiceTreeView.this.updateNavBar();
                ServiceModel.ServiceViewItem lastSelection = ServiceTreeView.this.myLastSelection;
                if (lastSelection != null && lastSelection.getRootContributor().getClass().equals(e.contributorClass)) {
                    ServiceTreeView.this.updateLastSelection();
                } else {
                    ServiceTreeView.this.selectFirstItemIfNeeded();
                }
            }
            ServiceTreeView.this.updateSelectionPaths();
        }

        @Override
        public void structureChanged() {
            ServiceTreeView.this.selectFirstItemIfNeeded();
            ServiceTreeView.this.updateSelectionPaths();
        }
    }
}

