/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceSingleView
extends ServiceView {
    private final AtomicReference<ServiceModel.ServiceViewItem> myRef = new AtomicReference();
    private boolean mySelected;
    private final ServiceViewModel.ServiceViewModelListener myListener;

    ServiceSingleView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui) {
        super(new BorderLayout(), project, model, ui);
        ui.setServiceToolbar(ServiceViewActionProvider.getInstance());
        this.add((Component)ui.getComponent(), "Center");
        this.myListener = this::updateItem;
        model.addModelListener(this.myListener);
        model.getInvoker().invokeLater(this::updateItem);
    }

    @Override
    @NotNull
    Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item == null || !item.getValue().equals(service)) {
            return Promises.rejectedPromise((String)"Service not found");
        }
        this.showContent();
        return Promises.resolvedPromise();
    }

    @Override
    Promise<Void> expand(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem item = this.myRef.get();
        return item == null || !item.getValue().equals(service) ? Promises.rejectedPromise((String)"Service not found") : Promises.resolvedPromise();
    }

    @Override
    void onViewSelected() {
        this.showContent();
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            item.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    @NotNull
    List<ServiceModel.ServiceViewItem> getSelectedItems() {
        ServiceModel.ServiceViewItem item = this.myRef.get();
        return item == null ? Collections.emptyList() : Collections.singletonList(item);
    }

    @Override
    void jumpToServices() {
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
    }

    private void updateItem() {
        WeakReference<ServiceModel.ServiceViewItem> oldValueRef = new WeakReference<ServiceModel.ServiceViewItem>(this.myRef.get());
        ServiceModel.ServiceViewItem newValue2 = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(this.getModel().getRoots());
        WeakReference<ServiceModel.ServiceViewItem> newValueRef = new WeakReference<ServiceModel.ServiceViewItem>(newValue2);
        this.myRef.set(newValue2);
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.getProject())).submit(() -> {
            ServiceModel.ServiceViewItem value2;
            if (this.mySelected && (value2 = (ServiceModel.ServiceViewItem)newValueRef.get()) != null) {
                ServiceViewDescriptor descriptor2 = value2.getViewDescriptor();
                if (oldValueRef.get() == null) {
                    this.onViewSelected(descriptor2);
                }
                this.myUi.setDetailsComponent(descriptor2.getContentComponent());
            }
        });
    }

    private void showContent() {
        if (this.mySelected) {
            return;
        }
        this.mySelected = true;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            ServiceViewDescriptor descriptor2 = item.getViewDescriptor();
            this.onViewSelected(descriptor2);
            this.myUi.setDetailsComponent(descriptor2.getContentComponent());
        }
    }

    @Override
    List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath) {
        return Collections.emptyList();
    }
}

