/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RerunTestsAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    public static final String ID = "RerunTests";
    private static final Set<RunContentDescriptor> REGISTRY = new HashSet<RunContentDescriptor>();

    public static void register(final @NotNull RunContentDescriptor descriptor2) {
        if (!Disposer.isDisposed((Disposable)descriptor2) && REGISTRY.add(descriptor2)) {
            Disposer.register((Disposable)descriptor2, (Disposable)new Disposable(){

                public void dispose() {
                    REGISTRY.remove(descriptor2);
                }
            });
        }
    }

    @Deprecated
    public static void register(@NotNull ExecutionEnvironment environment) {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ArrayList<RunContentDescriptor> descriptors = new ArrayList<RunContentDescriptor>(REGISTRY);
        for (RunContentDescriptor descriptor2 : descriptors) {
            RunContentManager runContentManager;
            if (Disposer.isDisposed((Disposable)descriptor2)) {
                REGISTRY.remove(descriptor2);
                continue;
            }
            Project project = e.getProject();
            if (project == null || (runContentManager = RunContentManager.getInstance((Project)project)).getToolWindowByDescriptor(descriptor2) == null) continue;
            ExecutionUtil.restart((RunContentDescriptor)descriptor2);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null);
    }
}

