/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.execution.ExecutorRegistryImpl;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerActionWrapper
extends ActionGroup
implements PriorityAction,
ActionWithDelegate<AnAction> {
    private static final Logger LOG = Logger.getInstance(LineMarkerActionWrapper.class);
    public static final Key<Pair<PsiElement, MyDataContext>> LOCATION_WRAPPER = Key.create((String)"LOCATION_WRAPPER");
    protected final PsiElement myElement;
    private final AnAction myOrigin;

    public LineMarkerActionWrapper(PsiElement element2, @NotNull AnAction origin) {
        this.myElement = element2;
        this.myOrigin = origin;
        this.copyFrom(origin);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (this.myOrigin instanceof ExecutorAction && ((ExecutorAction)this.myOrigin).getOrigin() instanceof ExecutorRegistryImpl.ExecutorGroupActionGroup) {
            Object[] children2 = ((ExecutorRegistryImpl.ExecutorGroupActionGroup)((ExecutorAction)this.myOrigin).getOrigin()).getChildren(null);
            LOG.assertTrue(ContainerUtil.all(Arrays.asList(children2), o -> o instanceof RunContextAction));
            return ContainerUtil.map((Object[])children2, o -> new LineMarkerActionWrapper(this.myElement, (AnAction)o)).toArray(AnAction.EMPTY_ARRAY);
        }
        if (this.myOrigin instanceof ActionGroup) {
            return ((ActionGroup)this.myOrigin).getChildren(e == null ? null : this.wrapEvent(e));
        }
        return AnAction.EMPTY_ARRAY;
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        return !(this.myOrigin instanceof ActionGroup) || ((ActionGroup)this.myOrigin).canBePerformed(this.wrapContext(context));
    }

    public boolean isDumbAware() {
        return this.myOrigin.isDumbAware();
    }

    public boolean isPopup() {
        return !(this.myOrigin instanceof ActionGroup) || ((ActionGroup)this.myOrigin).isPopup();
    }

    public boolean hideIfNoVisibleChildren() {
        return this.myOrigin instanceof ActionGroup && ((ActionGroup)this.myOrigin).hideIfNoVisibleChildren();
    }

    public boolean disableIfNoVisibleChildren() {
        return !(this.myOrigin instanceof ActionGroup) || ((ActionGroup)this.myOrigin).disableIfNoVisibleChildren();
    }

    public void update(@NotNull AnActionEvent e) {
        AnActionEvent wrapped = this.wrapEvent(e);
        this.myOrigin.update(wrapped);
        Icon icon2 = wrapped.getPresentation().getIcon();
        if (icon2 != null) {
            this.getTemplatePresentation().setIcon(icon2);
        }
    }

    @NotNull
    private AnActionEvent wrapEvent(@NotNull AnActionEvent e) {
        DataContext dataContext = this.wrapContext(e.getDataContext());
        return new AnActionEvent(e.getInputEvent(), dataContext, e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
    }

    @NotNull
    private DataContext wrapContext(DataContext dataContext) {
        Pair pair = (Pair)DataManager.getInstance().loadFromDataContext(dataContext, LOCATION_WRAPPER);
        if (pair == null || pair.first != this.myElement) {
            pair = Pair.pair((Object)this.myElement, (Object)((Object)new MyDataContext(dataContext)));
            DataManager.getInstance().saveInDataContext(dataContext, LOCATION_WRAPPER, (Object)pair);
        }
        return (DataContext)pair.second;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myOrigin.actionPerformed(this.wrapEvent(e));
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }

    @NotNull
    public AnAction getDelegate() {
        return this.myOrigin;
    }

    private class MyDataContext
    extends UserDataHolderBase
    implements DataContext {
        private final DataContext myDelegate;

        MyDataContext(DataContext delegate) {
            this.myDelegate = delegate;
        }

        @Nullable
        public synchronized Object getData(@NotNull @NonNls String dataId) {
            if (Location.DATA_KEY.is(dataId)) {
                return LineMarkerActionWrapper.this.myElement.isValid() ? new PsiLocation(LineMarkerActionWrapper.this.myElement) : null;
            }
            return this.myDelegate.getData(dataId);
        }
    }
}

