/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.NewRunConfigurationTreePopupFactory;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunConfigurationListManagerHelperKt;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNewRunConfigurationTreePopupFactory
extends NewRunConfigurationTreePopupFactory {
    private NodeDescriptor<?> root;
    private List<GroupDescriptor> myGroups;
    private NodeDescriptor<?> other;
    private List<ConfigurationType> myTypesToShow;
    private List<ConfigurationType> myOtherTypes;

    public DefaultNewRunConfigurationTreePopupFactory() {
        ConfigurationType.CONFIGURATION_TYPE_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConfigurationType>(){

            public void extensionRemoved(@NotNull ConfigurationType extension, @NotNull PluginDescriptor pluginDescriptor) {
                DefaultNewRunConfigurationTreePopupFactory.this.myTypesToShow = null;
                DefaultNewRunConfigurationTreePopupFactory.this.myOtherTypes = null;
                DefaultNewRunConfigurationTreePopupFactory.this.myGroups = null;
            }
        }, null);
    }

    public void initStructure(@NotNull Project project) {
        this.root = this.createDescriptor(project, "<invisible-templates-root>", null);
        this.other = this.createDescriptor(project, ExecutionBundle.message((String)"add.new.run.configuration.other.types.node.text", (Object[])new Object[0]), this.root, 31);
        this.myTypesToShow = new ArrayList<ConfigurationType>(RunConfigurable.Companion.configurationTypeSorted(project, true, ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()));
        this.myOtherTypes = new ArrayList<ConfigurationType>(ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList());
        this.myOtherTypes.sort((o1, o2) -> RunConfigurationListManagerHelperKt.compareTypesForUi(o1, o2));
        this.myOtherTypes.removeAll(this.myTypesToShow);
        this.myGroups = this.createGroups(project, this.myTypesToShow);
    }

    @NotNull
    public NodeDescriptor<?> getRootElement() {
        return this.root;
    }

    protected List<GroupDescriptor> createGroups(@NotNull Project project, @NotNull List<ConfigurationType> fullList) {
        return Arrays.asList(new GroupDescriptor[0]);
    }

    protected static List<ConfigurationType> getTypes(List<ConfigurationType> fullList, String ... ids) {
        List<String> idsList = Arrays.asList(ids);
        ArrayList<ConfigurationType> result2 = new ArrayList<ConfigurationType>();
        Iterator<ConfigurationType> iterator2 = fullList.iterator();
        while (iterator2.hasNext()) {
            ConfigurationType type = iterator2.next();
            if (!idsList.contains(type.getId())) continue;
            result2.add(type);
            iterator2.remove();
        }
        return result2;
    }

    public NodeDescriptor<?>[] createChildElements(@NotNull Project project, @NotNull NodeDescriptor nodeDescriptor) {
        Object[] factories2;
        Object nodeDescriptorElement = nodeDescriptor.getElement();
        if (this.root.equals((Object)nodeDescriptor)) {
            ArrayList<Object> list2 = new ArrayList<Object>();
            for (GroupDescriptor group : this.myGroups) {
                if (group.myTypes.isEmpty()) continue;
                list2.add((Object)group);
            }
            list2.addAll(Arrays.asList(this.convertToDescriptors(project, nodeDescriptor, this.myTypesToShow.toArray())));
            if (!this.myOtherTypes.isEmpty()) {
                list2.add(this.other);
            }
            return list2.toArray(NodeDescriptor.EMPTY_ARRAY);
        }
        if (nodeDescriptor instanceof GroupDescriptor) {
            ArrayList<NodeDescriptor> list3 = new ArrayList<NodeDescriptor>();
            for (ConfigurationType type : ((GroupDescriptor)nodeDescriptor).myTypes) {
                list3.add(this.createDescriptor(project, type, nodeDescriptor));
            }
            return list3.toArray(NodeDescriptor.EMPTY_ARRAY);
        }
        if (this.other.equals((Object)nodeDescriptor)) {
            return this.convertToDescriptors(project, nodeDescriptor, this.myOtherTypes.toArray());
        }
        if (nodeDescriptorElement instanceof ConfigurationType && (factories2 = ((ConfigurationType)nodeDescriptorElement).getConfigurationFactories()).length > 1) {
            return this.convertToDescriptors(project, nodeDescriptor, factories2);
        }
        return NodeDescriptor.EMPTY_ARRAY;
    }

    protected static class GroupDescriptor
    extends NodeDescriptor<String> {
        private final List<ConfigurationType> myTypes;

        public GroupDescriptor(@NotNull Project project, @NotNull NodeDescriptor parent, @Nullable Icon icon2, @NotNull String name, List<ConfigurationType> types) {
            super(project, parent);
            this.myTypes = types;
            this.myClosedIcon = icon2;
            this.myName = name;
        }

        public boolean update() {
            return false;
        }

        public String getElement() {
            return this.myName;
        }

        public int getWeight() {
            return 29;
        }
    }
}

