/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultiPsiElementHyperlinkInfo
extends HyperlinkInfoBase {
    private final Map<VirtualFile, SmartPsiElementPointer<?>> myMap;

    MultiPsiElementHyperlinkInfo(Collection<? extends PsiElement> elements2) {
        SmartPointerManager manager = null;
        this.myMap = new LinkedHashMap();
        for (PsiElement psiElement : elements2) {
            if (manager == null) {
                manager = SmartPointerManager.getInstance((Project)psiElement.getProject());
            }
            this.myMap.put(psiElement.getContainingFile().getVirtualFile(), manager.createSmartPsiElementPointer(psiElement));
        }
    }

    public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        if (this.myMap.isEmpty()) {
            return;
        }
        if (this.myMap.size() == 1) {
            Map.Entry<VirtualFile, SmartPsiElementPointer<?>> entry = this.myMap.entrySet().iterator().next();
            MultiPsiElementHyperlinkInfo.navigateTo(project, entry.getKey(), entry.getValue());
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        int width = frame != null ? frame.getSize().width : 200;
        JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.map(this.myMap.values(), ptr -> ptr.getContainingFile())).setTitle(ExecutionBundle.message((String)"popup.title.choose.target.file", (Object[])new Object[0])).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setItemChosenCallback(selectedValue -> {
            VirtualFile file2 = selectedValue.getVirtualFile();
            MultiPsiElementHyperlinkInfo.navigateTo(project, file2, this.myMap.get(file2));
        }).createPopup();
        if (hyperlinkLocationPoint != null) {
            popup2.show(hyperlinkLocationPoint);
        } else {
            popup2.showInFocusCenter();
        }
    }

    private static void navigateTo(@NotNull Project project, VirtualFile file2, SmartPsiElementPointer<?> pointer) {
        Document document;
        PsiElement element2 = pointer.getElement();
        int line = 0;
        int column = 0;
        if (element2 != null && (document = element2.getContainingFile().getViewProvider().getDocument()) != null) {
            int offset = element2.getTextOffset();
            line = document.getLineNumber(offset);
            column = offset - document.getLineStartOffset(line);
        }
        new OpenFileHyperlinkInfo(project, file2, line, column).navigate(project);
    }
}

