/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardFilterActionGroup
extends DefaultActionGroup
implements CheckedActionGroup,
DumbAware {
    public RunDashboardFilterActionGroup() {
        this(null, false);
    }

    public RunDashboardFilterActionGroup(@Nullable String shortName, boolean popup2) {
        super(shortName, popup2);
        RunDashboardRunConfigurationStatus[] statuses;
        for (RunDashboardRunConfigurationStatus status : statuses = new RunDashboardRunConfigurationStatus[]{RunDashboardRunConfigurationStatus.STARTED, RunDashboardRunConfigurationStatus.FAILED, RunDashboardRunConfigurationStatus.STOPPED, RunDashboardRunConfigurationStatus.CONFIGURED}) {
            this.add((AnAction)new RunDashboardStatusFilterToggleAction(status));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Set contributors = (Set)e.getData(ServiceViewActionUtils.CONTRIBUTORS_KEY);
        if (contributors != null) {
            for (ServiceViewContributor contributor : contributors) {
                if (!(contributor instanceof RunDashboardServiceViewContributor)) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    private static class RunDashboardStatusFilterToggleAction
    extends ToggleAction
    implements DumbAware {
        private final RunDashboardRunConfigurationStatus myStatus;

        RunDashboardStatusFilterToggleAction(RunDashboardRunConfigurationStatus status) {
            super(status.getName());
            this.myStatus = status;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            RunDashboardStatusFilter statusFilter = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project)).getStatusFilter();
            return statusFilter.isVisible(this.myStatus);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            RunDashboardManagerImpl manager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
            RunDashboardStatusFilter statusFilter = manager.getStatusFilter();
            if (state) {
                statusFilter.show(this.myStatus);
            } else {
                statusFilter.hide(this.myStatus);
            }
            manager.updateDashboard(true);
        }
    }
}

