/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class UseConsoleInputAction
extends ToggleAction
implements DumbAware {
    private final String processInputStateKey;
    private boolean useProcessStdIn;

    UseConsoleInputAction(@NotNull String processInputStateKey) {
        super(ExecutionBundle.message((String)"action.text.use.console.input", (Object[])new Object[0]), null, AllIcons.Debugger.Console);
        this.processInputStateKey = processInputStateKey;
        this.useProcessStdIn = PropertiesComponent.getInstance().getBoolean(processInputStateKey);
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        return !this.useProcessStdIn;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        this.useProcessStdIn = !state;
        LanguageConsoleView consoleView = (LanguageConsoleView)event.getData(LangDataKeys.CONSOLE_VIEW);
        assert (consoleView != null);
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)consoleView.getProject());
        PsiFile file2 = consoleView.getFile();
        daemonCodeAnalyzer.setHighlightingEnabled(file2, state);
        daemonCodeAnalyzer.restart(file2);
        PropertiesComponent.getInstance().setValue(this.processInputStateKey, this.useProcessStdIn);
        List actions = ActionUtil.getActions((JComponent)consoleView.getConsoleEditor().getComponent());
        ConsoleExecuteAction action2 = (ConsoleExecuteAction)((Object)ContainerUtil.findInstance((Iterable)actions, ConsoleExecuteAction.class));
        action2.myExecuteActionHandler.myUseProcessStdIn = !state;
    }
}

