/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.console.IdeConsoleRootType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunIdeConsoleAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(RunIdeConsoleAction.class);
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<IdeScriptEngineManager.EngineInfo> SELECTED_ENGINE_INFO_KEY = Key.create((String)"SELECTED_ENGINE_INFO_KEY");
    private static final Key<Trinity<IdeScriptEngine, IdeScriptEngineManager.EngineInfo, VirtualFile>> SCRIPT_ENGINE_KEY = Key.create((String)"SCRIPT_ENGINE_KEY");

    public void update(@NotNull AnActionEvent e) {
        IdeScriptEngineManager manager = IdeScriptEngineManager.getInstance();
        e.getPresentation().setVisible(e.getProject() != null);
        e.getPresentation().setEnabled(manager.isInitialized() && !manager.getEngineInfos().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        List<IdeScriptEngineManager.EngineInfo> infos = IdeScriptEngineManager.getInstance().getEngineInfos();
        RunIdeConsoleAction.chooseScriptEngineAndRun(e, infos, (Consumer<? super IdeScriptEngineManager.EngineInfo>)((Consumer)engineInfo -> this.runConsole(project, (IdeScriptEngineManager.EngineInfo)engineInfo)));
    }

    static void chooseScriptEngineAndRun(@NotNull AnActionEvent e, @NotNull List<IdeScriptEngineManager.EngineInfo> infos, @NotNull Consumer<? super IdeScriptEngineManager.EngineInfo> onChosen) {
        if (infos.size() == 1) {
            onChosen.consume((Object)infos.iterator().next());
            return;
        }
        List actions = JBIterable.from(infos).map(engineInfo -> {
            String lang = engineInfo.languageName;
            String eng = engineInfo.engineName;
            if (StringUtil.toLowerCase((String)lang).equals(lang)) {
                lang = StringUtil.capitalize((String)lang);
            }
            if (StringUtil.toLowerCase((String)eng).equals(eng)) {
                eng = StringUtil.capitalize((String)eng);
            }
            String name = lang + " (" + eng + ")";
            PluginDescriptor plugin = engineInfo.plugin;
            String description = LangBundle.message((String)"action.engine.description", (Object[])new Object[]{lang, eng, plugin == null ? "" : LangBundle.message((String)"action.plugin.description", (Object[])new Object[0]) + plugin.getName()});
            return new DumbAwareAction(name, description, null, (Consumer)onChosen, (IdeScriptEngineManager.EngineInfo)engineInfo){
                final /* synthetic */ Consumer val$onChosen;
                final /* synthetic */ IdeScriptEngineManager.EngineInfo val$engineInfo;
                {
                    this.val$onChosen = consumer;
                    this.val$engineInfo = engineInfo;
                    super(x0, x1, x2);
                }

                public void actionPerformed(@NotNull AnActionEvent e1) {
                    this.val$onChosen.consume((Object)this.val$engineInfo);
                }
            };
        }).sort(Comparator.comparing(o -> o.getTemplatePresentation().getText())).toList();
        DefaultActionGroup actionGroup = new DefaultActionGroup(actions);
        JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"popup.title.script.engine", (Object[])new Object[0]), (ActionGroup)actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e.getDataContext());
    }

    protected void runConsole(@NotNull Project project, @NotNull IdeScriptEngineManager.EngineInfo info) {
        List<String> extensions2 = info.fileExtensions;
        try {
            String pathName = PathUtil.makeFileName((String)DEFAULT_FILE_NAME, (String)((String)ContainerUtil.getFirstItem(extensions2)));
            VirtualFile virtualFile = IdeConsoleRootType.getInstance().findFile(project, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile != null) {
                virtualFile.putUserData(SELECTED_ENGINE_INFO_KEY, (Object)info);
                FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        MyRunAction runAction = new MyRunAction();
        for (FileEditor fileEditor : source.getEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor.getComponent());
        }
    }

    private static void executeQuery(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull IdeScriptEngineManager.EngineInfo engineInfo) {
        IdeScriptEngine engine;
        String command = RunIdeConsoleAction.getCommandText(project, editor);
        if (StringUtil.isEmptyOrSpaces((String)command)) {
            return;
        }
        String profile = RunIdeConsoleAction.getProfileText(file2);
        RunContentDescriptor descriptor2 = RunIdeConsoleAction.getConsoleView(project, file2, engineInfo);
        Content content2 = descriptor2.getAttachedContent();
        if (content2 == null) {
            LOG.error("Attached content expected");
            return;
        }
        Trinity data2 = (Trinity)content2.getUserData(SCRIPT_ENGINE_KEY);
        if (data2 != null) {
            engine = (IdeScriptEngine)data2.first;
        } else {
            engine = IdeScriptEngineManager.getInstance().getEngine(engineInfo, null);
            if (engine == null) {
                LOG.error("Script engine not found for: " + file2.getName());
                return;
            }
            content2.putUserData(SCRIPT_ENGINE_KEY, (Object)Trinity.create((Object)engine, (Object)engineInfo, (Object)file2));
        }
        ConsoleViewImpl consoleView = (ConsoleViewImpl)descriptor2.getExecutionConsole();
        RunIdeConsoleAction.prepareEngine(project, engine, descriptor2);
        try {
            long ts = System.currentTimeMillis();
            consoleView.print("> " + command, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            String script = profile == null ? command : profile + "\n" + command;
            Object o = engine.eval(script);
            String prefix = "[" + StringUtil.formatDuration((long)(System.currentTimeMillis() - ts)) + "]";
            consoleView.print(prefix + "=> " + o, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Throwable e) {
            Throwable ex = ExceptionUtil.getRootCause((Throwable)e);
            String message = StringUtil.notNullize((String)StringUtil.nullize((String)ex.getMessage()), (String)ex.toString());
            consoleView.print(ex.getClass().getSimpleName() + ": " + message, ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        RunIdeConsoleAction.selectContent(descriptor2);
    }

    private static void prepareEngine(@NotNull Project project, @NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        IdeConsoleScriptBindings.ensureIdeIsBound(project, engine);
        RunIdeConsoleAction.ensureOutputIsRedirected(engine, descriptor2);
    }

    @Nullable
    private static String getProfileText(@NotNull VirtualFile file2) {
        try {
            VirtualFile folder = file2.getParent();
            VirtualFile profileChild = folder == null ? null : folder.findChild(".profile." + file2.getExtension());
            return profileChild == null ? null : StringUtil.nullize((String)VfsUtilCore.loadText(profileChild));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    private static String getCommandText(@NotNull Project project, @NotNull Editor editor) {
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
        Document document = editor.getDocument();
        if (selectedRange.isEmpty()) {
            int line = document.getLineNumber(selectedRange.getStartOffset());
            selectedRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 != null && file2.getFirstChild() != null && file2.getFirstChild() != file2.getLastChild()) {
                PsiElement parent;
                PsiElement e1 = file2.findElementAt(selectedRange.getStartOffset());
                PsiElement e2 = file2.findElementAt(selectedRange.getEndOffset());
                while (e1 != e2 && (e1 instanceof PsiWhiteSpace || e1 != null && StringUtil.isEmptyOrSpaces((String)e1.getText()))) {
                    e1 = (PsiElement)ObjectUtils.chooseNotNull((Object)e1.getNextSibling(), (Object)PsiTreeUtil.getDeepestFirst((PsiElement)e1.getParent()));
                }
                while (e1 != e2 && (e2 instanceof PsiWhiteSpace || e2 != null && StringUtil.isEmptyOrSpaces((String)e2.getText()))) {
                    e2 = (PsiElement)ObjectUtils.chooseNotNull((Object)e2.getPrevSibling(), (Object)PsiTreeUtil.getDeepestLast((PsiElement)e2.getParent()));
                }
                if (e1 instanceof LeafPsiElement) {
                    e1 = e1.getParent();
                }
                if (e2 instanceof LeafPsiElement) {
                    e2 = e2.getParent();
                }
                PsiElement psiElement = e1 == null ? e2 : (parent = e2 == null ? e1 : PsiTreeUtil.findCommonParent((PsiElement)e1, (PsiElement)e2));
                if (parent != null && parent != file2) {
                    selectedRange = parent.getTextRange();
                }
            }
        }
        return document.getText(selectedRange);
    }

    private static void selectContent(RunContentDescriptor descriptor2) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleViewImpl consoleView = Objects.requireNonNull((ConsoleViewImpl)descriptor2.getExecutionConsole());
        RunContentManager.getInstance((Project)consoleView.getProject()).toFrontRunContent(executor, descriptor2);
    }

    @NotNull
    private static RunContentDescriptor getConsoleView(@NotNull Project project, @NotNull VirtualFile file2, @NotNull IdeScriptEngineManager.EngineInfo engineInfo) {
        for (RunContentDescriptor existing : RunContentManager.getInstance((Project)project).getAllDescriptors()) {
            Trinity data2;
            Content content2 = existing.getAttachedContent();
            if (content2 == null || (data2 = (Trinity)content2.getUserData(SCRIPT_ENGINE_KEY)) == null || !Comparing.equal((Object)file2, (Object)data2.third) || !Comparing.equal((Object)engineInfo, (Object)data2.second)) continue;
            return existing;
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RunIdeConsole", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel2.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, panel2, file2.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.addAll(consoleView.createConsoleActions());
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor2, project));
        RunContentManager.getInstance((Project)project).showRunContent(executor, descriptor2);
        return descriptor2;
    }

    private static void ensureOutputIsRedirected(@NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        ConsoleWriter stdOutWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdOut(), ConsoleWriter.class);
        ConsoleWriter stdErrWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdErr(), ConsoleWriter.class);
        if (stdOutWriter != null && stdOutWriter.getDescriptor() == descriptor2 && stdErrWriter != null && stdErrWriter.getDescriptor() == descriptor2) {
            return;
        }
        WeakReference<RunContentDescriptor> ref = new WeakReference<RunContentDescriptor>(descriptor2);
        engine.setStdOut(new ConsoleWriter(ref, ConsoleViewContentType.NORMAL_OUTPUT));
        engine.setStdErr(new ConsoleWriter(ref, ConsoleViewContentType.ERROR_OUTPUT));
    }

    private static class ConsoleWriter
    extends Writer {
        private final WeakReference<RunContentDescriptor> myDescriptor;
        private final ConsoleViewContentType myOutputType;

        private ConsoleWriter(@NotNull WeakReference<RunContentDescriptor> descriptor2, @NotNull ConsoleViewContentType outputType) {
            this.myDescriptor = descriptor2;
            this.myOutputType = outputType;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return (RunContentDescriptor)this.myDescriptor.get();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RunContentDescriptor descriptor2 = (RunContentDescriptor)this.myDescriptor.get();
            ConsoleViewImpl console = (ConsoleViewImpl)ObjectUtils.tryCast((Object)(descriptor2 != null ? descriptor2.getExecutionConsole() : null), ConsoleViewImpl.class);
            if (console == null) {
                throw new IOException("The console is not available.");
            }
            console.print(new String(cbuf, off, len), this.myOutputType);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private IdeScriptEngineManager.EngineInfo engineInfo;

        private MyRunAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && editor != null && virtualFile != null && (this.engineInfo != null || virtualFile.getUserData(SELECTED_ENGINE_INFO_KEY) != null || virtualFile.getExtension() != null));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (project == null || editor == null || virtualFile == null) {
                return;
            }
            String extension = virtualFile.getExtension();
            IdeScriptEngineManager.EngineInfo engineInfo0 = (IdeScriptEngineManager.EngineInfo)virtualFile.getUserData(SELECTED_ENGINE_INFO_KEY);
            if (this.engineInfo == null && engineInfo0 == null && extension == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (this.engineInfo == null || engineInfo0 != null && !Comparing.equal((Object)engineInfo0, (Object)this.engineInfo) || extension != null && !this.engineInfo.fileExtensions.contains(extension)) {
                virtualFile.putUserData(SELECTED_ENGINE_INFO_KEY, null);
                List infos = engineInfo0 != null ? Collections.singletonList(engineInfo0) : JBIterable.from(IdeScriptEngineManager.getInstance().getEngineInfos()).filter(o -> o.fileExtensions.contains(extension)).toList();
                RunIdeConsoleAction.chooseScriptEngineAndRun(e, infos, (Consumer<? super IdeScriptEngineManager.EngineInfo>)((Consumer)selectedInfo -> {
                    this.engineInfo = selectedInfo;
                    RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.engineInfo);
                }));
            } else {
                RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.engineInfo);
            }
        }
    }
}

