/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationSelectionUtil {
    @NotNull
    public static String getDisplayText(@NotNull RunConfiguration configuration, @Nullable ExecutionTarget target2) {
        return configuration.getType().getDisplayName() + " '" + configuration.getName() + "'" + (target2 != null && target2 != DefaultExecutionTarget.INSTANCE && !target2.isExternallyManaged() ? " | " + target2.getDisplayName() : "");
    }

    public static ListPopup createPopup(final @NotNull Project project, final @NotNull RunManagerImpl runManager, final @NotNull List<? extends RunConfiguration> configurations, final @NotNull BiConsumer<? super List<RunConfiguration>, ? super ExecutionTarget> onSelected) {
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<RunConfiguration>(null, configurations){

            @Nullable
            public ListSeparator getSeparatorAbove(RunConfiguration value2) {
                int i2 = configurations.indexOf(value2);
                if (i2 < 1) {
                    return null;
                }
                RunConfiguration previous = (RunConfiguration)configurations.get(i2 - 1);
                return value2.getType() != previous.getType() ? new ListSeparator() : null;
            }

            public Icon getIconFor(RunConfiguration value2) {
                return value2.getType().getIcon();
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(RunConfiguration value2) {
                return value2.getName();
            }

            @Override
            public PopupStep<?> onChosen(final List<RunConfiguration> selectedConfigs, boolean finalChoice) {
                if (finalChoice) {
                    onSelected.accept(selectedConfigs, null);
                    return FINAL_CHOICE;
                }
                return new BaseListPopupStep<ExecutionTarget>(null, this.getTargets(selectedConfigs)){

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    public Icon getIconFor(ExecutionTarget value2) {
                        return value2.getIcon();
                    }

                    @NotNull
                    public String getTextFor(ExecutionTarget value2) {
                        return value2.getDisplayName();
                    }

                    public PopupStep onChosen(ExecutionTarget selectedTarget, boolean finalChoice) {
                        onSelected.accept(selectedConfigs, selectedTarget);
                        return FINAL_CHOICE;
                    }
                };
            }

            @Override
            public boolean hasSubstep(List<? extends RunConfiguration> selectedValues) {
                return !this.getTargets(selectedValues).isEmpty();
            }

            @NotNull
            public List<ExecutionTarget> getTargets(List<? extends RunConfiguration> selectedValues) {
                LinkedHashSet intersection = new LinkedHashSet();
                for (int i2 = 0; i2 < selectedValues.size(); ++i2) {
                    List targets2;
                    RunConfiguration config2 = selectedValues.get(i2);
                    RunnerAndConfigurationSettingsImpl settings = runManager.getSettings(config2);
                    List list2 = targets2 = settings == null ? Collections.emptyList() : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)settings.getConfiguration());
                    if (i2 == 0) {
                        intersection.addAll(targets2);
                        continue;
                    }
                    intersection.retainAll(targets2);
                }
                return new ArrayList<ExecutionTarget>(intersection);
            }
        });
    }
}

