/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExecutionTargetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ExecutionTargetManagerImpl
extends ExecutionTargetManager
implements PersistentStateComponent<Element> {
    public static final ExecutionTarget MULTIPLE_TARGETS = new ExecutionTarget(){

        @NotNull
        public String getId() {
            return "multiple_targets";
        }

        @NotNull
        public String getDisplayName() {
            return ExecutionBundle.message((String)"multiple.specified", (Object[])new Object[0]);
        }

        public Icon getIcon() {
            return null;
        }

        public boolean canRun(@NotNull RunConfiguration configuration) {
            return true;
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myActiveTargetLock = new Object();
    @Nullable
    private ExecutionTarget myActiveTarget;
    @Nullable
    private String mySavedActiveTargetId;
    @Nullable
    private RunManagerImpl myRunManager;

    public ExecutionTargetManagerImpl(@NotNull Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == ExecutionTargetManagerImpl.this.getRunManager().getSelectedConfiguration()) {
                    ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
                }
            }

            @Override
            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
            }
        });
    }

    @NotNull
    private RunManagerImpl getRunManager() {
        RunManagerImpl runManager = this.myRunManager;
        if (runManager == null) {
            this.myRunManager = runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        }
        return runManager;
    }

    public void setRunManager(@NotNull RunManagerImpl runManager) {
        this.myRunManager = runManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Element state = new Element("state");
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            String id2;
            String string = id2 = this.myActiveTarget == null ? this.mySavedActiveTargetId : this.myActiveTarget.getId();
            if (id2 != null && !id2.equals(DefaultExecutionTarget.INSTANCE.getId())) {
                state.setAttribute("SELECTED_TARGET", id2);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null && this.mySavedActiveTargetId == null) {
                this.mySavedActiveTargetId = state.getAttributeValue("SELECTED_TARGET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionTarget getActiveTarget() {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null) {
                this.updateActiveTarget();
            }
            return this.myActiveTarget;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTarget(@NotNull ExecutionTarget target2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            this.updateActiveTarget(this.getRunManager().getSelectedConfiguration(), target2);
        }
    }

    private void updateActiveTarget() {
        this.updateActiveTarget(this.getRunManager().getSelectedConfiguration());
    }

    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings) {
        this.updateActiveTarget(settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget toSelect2) {
        ExecutionTarget toNotify;
        List<ExecutionTarget> suitable = settings == null ? Collections.singletonList(DefaultExecutionTarget.INSTANCE) : this.getTargetsFor(settings.getConfiguration());
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (toSelect2 == null) {
                toSelect2 = this.myActiveTarget;
            }
            int index = -1;
            if (toSelect2 != null) {
                index = suitable.indexOf(toSelect2);
            } else if (this.mySavedActiveTargetId != null) {
                int size = suitable.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!suitable.get(i2).getId().equals(this.mySavedActiveTargetId)) continue;
                    index = i2;
                    break;
                }
            }
            toNotify = this.doSetActiveTarget(index >= 0 ? suitable.get(index) : this.getDefaultTarget(suitable));
        }
        if (toNotify != null) {
            ((ExecutionTargetListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).activeTargetChanged(toNotify);
        }
    }

    private ExecutionTarget getDefaultTarget(List<? extends ExecutionTarget> suitable) {
        ExecutionTarget result2 = this.mySavedActiveTargetId == null ? (ExecutionTarget)ContainerUtil.find(suitable, ExecutionTarget::isReady) : (ExecutionTarget)ContainerUtil.getFirstItem(suitable);
        return result2 != null ? result2 : DefaultExecutionTarget.INSTANCE;
    }

    @Nullable
    private ExecutionTarget doSetActiveTarget(@NotNull ExecutionTarget newTarget) {
        this.mySavedActiveTargetId = null;
        ExecutionTarget prev = this.myActiveTarget;
        this.myActiveTarget = newTarget;
        if (prev != null && !prev.equals((Object)this.myActiveTarget)) {
            return this.myActiveTarget;
        }
        return null;
    }

    public boolean doCanRun(@Nullable RunConfiguration configuration, @NotNull ExecutionTarget target2) {
        if (configuration == null) {
            return false;
        }
        boolean isCompound = configuration instanceof CompoundRunConfiguration;
        if (isCompound && target2 == MULTIPLE_TARGETS) {
            return true;
        }
        ExecutionTarget defaultTarget = DefaultExecutionTarget.INSTANCE;
        boolean checkFallbackToDefault = isCompound && !target2.equals((Object)defaultTarget);
        return this.doWithEachNonCompoundWithSpecifiedTarget(configuration, (subConfiguration, executionTarget) -> {
            if (!(subConfiguration instanceof TargetAwareRunProfile)) {
                return true;
            }
            if (Registry.is((String)"update.run.configuration.actions.from.cache", (boolean)false) && this.getRunManager().isInvalidInCache((RunConfiguration)subConfiguration)) {
                return false;
            }
            TargetAwareRunProfile targetAwareProfile = (TargetAwareRunProfile)subConfiguration;
            return target2.canRun(subConfiguration) && targetAwareProfile.canRunOn(target2) || checkFallbackToDefault && defaultTarget.canRun(subConfiguration) && targetAwareProfile.canRunOn(defaultTarget);
        });
    }

    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunConfiguration configuration) {
        if (configuration == null) {
            return Collections.emptyList();
        }
        List providers = ExecutionTargetProvider.EXTENSION_NAME.getExtensionList();
        LinkedHashSet<ExecutionTarget> result2 = new LinkedHashSet<ExecutionTarget>();
        THashSet specifiedTargets = new THashSet();
        this.doWithEachNonCompoundWithSpecifiedTarget(configuration, (arg_0, arg_1) -> this.lambda$getTargetsFor$1(providers, result2, (Set)specifiedTargets, arg_0, arg_1));
        if (!result2.isEmpty()) {
            specifiedTargets.forEach(it -> result2.retainAll(Collections.singleton(it)));
            if (result2.isEmpty()) {
                result2.add(MULTIPLE_TARGETS);
            }
        }
        return Collections.unmodifiableList(ContainerUtil.filter(result2, it -> this.doCanRun(configuration, (ExecutionTarget)it)));
    }

    private boolean doWithEachNonCompoundWithSpecifiedTarget(@NotNull RunConfiguration configuration, @NotNull BiPredicate<? super RunConfiguration, ? super ExecutionTarget> action2) {
        THashSet recursionGuard = new THashSet();
        LinkedList<Pair> toProcess2 = new LinkedList<Pair>();
        toProcess2.add(Pair.create((Object)configuration, null));
        while (!toProcess2.isEmpty()) {
            Pair eachWithTarget = (Pair)toProcess2.pollFirst();
            assert (eachWithTarget != null);
            if (!recursionGuard.add(eachWithTarget.first)) continue;
            RunConfiguration eachConfiguration = (RunConfiguration)eachWithTarget.first;
            if (eachConfiguration instanceof CompoundRunConfiguration) {
                for (Map.Entry<RunConfiguration, ExecutionTarget> subConfigWithTarget : ((CompoundRunConfiguration)eachConfiguration).getConfigurationsWithTargets(this.getRunManager()).entrySet()) {
                    toProcess2.add(Pair.create((Object)subConfigWithTarget.getKey(), (Object)subConfigWithTarget.getValue()));
                }
                continue;
            }
            if (action2.test((RunConfiguration)eachWithTarget.first, (ExecutionTarget)eachWithTarget.second)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ExecutionTarget findTargetByIdFor(@Nullable RunConfiguration configuration, @Nullable String id2) {
        if (id2 == null) {
            return null;
        }
        return (ExecutionTarget)ContainerUtil.find(this.getTargetsFor(configuration), it -> it.getId().equals(id2));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateActiveTarget();
    }

    public void reset(@Nullable RunManagerImpl runManager) {
        this.mySavedActiveTargetId = null;
        this.myActiveTarget = null;
        this.myRunManager = runManager;
    }

    private /* synthetic */ boolean lambda$getTargetsFor$1(List providers, LinkedHashSet result2, Set specifiedTargets, RunConfiguration subConfiguration, ExecutionTarget executionTarget) {
        for (ExecutionTargetProvider eachTargetProvider : providers) {
            List supportedTargets = eachTargetProvider.getTargets(this.myProject, subConfiguration);
            if (executionTarget == null) {
                result2.addAll(supportedTargets);
                continue;
            }
            if (!supportedTargets.contains(executionTarget)) continue;
            result2.add(executionTarget);
            specifiedTargets.add(executionTarget);
            break;
        }
        return true;
    }
}

