/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffDrawUtil {
    private static final Logger LOG = Logger.getInstance(DiffDrawUtil.class);
    public static final int STRIPE_LAYER = 4999;
    public static final int DEFAULT_LAYER = 5898;
    public static final int INLINE_LAYER = 5899;
    public static final int LINE_MARKER_LAYER = 5900;
    public static final int LST_LINE_MARKER_LAYER = 5999;
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g, int x1, int x2, int y) {
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            g.setColor(JBColor.border());
            g.drawLine(x1, y, x2, y);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        return DiffDrawUtil.getDividerColor(null);
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        return DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme) {
        Color gutterBackground = scheme.getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        return gutterBackground;
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fill(DiffDrawUtil.makeCurvePath(x1, x2, start1, start2, end1 + 1, end2 + 1));
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((float)1.0f)));
            g.draw(DiffDrawUtil.makeCurve(x1, x2, (start1 + end1) / 2, (start2 + end2) / 2, true));
            g.setStroke(oldStroke);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            DiffDrawUtil.drawCurveLine(g, x1, x2, start1, start2);
            DiffDrawUtil.drawCurveLine(g, x1, x2, end1, end2);
        }
    }

    private static void drawCurveLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2) {
        boolean isHighSlope;
        boolean bl = isHighSlope = Math.abs(x2 - x1) < Math.abs(y2 - y1);
        if (!isHighSlope && DiffDrawUtil.isThickSimpleStroke(g)) {
            g.fill(DiffDrawUtil.makeCurvePath(x1, x2, y1, y2, y1 + 1, y2 + 1));
        } else {
            g.draw(DiffDrawUtil.makeCurve(x1, x2, y1, y2, true));
        }
    }

    private static boolean isThickSimpleStroke(@NotNull Graphics2D g) {
        Stroke stroke = g.getStroke();
        if (stroke instanceof BasicStroke) {
            float strokeWidth = ((BasicStroke)stroke).getLineWidth();
            return (double)strokeWidth == 1.0 && PaintUtil.devValue((double)strokeWidth, (Graphics2D)g) > 1.0;
        }
        return false;
    }

    @NotNull
    private static Path2D makeCurvePath(int x1, int x2, int y11, int y12, int y21, int y22) {
        Path2D.Double path = new Path2D.Double();
        path.append(DiffDrawUtil.makeCurve(x1, x2, y11, y12, true), true);
        path.append(DiffDrawUtil.makeCurve(x1, x2, y21, y22, false), true);
        path.closePath();
        return path;
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        return DiffDrawUtil.lineToY(editor, line, true, false);
    }

    public static int lineToY(@NotNull Editor editor, int line, boolean lineStart) {
        return DiffDrawUtil.lineToY(editor, line, lineStart, false);
    }

    public static int lineToY(@NotNull Editor editor, int line, boolean lineStart, boolean includeInlays) {
        if (line < 0) {
            return 0;
        }
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y = editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getTextLength())).y;
            int tailLines = line - DiffUtil.getLineCount(document) + (lineStart ? 0 : 1);
            return y + editor.getLineHeight() * tailLines;
        }
        if (lineStart) {
            int visualLine = editor.offsetToVisualPosition((int)document.getLineStartOffset((int)line), (boolean)false, (boolean)false).line;
            int inlay = includeInlays ? EditorUtil.getInlaysHeight(editor, visualLine, true) : 0;
            return editor.visualLineToY(visualLine) - inlay;
        }
        int visualLine = editor.offsetToVisualPosition((int)document.getLineEndOffset((int)line), (boolean)true, (boolean)true).line;
        int inlay = includeInlays ? EditorUtil.getInlaysHeight(editor, visualLine, false) : 0;
        return editor.visualLineToY(visualLine) + editor.getLineHeight() + inlay;
    }

    public static int yToLine(@NotNull Editor editor, int y) {
        return editor.xyToLogicalPosition((Point)new Point((int)0, (int)y)).line;
    }

    @NotNull
    public static MarkerRange getGutterMarkerPaintRange(@NotNull Editor editor, int startLine, int endLine) {
        int y2;
        int y1;
        if (startLine == endLine) {
            y1 = startLine == 0 ? DiffDrawUtil.lineToY(editor, 0, true, true) + 1 : DiffDrawUtil.lineToY(editor, startLine - 1, false, true);
            y2 = y1;
        } else {
            y1 = DiffDrawUtil.lineToY(editor, startLine, true, false);
            y2 = DiffDrawUtil.lineToY(editor, endLine - 1, false, false);
        }
        return new MarkerRange(y1, y2);
    }

    @Nullable
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type, final @Nullable Editor editor, final @NotNull BackgroundType background) {
        if (background == BackgroundType.NONE) {
            return null;
        }
        return new TextAttributes(){

            public Color getBackgroundColor() {
                return background == BackgroundType.IGNORED ? type.getIgnoredColor(editor) : type.getColor(editor);
            }
        };
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type, final @NotNull Editor editor) {
        return new TextAttributes(){

            public Color getErrorStripeColor() {
                return type.getMarkerColor(editor);
            }
        };
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type) {
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    @NotNull
    private static LineSeparatorRenderer createDiffLineRenderer(final @NotNull Editor editor, final @Nullable RangeHighlighter parentHighlighter, final @NotNull TextDiffType type, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        return new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                if (parentHighlighter != null && FoldingUtil.isHighlighterFolded(editor, parentHighlighter)) {
                    return;
                }
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                if (placement == SeparatorPlacement.TOP) {
                    ++y;
                }
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, type.getColor(editor), doubleLine, resolved);
            }
        };
    }

    @NotNull
    private static LineMarkerRenderer createFoldingGutterLineRenderer(final @NotNull TextDiffType type, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        return new LineMarkerRendererEx(){

            public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
                EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
                Graphics2D g2 = (Graphics2D)g;
                int x1 = gutter.getWhitespaceSeparatorOffset();
                int x2 = gutter.getWidth();
                int y = r.y;
                if (placement == SeparatorPlacement.BOTTOM) {
                    LOG.warn("BOTTOM gutter line renderers are not supported");
                    y += editor.getLineHeight() - 1;
                }
                DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y, type.getColor(editor), doubleLine, resolved);
            }

            @Override
            @NotNull
            public LineMarkerRendererEx.Position getPosition() {
                return LineMarkerRendererEx.Position.CUSTOM;
            }
        };
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, @Nullable List<? extends DiffFragment> innerFragments) {
        return DiffDrawUtil.createUnifiedChunkHighlighters(editor, deleted, inserted, false, false, innerFragments);
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, boolean excluded, boolean skipped, @Nullable List<? extends DiffFragment> innerFragments) {
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list2 = new ArrayList<RangeHighlighter>();
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (!inserted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (!deleted.isEmpty()) {
            list2.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
        }
        if (innerFragments != null && !skipped) {
            int deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            int insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            for (DiffFragment diffFragment : innerFragments) {
                int deletedWordStart = deletedStartOffset + diffFragment.getStartOffset1();
                int deletedWordEnd = deletedStartOffset + diffFragment.getEndOffset1();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, deletedWordStart, deletedWordEnd, TextDiffType.DELETED));
                int insertedWordStart = insertedStartOffset + diffFragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + diffFragment.getEndOffset2();
                list2.addAll(DiffDrawUtil.createInlineHighlighter(editor, insertedWordStart, insertedWordEnd, TextDiffType.INSERTED));
            }
        }
        return list2;
    }

    @NotNull
    private static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean excludedInEditor, boolean excludedInGutter) {
        return new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(excludedInEditor).withExcludedInGutter(excludedInGutter).done();
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored) {
        return new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).done();
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean resolved, boolean isExcluded, boolean hideWithoutLineNumbers, boolean hideStripeMarkers) {
        return new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withExcluded(isExcluded).withHideWithoutLineNumbers(hideWithoutLineNumbers).withHideStripeMarkers(hideStripeMarkers).done();
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start2, int end, @NotNull TextDiffType type) {
        return new InlineHighlighterBuilder(editor, start2, end, type).done();
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type) {
        if (line == 0) {
            return Collections.emptyList();
        }
        return new LineMarkerBuilder(editor, line, SeparatorPlacement.TOP).withDefaultRenderer(type, false, false, null).withDefaultGutterRenderer(type, false, false).withDefaultStripeAttributes(type).done();
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        return new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition) {
        return DiffDrawUtil.createLineSeparatorHighlighter(editor, offset1, offset2, condition, null);
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition, @Nullable Computable<String> description) {
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(null, offset1, offset2, 5900, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition, description);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        return Collections.singletonList(marker);
    }

    public static class MarkerRange {
        public final int y1;
        public final int y2;

        public MarkerRange(int y1, int y2) {
            this.y1 = y1;
            this.y2 = y2;
        }

        public int component1() {
            return this.y1;
        }

        public int component2() {
            return this.y2;
        }
    }

    static enum BorderType {
        NONE,
        LINE,
        DOTTED;

    }

    static enum BackgroundType {
        NONE,
        DEFAULT,
        IGNORED;

    }

    static class PaintMode {
        @NotNull
        public final BackgroundType background;
        @NotNull
        public final BorderType border;
        public static final PaintMode DEFAULT = new PaintMode(BackgroundType.DEFAULT, BorderType.NONE);
        public static final PaintMode IGNORED = new PaintMode(BackgroundType.IGNORED, BorderType.NONE);
        public static final PaintMode RESOLVED = new PaintMode(BackgroundType.NONE, BorderType.DOTTED);
        public static final PaintMode EXCLUDED_EDITOR = new PaintMode(BackgroundType.NONE, BorderType.LINE);
        public static final PaintMode EXCLUDED_GUTTER = new PaintMode(BackgroundType.IGNORED, BorderType.LINE);

        PaintMode(@NotNull BackgroundType background, @NotNull BorderType border) {
            this.background = background;
            this.border = border;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaintMode mode = (PaintMode)o;
            return this.background == mode.background && this.border == mode.border;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.background, this.border});
        }
    }

    private static class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int offset;
        @NotNull
        private final RangeHighlighter highlighter;
        @Nullable
        private LineSeparatorRenderer lineRenderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;
        @Nullable
        private TextAttributes stripeAttributes;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            this.editor = editor;
            this.placement = placement;
            this.offset = DocumentUtil.getFirstNonSpaceCharOffset(editor.getDocument(), line);
            this.highlighter = editor.getMarkupModel().addRangeHighlighter(null, this.offset, this.offset, 5900, HighlighterTargetArea.LINES_IN_RANGE);
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@Nullable LineSeparatorRenderer lineRenderer) {
            this.lineRenderer = lineRenderer;
            return this;
        }

        @NotNull
        public LineMarkerBuilder withGutterRenderer(@Nullable LineMarkerRenderer gutterRenderer) {
            this.gutterRenderer = gutterRenderer;
            return this;
        }

        @NotNull
        public LineMarkerBuilder withStripeAttributes(@Nullable TextAttributes stripeAttributes) {
            this.stripeAttributes = stripeAttributes;
            return this;
        }

        @NotNull
        public LineMarkerBuilder withDefaultRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine, @Nullable RangeHighlighter parentHighlighter) {
            RangeHighlighter parent = (RangeHighlighter)ObjectUtils.chooseNotNull((Object)parentHighlighter, (Object)this.highlighter);
            LineSeparatorRenderer renderer = DiffDrawUtil.createDiffLineRenderer(this.editor, parent, type, this.placement, doubleLine, dottedLine);
            return this.withRenderer(renderer);
        }

        @NotNull
        public LineMarkerBuilder withDefaultGutterRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine) {
            LineMarkerRenderer renderer = DiffDrawUtil.createFoldingGutterLineRenderer(type, this.placement, doubleLine, dottedLine);
            return this.withGutterRenderer(renderer);
        }

        @NotNull
        public LineMarkerBuilder withDefaultStripeAttributes(@NotNull TextDiffType type) {
            TextAttributes attributes = DiffDrawUtil.getStripeTextAttributes(type, this.editor);
            return this.withStripeAttributes(attributes);
        }

        @NotNull
        public List<RangeHighlighter> done() {
            this.highlighter.setLineSeparatorPlacement(this.placement);
            this.highlighter.setLineSeparatorRenderer(this.lineRenderer);
            this.highlighter.setLineMarkerRenderer(this.gutterRenderer);
            if (this.stripeAttributes == null) {
                return Collections.singletonList(this.highlighter);
            }
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.offset, this.offset, 4999, this.stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            return Arrays.asList(this.highlighter, stripeHighlighter);
        }
    }

    private static class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;

        private InlineHighlighterBuilder(@NotNull Editor editor, int start2, int end, @NotNull TextDiffType type) {
            this.editor = editor;
            this.type = type;
            this.start = start2;
            this.end = end;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, BackgroundType.DEFAULT);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, 5899, attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter, this.type);
            }
            return Collections.singletonList(highlighter);
        }
    }

    public static final class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored = false;
        private boolean resolved = false;
        private boolean excludedInEditor = false;
        private boolean excludedInGutter = false;
        private boolean hideWithoutLineNumbers = false;
        private boolean hideStripeMarkers = false;

        public LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type) {
            this.editor = editor;
            this.type = type;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withExcluded(boolean excluded) {
            this.excludedInEditor = excluded;
            this.excludedInGutter = excluded;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withExcludedInEditor(boolean excluded) {
            this.excludedInEditor = excluded;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withExcludedInGutter(boolean excluded) {
            this.excludedInGutter = excluded;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withHideWithoutLineNumbers(boolean hideWithoutLineNumbers) {
            this.hideWithoutLineNumbers = hideWithoutLineNumbers;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withHideStripeMarkers(boolean hideStripeMarkers) {
            this.hideStripeMarkers = hideStripeMarkers;
            return this;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
            PaintMode editorMode = PaintMode.DEFAULT;
            PaintMode gutterMode = PaintMode.DEFAULT;
            if (this.ignored) {
                editorMode = PaintMode.IGNORED;
            }
            if (this.excludedInEditor) {
                editorMode = PaintMode.EXCLUDED_EDITOR;
            }
            if (this.excludedInGutter) {
                gutterMode = PaintMode.EXCLUDED_GUTTER;
            }
            if (this.resolved) {
                editorMode = PaintMode.RESOLVED;
                gutterMode = PaintMode.RESOLVED;
            }
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isFirstLine = this.startLine == 0;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets2 = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start2 = offsets2.getStartOffset();
            int end = offsets2.getEndOffset();
            TextAttributes attributes = isEmptyRange ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, editorMode.background);
            TextAttributes stripeAttributes = this.hideStripeMarkers || this.resolved || this.excludedInEditor ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            boolean dottedLine = editorMode.border == BorderType.DOTTED;
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(start2, end, 5898, attributes, HighlighterTargetArea.LINES_IN_RANGE);
            highlighters.add(highlighter);
            highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(highlighter, this.type, editorMode, gutterMode, this.hideWithoutLineNumbers, isEmptyRange, isFirstLine, isLastLine));
            if (isEmptyRange) {
                if (isFirstLine) {
                    highlighters.addAll(new LineMarkerBuilder(this.editor, 0, SeparatorPlacement.TOP).withDefaultRenderer(this.type, true, dottedLine, highlighter).done());
                } else {
                    highlighters.addAll(new LineMarkerBuilder(this.editor, this.startLine - 1, SeparatorPlacement.BOTTOM).withDefaultRenderer(this.type, true, dottedLine, highlighter).done());
                }
            } else if (editorMode.border != BorderType.NONE) {
                highlighters.addAll(new LineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.TOP).withDefaultRenderer(this.type, false, dottedLine, highlighter).done());
                highlighters.addAll(new LineMarkerBuilder(this.editor, this.endLine - 1, SeparatorPlacement.BOTTOM).withDefaultRenderer(this.type, false, dottedLine, highlighter).done());
            }
            if (stripeAttributes != null) {
                RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start2, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                highlighters.add(stripeHighlighter);
            }
            return highlighters;
        }
    }
}

