/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.diff.DiffBundle;
import org.jetbrains.annotations.NotNull;

public enum IgnorePolicy {
    DEFAULT("option.ignore.policy.none"),
    TRIM_WHITESPACES("option.ignore.policy.trim"),
    IGNORE_WHITESPACES("option.ignore.policy.whitespaces"),
    IGNORE_WHITESPACES_CHUNKS("option.ignore.policy.whitespaces.empty.lines"),
    FORMATTING("option.ignore.policy.formatting");

    @NotNull
    private final String myTextKey;

    private IgnorePolicy(String textKey) {
        this.myTextKey = textKey;
    }

    @NotNull
    public String getText() {
        return DiffBundle.message((String)this.myTextKey, (Object[])new Object[0]);
    }

    @NotNull
    public ComparisonPolicy getComparisonPolicy() {
        switch (this) {
            case DEFAULT: {
                return ComparisonPolicy.DEFAULT;
            }
            case TRIM_WHITESPACES: {
                return ComparisonPolicy.TRIM_WHITESPACES;
            }
            case IGNORE_WHITESPACES: {
                return ComparisonPolicy.IGNORE_WHITESPACES;
            }
            case IGNORE_WHITESPACES_CHUNKS: {
                return ComparisonPolicy.IGNORE_WHITESPACES;
            }
            case FORMATTING: {
                return ComparisonPolicy.DEFAULT;
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public boolean isShouldTrimChunks() {
        return this == IGNORE_WHITESPACES_CHUNKS;
    }
}

