/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffViewerBase
implements FrameDiffTool.DiffViewer,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(DiffViewerBase.class);
    @NotNull
    private final List<DiffViewerListener> myListeners = new SmartList();
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final ContentDiffRequest myRequest;
    @NotNull
    private final DiffTaskQueue myTaskExecutor = new DiffTaskQueue();
    @NotNull
    private final Alarm myTaskAlarm = new Alarm();
    private volatile boolean myDisposed;

    public DiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request2) {
        this.myProject = context.getProject();
        this.myContext = context;
        this.myRequest = request2;
    }

    @NotNull
    public final FrameDiffTool.ToolbarComponents init() {
        if (LOG.isDebugEnabled() && !ApplicationManager.getApplication().isHeadlessEnvironment() && (this.getComponent().getWidth() <= 0 || this.getComponent().getHeight() <= 0)) {
            LOG.warn("Diff shown for a hidden component, initial scroll position might be invalid", new Throwable());
        }
        this.processContextHints();
        this.onInit();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbarActions();
        components.popupActions = this.createPopupActions();
        components.statusPanel = this.getStatusPanel();
        this.fireEvent(EventType.INIT);
        new UiNotifyConnector((Component)this.getComponent(), new Activatable(){
            private boolean wasNotShownYet = true;

            public void showNotify() {
                DiffViewerBase.this.rediff(this.wasNotShownYet);
                this.wasNotShownYet = false;
            }

            public void hideNotify() {
                DiffViewerBase.this.abortRediff();
            }
        });
        return components;
    }

    public final void dispose() {
        if (this.myDisposed) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            LOG.warn(new Throwable("dispose() not from EDT"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.abortRediff();
            this.updateContextHints();
            this.fireEvent(EventType.DISPOSE);
            this.onDispose();
        });
    }

    protected void processContextHints() {
    }

    protected void updateContextHints() {
    }

    public final void scheduleRediff() {
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        if (this.getComponent().isShowing()) {
            this.myTaskAlarm.addRequest(this::rediff, 300);
        }
    }

    public final void abortRediff() {
        this.myTaskExecutor.abort();
        this.myTaskAlarm.cancelAllRequests();
        this.fireEvent(EventType.REDIFF_ABORTED);
    }

    public final void rediff() {
        this.rediff(false);
    }

    public void rediff(boolean trySync) {
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.fireEvent(EventType.BEFORE_REDIFF);
        this.onBeforeRediff();
        boolean forceEDT = this.forceRediffSynchronously();
        int waitMillis = trySync || this.tryRediffSynchronously() ? 300 : 0;
        this.myTaskExecutor.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator -> {
            Runnable callback2 = this.performRediff((ProgressIndicator)indicator);
            return () -> {
                callback2.run();
                this.onAfterRediff();
                this.fireEvent(EventType.AFTER_REDIFF);
            };
        }), this::onSlowRediff, waitMillis, forceEDT);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        return this.myRequest;
    }

    @NotNull
    public DiffContext getContext() {
        return this.myContext;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected boolean tryRediffSynchronously() {
        return this.myContext.isWindowFocused();
    }

    protected boolean forceRediffSynchronously() {
        return ApplicationManager.getApplication().isWriteAccessAllowed();
    }

    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(ActionManager.getInstance().getAction("Diff.ViewerToolbar"));
        return group;
    }

    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(ActionManager.getInstance().getAction("Diff.ViewerPopupMenu"));
        return group;
    }

    @Nullable
    protected JComponent getStatusPanel() {
        return null;
    }

    protected void onInit() {
    }

    protected void onSlowRediff() {
    }

    protected void onBeforeRediff() {
    }

    protected void onAfterRediff() {
    }

    @NotNull
    protected abstract Runnable performRediff(@NotNull ProgressIndicator var1);

    protected void onDispose() {
        Disposer.dispose((Disposable)this.myTaskAlarm);
    }

    @Nullable
    protected Navigatable getNavigatable() {
        return null;
    }

    public void addListener(@NotNull DiffViewerListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DiffViewerListener listener2) {
        this.myListeners.remove(listener2);
    }

    @NotNull
    protected List<DiffViewerListener> getListeners() {
        return this.myListeners;
    }

    private void fireEvent(@NotNull EventType type) {
        for (DiffViewerListener listener2 : this.myListeners) {
            switch (type) {
                case INIT: {
                    listener2.onInit();
                    break;
                }
                case DISPOSE: {
                    listener2.onDispose();
                    break;
                }
                case BEFORE_REDIFF: {
                    listener2.onBeforeRediff();
                    break;
                }
                case AFTER_REDIFF: {
                    listener2.onAfterRediff();
                    break;
                }
                case REDIFF_ABORTED: {
                    listener2.onRediffAborted();
                }
            }
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (DiffDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getNavigatable();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private static enum EventType {
        INIT,
        DISPOSE,
        BEFORE_REDIFF,
        AFTER_REDIFF,
        REDIFF_ABORTED;

    }
}

