/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UnifiedEditorHighlighter
implements EditorHighlighter {
    private static final Logger LOG = Logger.getInstance(UnifiedEditorHighlighter.class);
    @NotNull
    private final Document myDocument;
    @NotNull
    private final List<Element> myPieces;

    UnifiedEditorHighlighter(@NotNull Document document, @NotNull EditorHighlighter highlighter1, @NotNull EditorHighlighter highlighter2, @NotNull List<HighlightRange> ranges, int textLength) {
        this.myDocument = document;
        this.myPieces = new ArrayList<Element>();
        this.init(highlighter1.createIterator(0), highlighter2.createIterator(0), ranges, textLength);
    }

    private void init(@NotNull HighlighterIterator it1, @NotNull HighlighterIterator it2, @NotNull List<HighlightRange> ranges, int textLength) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int offset = 0;
        block0: for (HighlightRange range2 : ranges) {
            TextRange base = range2.getBase();
            TextRange changed2 = range2.getChanged();
            if (base.isEmpty()) continue;
            if (base.getStartOffset() > offset) {
                this.addElement(new Element(offset, base.getStartOffset(), null, TextAttributes.ERASE_MARKER));
                offset = base.getStartOffset();
            }
            HighlighterIterator it = (HighlighterIterator)range2.getSide().select((Object)it1, (Object)it2);
            while (!it.atEnd() && changed2.getStartOffset() >= it.getEnd()) {
                it.advance();
            }
            if (it.atEnd()) {
                LOG.error("Unexpected end of highlighter");
                break;
            }
            if (changed2.getEndOffset() <= it.getStart()) continue;
            do {
                int relativeStart = Math.max(it.getStart() - changed2.getStartOffset(), 0);
                int relativeEnd = Math.min(it.getEnd() - changed2.getStartOffset(), changed2.getLength() + 1);
                this.addElement(new Element(offset + relativeStart, offset + relativeEnd, it.getTokenType(), it.getTextAttributes()));
                if (changed2.getEndOffset() <= it.getEnd()) {
                    offset += changed2.getLength();
                    continue block0;
                }
                it.advance();
            } while (!it.atEnd());
            LOG.error("Unexpected end of highlighter");
        }
        if (offset < textLength) {
            this.addElement(new Element(offset, textLength, null, TextAttributes.ERASE_MARKER));
        }
    }

    private void addElement(@NotNull Element element2) {
        Element oldElement;
        boolean merged = false;
        if (!this.myPieces.isEmpty() && (oldElement = this.myPieces.get(this.myPieces.size() - 1)).getEnd() >= element2.getStart() && Comparing.equal((Object)oldElement.getAttributes(), (Object)element2.getAttributes()) && Comparing.equal((Object)oldElement.getElementType(), (Object)element2.getElementType())) {
            merged = true;
            this.myPieces.remove(this.myPieces.size() - 1);
            this.myPieces.add(new Element(oldElement.getStart(), element2.getEnd(), element2.getElementType(), element2.getAttributes()));
        }
        if (!merged) {
            this.myPieces.add(element2);
        }
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index = Collections.binarySearch(this.myPieces, new Element(startOffset, 0, null, null), Comparator.comparingInt(Element::getStart));
        if (index < 0) {
            index = Math.max(-index - 2, 0);
        }
        return new ProxyIterator(this.myDocument, index, this.myPieces);
    }

    public void setEditor(@NotNull HighlighterClient editor) {
    }

    private static class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start2, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start2;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private static class ProxyIterator
    implements HighlighterIterator {
        @NotNull
        private final Document myDocument;
        private int myIdx;
        private final List<Element> myPieces;

        private ProxyIterator(@NotNull Document document, int idx, @NotNull List<Element> pieces) {
            this.myDocument = document;
            this.myIdx = idx;
            this.myPieces = pieces;
        }

        public TextAttributes getTextAttributes() {
            return this.myPieces.get(this.myIdx).getAttributes();
        }

        public int getStart() {
            return this.myPieces.get(this.myIdx).getStart();
        }

        public int getEnd() {
            return this.myPieces.get(this.myIdx).getEnd();
        }

        public IElementType getTokenType() {
            return this.myPieces.get(this.myIdx).myElementType;
        }

        public void advance() {
            if (this.myIdx < this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= this.myPieces.size();
        }

        @NotNull
        public Document getDocument() {
            return this.myDocument;
        }
    }
}

