/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProcessor;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeWindow {
    private static final Logger LOG = Logger.getInstance(MergeWindow.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffDialogHints myHints;
    private MergeRequestProcessor myProcessor;
    private WindowWrapper myWrapper;

    public MergeWindow(@Nullable Project project, @NotNull DiffDialogHints hints2) {
        this.myProject = project;
        this.myHints = hints2;
    }

    protected void init() {
        if (this.myWrapper != null) {
            return;
        }
        this.myProcessor = this.createProcessor();
        String dialogGroupKey = (String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY);
        if (dialogGroupKey == null) {
            dialogGroupKey = "MergeDialog";
        }
        this.myWrapper = new WindowWrapperBuilder(DiffUtil.getWindowMode(this.myHints), new MyPanel(this.myProcessor.getComponent())).setProject(this.myProject).setParent(this.myHints.getParent()).setDimensionServiceKey(dialogGroupKey).setPreferredFocusedComponent((Computable<JComponent>)((Computable)() -> this.myProcessor.getPreferredFocusedComponent())).setOnShowCallback(() -> this.initProcessor(this.myProcessor)).setOnCloseHandler(() -> this.myProcessor.checkCloseAction()).build();
        this.myWrapper.setImages(DiffUtil.Lazy.DIFF_FRAME_ICONS);
        Disposer.register((Disposable)this.myWrapper, (Disposable)this.myProcessor);
        Consumer wrapperHandler = this.myHints.getWindowConsumer();
        if (wrapperHandler != null) {
            wrapperHandler.consume((Object)this.myWrapper);
        }
    }

    public void show() {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Merge dialog should not be shown under a write action, as it will disable any background activity.");
        }
        this.init();
        this.myWrapper.show();
    }

    @NotNull
    private MergeRequestProcessor createProcessor() {
        return new MergeRequestProcessor(this.myProject){

            @Override
            public void closeDialog() {
                MergeWindow.this.myWrapper.close();
            }

            @Override
            protected void setWindowTitle(@NotNull String title) {
                MergeWindow.this.myWrapper.setTitle(title);
            }

            @Override
            @Nullable
            protected JRootPane getRootPane() {
                RootPaneContainer container2 = (RootPaneContainer)ObjectUtils.tryCast((Object)MergeWindow.this.myWrapper.getWindow(), RootPaneContainer.class);
                return container2 != null ? container2.getRootPane() : null;
            }
        };
    }

    protected abstract void initProcessor(@NotNull MergeRequestProcessor var1);

    public static class ForProducer
    extends MergeWindow {
        @NotNull
        private final MergeRequestProducer myMergeRequestProducer;

        public ForProducer(@Nullable Project project, @NotNull MergeRequestProducer mergeRequestProducer, @NotNull DiffDialogHints hints2) {
            super(project, hints2);
            this.myMergeRequestProducer = mergeRequestProducer;
        }

        @Override
        protected void initProcessor(@NotNull MergeRequestProcessor processor2) {
            processor2.init(this.myMergeRequestProducer);
        }
    }

    public static class ForRequest
    extends MergeWindow {
        @NotNull
        private final MergeRequest myMergeRequest;

        public ForRequest(@Nullable Project project, @NotNull MergeRequest mergeRequest, @NotNull DiffDialogHints hints2) {
            super(project, hints2);
            this.myMergeRequest = mergeRequest;
        }

        @Override
        protected void initProcessor(@NotNull MergeRequestProcessor processor2) {
            processor2.init(this.myMergeRequest);
        }
    }

    private static class MyPanel
    extends JPanel {
        MyPanel(@NotNull JComponent content2) {
            super(new BorderLayout());
            this.add((Component)content2, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }
    }
}

