/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ProxySimpleDiffRequest;
import com.intellij.diff.tools.binary.ThreesideBinaryDiffViewer;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeTool
implements MergeTool {
    public static final BinaryMergeTool INSTANCE = new BinaryMergeTool();

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request2) {
        return new BinaryMergeViewer(context, (ThreesideMergeRequest)request2);
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request2) {
        if (!(request2 instanceof ThreesideMergeRequest)) {
            return false;
        }
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(context);
        for (DiffContent diffContent : ((ThreesideMergeRequest)request2).getContents()) {
            if (BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE.canShowContent(diffContent, diffContext)) continue;
            return false;
        }
        return true;
    }

    public static class BinaryMergeViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ThreesideMergeRequest myMergeRequest;
        @NotNull
        private final DiffContext myDiffContext;
        @NotNull
        private final ContentDiffRequest myDiffRequest;
        @NotNull
        private final MyThreesideViewer myViewer;

        public BinaryMergeViewer(@NotNull MergeContext context, @NotNull ThreesideMergeRequest request2) {
            this.myMergeContext = context;
            this.myMergeRequest = request2;
            this.myDiffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
            this.myDiffRequest = new ProxySimpleDiffRequest(this.myMergeRequest.getTitle(), BinaryMergeViewer.getDiffContents(this.myMergeRequest), BinaryMergeViewer.getDiffContentTitles(this.myMergeRequest), (UserDataHolder)this.myMergeRequest);
            this.myViewer = new MyThreesideViewer(this.myDiffContext, (DiffRequest)this.myDiffRequest);
        }

        @NotNull
        private static List<DiffContent> getDiffContents(@NotNull ThreesideMergeRequest mergeRequest) {
            return new ArrayList<DiffContent>(mergeRequest.getContents());
        }

        @NotNull
        private static List<String> getDiffContentTitles(@NotNull ThreesideMergeRequest mergeRequest) {
            return MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        }

        @NotNull
        public JComponent getComponent() {
            return this.myViewer.getComponent();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
            components.statusPanel = init2.statusPanel;
            components.toolbarActions = init2.toolbarActions;
            components.closeHandler = () -> MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)this.myMergeRequest, this.myMergeContext, false);
            return components;
        }

        @Nullable
        public Action getResolveAction(@NotNull MergeResult result2) {
            if (result2 == MergeResult.RESOLVED) {
                return null;
            }
            return MergeUtil.createSimpleResolveAction(result2, (MergeRequest)this.myMergeRequest, this.myMergeContext, this, false);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @NotNull
        public MyThreesideViewer getViewer() {
            return this.myViewer;
        }

        private static class MyThreesideViewer
        extends ThreesideBinaryDiffViewer {
            MyThreesideViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
                super(context, request2);
            }

            @Override
            public void rediff(boolean trySync) {
            }
        }
    }
}

