/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.NextChangeAction;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.diff.actions.impl.PrevChangeAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.UpdatableDefaultActionGroup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DiffRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<DiffTool> myAvailableTools = new ArrayList<DiffTool>();
    @NotNull
    private final List<DiffTool> myToolOrder = new ArrayList<DiffTool>();
    @Nullable
    private final DiffTool myForcedDiffTool;
    @NotNull
    private final DefaultActionGroup myToolbarGroup;
    @NotNull
    private final DefaultActionGroup myPopupActionGroup;
    @NotNull
    private final UpdatableDefaultActionGroup myTouchbarActionGroup;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    protected final Wrapper myContentPanel;
    @NotNull
    private final ActionToolbar myToolbar;
    @NotNull
    protected final Wrapper myToolbarWrapper;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final MyProgressBar myProgressBar;
    @NotNull
    private DiffRequest myActiveRequest;
    @NotNull
    private ViewerState myState;
    @Nullable
    private ApplyData myQueuedApplyRequest;
    @NotNull
    private IterationState myIterationState = IterationState.NONE;

    public DiffRequestProcessor(@Nullable Project project) {
        this(project, (UserDataHolder)new UserDataHolderBase());
    }

    public DiffRequestProcessor(@Nullable Project project, @NonNls @NotNull String place) {
        this(project, (UserDataHolder)DiffUtil.createUserDataHolder(DiffUserDataKeys.PLACE, place));
    }

    public DiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context) {
        this.myProject = project;
        this.myContext = new MyDiffContext(context);
        this.myActiveRequest = new LoadingDiffRequest();
        this.mySettings = DiffSettingsHolder.DiffSettings.getSettings((String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
        this.myForcedDiffTool = (DiffTool)this.myContext.getUserData(DiffUserDataKeysEx.FORCE_DIFF_TOOL);
        this.updateAvailableDiffTools();
        DiffTool.EP_NAME.addChangeListener(() -> {
            this.updateAvailableDiffTools();
            this.updateRequest(true);
        }, (Disposable)this);
        DiffToolSubstitutor.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        DiffIgnoredRangeProvider.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        this.myToolbarGroup = new DefaultActionGroup();
        this.myPopupActionGroup = new DefaultActionGroup();
        this.myTouchbarActionGroup = new UpdatableDefaultActionGroup();
        TouchbarDataKeys.putActionDescriptor((AnAction)this.myTouchbarActionGroup).setReplaceEsc(false);
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarStatusPanel = new Wrapper();
        this.myProgressBar = new MyProgressBar();
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)this.myToolbarGroup, true);
        this.myToolbar.setTargetComponent((JComponent)((Object)this.myMainPanel));
        this.myToolbarWrapper = new Wrapper(this.myToolbar.getComponent());
        this.myPanel = JBUI.Panels.simplePanel((Component)((Object)this.myMainPanel));
        BorderLayoutPanel statusPanel = JBUI.Panels.simplePanel((Component)this.myToolbarStatusPanel).addToLeft((Component)this.myProgressBar);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarWrapper).addToRight((Component)statusPanel);
        GuiUtils.installVisibilityReferent((JComponent)topPanel, (JComponent)this.myToolbar.getComponent());
        JBSplitter bottomContentSplitter = new JBSplitter(true, "DiffRequestProcessor.BottomComponentSplitter", 0.8f);
        bottomContentSplitter.setFirstComponent((JComponent)this.myContentPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)bottomContentSplitter, "Center");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        JComponent bottomPanel = (JComponent)this.myContext.getUserData(DiffUserDataKeysEx.BOTTOM_PANEL);
        if (bottomPanel != null) {
            bottomContentSplitter.setSecondComponent(bottomPanel);
        }
        if (bottomPanel instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)bottomPanel));
        }
        this.myState = EmptyState.INSTANCE;
        this.myContentPanel.setContent((JComponent)DiffUtil.createMessagePanel(((LoadingDiffRequest)this.myActiveRequest).getMessage()));
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        return toolbarComponents.needTopToolbarBorder;
    }

    protected void reloadRequest() {
        this.updateRequest(true);
    }

    public void updateRequest() {
        this.updateRequest(false);
    }

    public void updateRequest(boolean force) {
        this.updateRequest(force, null);
    }

    public abstract void updateRequest(boolean var1, @Nullable DiffUserDataKeysEx.ScrollToPolicy var2);

    @NotNull
    private FrameDiffTool getFittedTool(boolean applySubstitutor) {
        FrameDiffTool substitutor;
        ErrorDiffTool tool;
        if (this.myForcedDiffTool instanceof FrameDiffTool) {
            return this.myForcedDiffTool.canShow(this.myContext, this.myActiveRequest) ? (FrameDiffTool)this.myForcedDiffTool : ErrorDiffTool.INSTANCE;
        }
        List<FrameDiffTool> tools = this.filterFittedTools(this.myToolOrder);
        ErrorDiffTool errorDiffTool = tool = tools.isEmpty() ? ErrorDiffTool.INSTANCE : tools.get(0);
        if (applySubstitutor && (substitutor = this.findToolSubstitutor((DiffTool)tool)) != null) {
            return substitutor;
        }
        return tool;
    }

    @NotNull
    private List<FrameDiffTool> getAvailableFittedTools() {
        return this.filterFittedTools(this.myAvailableTools);
    }

    @NotNull
    private List<FrameDiffTool> filterFittedTools(@NotNull List<? extends DiffTool> tools) {
        ArrayList<FrameDiffTool> result2 = new ArrayList<FrameDiffTool>();
        for (DiffTool diffTool : tools) {
            try {
                if (!(diffTool instanceof FrameDiffTool)) continue;
                if (diffTool.canShow(this.myContext, this.myActiveRequest)) {
                    result2.add((FrameDiffTool)diffTool);
                    continue;
                }
                FrameDiffTool substitutor = this.findToolSubstitutor(diffTool);
                if (substitutor == null) continue;
                result2.add((FrameDiffTool)diffTool);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return DiffUtil.filterSuppressedTools(result2);
    }

    private FrameDiffTool findToolSubstitutor(@NotNull DiffTool tool) {
        DiffTool substitutor = DiffUtil.findToolSubstitutor(tool, this.myContext, this.myActiveRequest);
        return substitutor instanceof FrameDiffTool ? (FrameDiffTool)substitutor : null;
    }

    private void updateAvailableDiffTools() {
        this.myAvailableTools.clear();
        this.myToolOrder.clear();
        this.myAvailableTools.addAll(DiffManagerEx.getInstance().getDiffTools());
        this.myToolOrder.addAll(this.getToolOrderFromSettings(this.myAvailableTools));
    }

    private void moveToolOnTop(@NotNull DiffTool tool) {
        int index;
        this.myToolOrder.remove(tool);
        FrameDiffTool toolToReplace = this.getFittedTool(false);
        for (index = 0; index < this.myToolOrder.size() && this.myToolOrder.get(index) != toolToReplace; ++index) {
        }
        this.myToolOrder.add(index, tool);
        this.updateToolOrderSettings(this.myToolOrder);
    }

    @NotNull
    private ViewerState createState() {
        FrameDiffTool frameTool = this.getFittedTool(true);
        FrameDiffTool.DiffViewer viewer = frameTool.createComponent(this.myContext, this.myActiveRequest);
        for (DiffExtension extension : (DiffExtension[])DiffExtension.EP_NAME.getExtensions()) {
            try {
                extension.onViewerCreated(viewer, this.myContext, this.myActiveRequest);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        DiffViewerWrapper wrapper2 = (DiffViewerWrapper)this.myActiveRequest.getUserData(DiffViewerWrapper.KEY);
        if (wrapper2 == null) {
            return new DefaultState(viewer, frameTool);
        }
        return new WrapperState(viewer, frameTool, wrapper2);
    }

    protected void applyRequest(@NotNull DiffRequest request2, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.applyRequest(request2, force, scrollToChangePolicy, false);
    }

    protected void applyRequest(@NotNull DiffRequest request2, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy, boolean sync2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myIterationState = IterationState.NONE;
        force = force || this.myQueuedApplyRequest != null && this.myQueuedApplyRequest.force;
        this.myQueuedApplyRequest = new ApplyData(request2, force, scrollToChangePolicy);
        Runnable task2 = () -> {
            if (this.myQueuedApplyRequest == null || this.myDisposed) {
                return;
            }
            this.doApplyRequest(this.myQueuedApplyRequest.request, this.myQueuedApplyRequest.force, this.myQueuedApplyRequest.scrollToChangePolicy);
            this.myQueuedApplyRequest = null;
        };
        if (sync2) {
            task2.run();
        } else {
            IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(task2, ModalityState.current());
        }
    }

    private void doApplyRequest(@NotNull DiffRequest request2, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (!force && request2 == this.myActiveRequest) {
            return;
        }
        request2.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, (Object)scrollToChangePolicy);
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myToolbarWrapper.setBorder(null);
            this.myToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            this.myActiveRequest.onAssigned(false);
            this.myActiveRequest = request2;
            this.myActiveRequest.onAssigned(true);
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                try {
                    this.myState = this.createState();
                    try {
                        this.myState.init();
                    }
                    catch (Throwable e) {
                        this.myState.destroy();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                    this.myState = new ErrorState((MessageDiffRequest)new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0])), (DiffTool)this.getFittedTool(true));
                    this.myState.init();
                }
            });
        });
    }

    protected void setWindowTitle(@NotNull String title) {
    }

    protected void onAfterNavigate() {
    }

    protected void onDispose() {
    }

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myContext.putUserData(key, value2);
    }

    @NotNull
    protected List<AnAction> getNavigationActions() {
        return Arrays.asList(new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction(), new MyOpenInEditorAction(), Separator.getInstance(), new MyPrevChangeAction(), new MyNextChangeAction()});
    }

    @NotNull
    private List<AnAction> getTouchbarActions() {
        DefaultActionGroup left = new DefaultActionGroup(new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction()});
        DefaultActionGroup main2 = new DefaultActionGroup(new AnAction[]{new MyPrevChangeAction(), new MyNextChangeAction()});
        TouchbarDataKeys.putActionDescriptor((AnAction)main2).setShowText(true).setShowImage(false).setMainGroup(true);
        return Arrays.asList(left, main2);
    }

    protected boolean isWindowFocused() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        return window != null && window.isFocused();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow((Component)this.myContentPanel) || DiffUtil.isFocusedComponentInWindow(this.myToolbar.getComponent());
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    @NotNull
    protected List<DiffTool> getToolOrderFromSettings(@NotNull List<? extends DiffTool> availableTools) {
        ArrayList<DiffTool> result2 = new ArrayList<DiffTool>();
        List<String> savedOrder = this.getSettings().getDiffToolsOrder();
        for (String string : savedOrder) {
            DiffTool tool = (DiffTool)ContainerUtil.find(availableTools, t -> t.getClass().getCanonicalName().equals(clazz));
            if (tool == null) continue;
            result2.add(tool);
        }
        for (DiffTool diffTool : availableTools) {
            if (result2.contains(diffTool)) continue;
            result2.add(diffTool);
        }
        return result2;
    }

    protected void updateToolOrderSettings(@NotNull List<? extends DiffTool> toolOrder) {
        ArrayList<String> savedOrder = new ArrayList<String>();
        for (DiffTool diffTool : toolOrder) {
            savedOrder.add(diffTool.getClass().getCanonicalName());
        }
        this.getSettings().setDiffToolsOrder(savedOrder);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            this.myActiveRequest.onAssigned(false);
            this.myState = EmptyState.INSTANCE;
            this.myActiveRequest = NoDiffRequest.INSTANCE;
        });
    }

    protected void collectToolbarActions(@Nullable List<? extends AnAction> viewerActions) {
        this.myToolbarGroup.removeAll();
        ArrayList<AnAction> navigationActions = new ArrayList<AnAction>(this.getNavigationActions());
        navigationActions.add((AnAction)new MyChangeDiffToolAction());
        DiffUtil.addActionBlock(this.myToolbarGroup, navigationActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, viewerActions);
        List requestContextActions = (List)this.myActiveRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, contextActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, new AnAction[]{new ShowInExternalToolAction(), ActionManager.getInstance().getAction("ContextHelp")});
        this.myTouchbarActionGroup.replaceAll(this.getTouchbarActions());
    }

    protected void collectPopupActions(@Nullable List<? extends AnAction> viewerActions) {
        this.myPopupActionGroup.removeAll();
        ArrayList<DiffToolToggleAction> selectToolActions = new ArrayList<DiffToolToggleAction>();
        for (DiffTool diffTool : this.getAvailableFittedTools()) {
            FrameDiffTool substitutor = this.findToolSubstitutor(diffTool);
            if (diffTool == this.myState.getActiveTool() || substitutor == this.myState.getActiveTool()) continue;
            selectToolActions.add(new DiffToolToggleAction(diffTool));
        }
        DiffUtil.addActionBlock(this.myPopupActionGroup, selectToolActions);
        DiffUtil.addActionBlock(this.myPopupActionGroup, viewerActions);
    }

    protected void buildToolbar(@Nullable List<? extends AnAction> viewerActions) {
        this.collectToolbarActions(viewerActions);
        ((ActionToolbarImpl)this.myToolbar).clearPresentationCache();
        this.myToolbar.updateActionsImmediately();
        ActionUtil.recursiveRegisterShortcutSet((ActionGroup)this.myToolbarGroup, (JComponent)((Object)this.myMainPanel), null);
    }

    protected void buildActionPopup(@Nullable List<? extends AnAction> viewerActions) {
        this.collectPopupActions(viewerActions);
        DiffUtil.registerAction((AnAction)new ShowActionGroupPopupAction(), (JComponent)((Object)this.myMainPanel));
    }

    private void setTitle(@Nullable String title) {
        if (this.getContextUserData(DiffUserDataKeys.DO_NOT_CHANGE_WINDOW_TITLE) == Boolean.TRUE) {
            return;
        }
        if (title == null) {
            title = DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
        }
        this.setWindowTitle(title);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.myState.getPreferredFocusedComponent();
        JComponent fallback = this.myToolbar.getComponent();
        if (component2 == null || !component2.isFocusable()) {
            return fallback;
        }
        if (!component2.isShowing() && fallback.isShowing()) {
            return fallback;
        }
        return component2;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public DiffContext getContext() {
        return this.myContext;
    }

    @NotNull
    protected DiffSettingsHolder.DiffSettings getSettings() {
        return this.mySettings;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected boolean hasNextChange(boolean fromUpdate) {
        return false;
    }

    protected boolean hasPrevChange(boolean fromUpdate) {
        return false;
    }

    protected void goToNextChange(boolean fromDifferences) {
    }

    protected void goToPrevChange(boolean fromDifferences) {
    }

    protected boolean isNavigationEnabled() {
        return false;
    }

    private void notifyMessage(@NotNull AnActionEvent e, boolean next) {
        if (!this.myContentPanel.isShowing()) {
            return;
        }
        Editor editor = (Editor)e.getData(DiffDataKeys.CURRENT_EDITOR);
        String message = DiffUtil.createNotificationText(next ? DiffBundle.message((String)"press.again.to.go.to.the.next.file", (Object[])new Object[0]) : DiffBundle.message((String)"press.again.to.go.to.the.previous.file", (Object[])new Object[0]), DiffBundle.message((String)"notification.you.can.disable.this.feature.in.0", (Object[])new Object[]{DiffUtil.getSettingsConfigurablePath()}));
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message));
        Point point = new Point(this.myContentPanel.getWidth() / 2, next ? this.myContentPanel.getHeight() - JBUIScale.scale((int)40) : JBUIScale.scale((int)40));
        if (editor == null) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            HintHint hintHint = DiffRequestProcessor.createNotifyHint((JComponent)this.myContentPanel, point, next);
            hint.show((JComponent)this.myContentPanel, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
        } else {
            int x = SwingUtilities.convertPoint((Component)this.myContentPanel, (Point)point, (Component)editor.getComponent()).x;
            JComponent header2 = editor.getHeaderComponent();
            int shift = editor.getScrollingModel().getVerticalScrollOffset() - (header2 != null ? header2.getHeight() : 0);
            LineRange changeRange = (LineRange)e.getData(DiffDataKeys.CURRENT_CHANGE_RANGE);
            LogicalPosition position = changeRange == null ? new LogicalPosition(editor.getCaretModel().getLogicalPosition().line + (next ? 1 : 0), 0) : new LogicalPosition(next ? changeRange.end : changeRange.start, 0);
            int y = editor.logicalPositionToXY((LogicalPosition)position).y - shift;
            Point editorPoint = new Point(x, y);
            HintHint hintHint = DiffRequestProcessor.createNotifyHint(editor.getComponent(), editorPoint, !next);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, editorPoint, 42, 0, false, hintHint);
        }
    }

    @NotNull
    private static HintHint createNotifyHint(@NotNull JComponent component2, @NotNull Point point, boolean above) {
        return new HintHint(component2, point).setPreferredPosition(above ? Balloon.Position.above : Balloon.Position.below).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
    }

    protected static void patchShortcutSet(@NotNull AnAction action2, @NotNull @NonNls String originalActionId, @Nullable @NonNls String replacementActionId) {
        Keymap keymap2 = KeymapManager.getInstance().getActiveKeymap();
        Object[] originalShortcuts = keymap2.getShortcuts(originalActionId);
        Object[] shortcuts = action2.getShortcutSet().getShortcuts();
        Set newShortcuts = ContainerUtil.set((Object[])shortcuts);
        boolean hadOriginalShortcut = ContainerUtil.removeAll((Collection)newShortcuts, (Object[])originalShortcuts);
        if (!hadOriginalShortcut) {
            return;
        }
        if (replacementActionId != null) {
            Object[] replacementShortcuts = keymap2.getShortcuts(replacementActionId);
            ContainerUtil.addAll((Collection)newShortcuts, (Object[])replacementShortcuts);
        }
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY)), null);
    }

    private class WrapperState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;
        @NotNull
        private final FrameDiffTool.DiffViewer myWrapperViewer;

        WrapperState(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull FrameDiffTool tool, DiffViewerWrapper wrapper2) {
            this.myViewer = viewer;
            this.myTool = tool;
            this.myWrapperViewer = wrapper2.createComponent(DiffRequestProcessor.this.myContext, DiffRequestProcessor.this.myActiveRequest, this.myViewer);
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myWrapperViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents1 = this.myViewer.init();
            FrameDiffTool.ToolbarComponents toolbarComponents2 = this.myWrapperViewer.init();
            DiffRequestProcessor.this.buildToolbar(this.mergeActions(toolbarComponents1.toolbarActions, toolbarComponents2.toolbarActions));
            DiffRequestProcessor.this.buildActionPopup(this.mergeActions(toolbarComponents1.popupActions, toolbarComponents2.popupActions));
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents1.statusPanel);
            if (DiffRequestProcessor.this.shouldAddToolbarBottomBorder(toolbarComponents1)) {
                DiffRequestProcessor.this.myToolbarWrapper.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            }
        }

        @Nullable
        private List<AnAction> mergeActions(@Nullable List<AnAction> actions1, @Nullable List<AnAction> actions2) {
            if (actions1 == null && actions2 == null) {
                return null;
            }
            if (ContainerUtil.isEmpty(actions1)) {
                return actions2;
            }
            if (ContainerUtil.isEmpty(actions2)) {
                return actions1;
            }
            ArrayList<AnAction> result2 = new ArrayList<AnAction>(actions1);
            result2.add((AnAction)Separator.getInstance());
            for (AnAction action2 : actions2) {
                if (!(action2 instanceof Separator) && actions1.contains(action2)) continue;
                result2.add(action2);
            }
            return result2;
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
            Disposer.dispose((Disposable)this.myWrapperViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myWrapperViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            return this.myTool;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (DiffDataKeys.WRAPPING_DIFF_VIEWER.is(dataId)) {
                return this.myWrapperViewer;
            }
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }
    }

    private class DefaultState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;

        DefaultState(@NotNull FrameDiffTool.DiffViewer viewer, FrameDiffTool tool) {
            this.myViewer = viewer;
            this.myTool = tool;
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents = this.myViewer.init();
            DiffRequestProcessor.this.buildToolbar(toolbarComponents.toolbarActions);
            DiffRequestProcessor.this.buildActionPopup(toolbarComponents.popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
            if (DiffRequestProcessor.this.shouldAddToolbarBottomBorder(toolbarComponents)) {
                DiffRequestProcessor.this.myToolbarWrapper.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            }
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            return this.myTool;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }
    }

    private class ErrorState
    implements ViewerState {
        @Nullable
        private final DiffTool myDiffTool;
        @NotNull
        private final MessageDiffRequest myRequest;
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;

        ErrorState(MessageDiffRequest request2) {
            this(request2, null);
        }

        ErrorState(@Nullable MessageDiffRequest request2, DiffTool diffTool) {
            this.myDiffTool = diffTool;
            this.myRequest = request2;
            this.myViewer = ErrorDiffTool.INSTANCE.createComponent(DiffRequestProcessor.this.myContext, (DiffRequest)this.myRequest);
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
            DiffRequestProcessor.this.buildToolbar(init2.toolbarActions);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            return this.myDiffTool != null ? this.myDiffTool : ErrorDiffTool.INSTANCE;
        }
    }

    private static class EmptyState
    implements ViewerState {
        private static final EmptyState INSTANCE = new EmptyState();

        private EmptyState() {
        }

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            return ErrorDiffTool.INSTANCE;
        }
    }

    private static interface ViewerState {
        public void init();

        public void destroy();

        @Nullable
        public JComponent getPreferredFocusedComponent();

        @Nullable
        public Object getData(@NotNull @NonNls String var1);

        @NotNull
        public DiffTool getActiveTool();
    }

    private static class ApplyData {
        @NotNull
        private final DiffRequest request;
        private final boolean force;
        @Nullable
        private final DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy;

        ApplyData(@NotNull DiffRequest request2, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            this.request = request2;
            this.force = force;
            this.scrollToChangePolicy = scrollToChangePolicy;
        }
    }

    private class MyDiffContext
    extends DiffContextEx {
        @NotNull
        private final UserDataHolder myInitialContext;
        @NotNull
        private final UserDataHolder myOwnContext = new UserDataHolderBase();

        MyDiffContext(UserDataHolder initialContext) {
            this.myInitialContext = initialContext;
        }

        @Override
        public void reopenDiffRequest() {
            DiffRequestProcessor.this.updateRequest(true);
        }

        @Override
        public void reloadDiffRequest() {
            DiffRequestProcessor.this.reloadRequest();
        }

        @Override
        public void showProgressBar(boolean enabled) {
            if (enabled) {
                DiffRequestProcessor.this.myProgressBar.startProgress();
            } else {
                DiffRequestProcessor.this.myProgressBar.stopProgress();
            }
        }

        @Override
        public void setWindowTitle(@NotNull String title) {
            DiffRequestProcessor.this.setTitle(title);
        }

        @Nullable
        public Project getProject() {
            return DiffRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return DiffRequestProcessor.this.isFocusedInWindow();
        }

        public boolean isWindowFocused() {
            return DiffRequestProcessor.this.isWindowFocused();
        }

        public void requestFocusInWindow() {
            DiffRequestProcessor.this.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            Object data2 = this.myOwnContext.getUserData(key);
            if (data2 != null) {
                return (T)data2;
            }
            return (T)this.myInitialContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            this.myOwnContext.putUserData(key, value2);
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = DiffRequestProcessor.this.getPreferredFocusedComponent();
            if (component2 == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, this);
        }

        @Override
        @Nullable
        protected Project getProject() {
            return DiffRequestProcessor.this.myProject;
        }
    }

    private static class MyProgressBar
    extends JProgressBar {
        private int myProgressCount = 0;

        MyProgressBar() {
            this.setIndeterminate(true);
            this.setVisible(false);
        }

        public void startProgress() {
            ++this.myProgressCount;
            this.setVisible(true);
        }

        public void stopProgress() {
            --this.myProgressCount;
            LOG.assertTrue(this.myProgressCount >= 0);
            if (this.myProgressCount == 0) {
                this.setVisible(false);
            }
        }
    }

    private class MyPanel
    extends JBPanelWithEmptyText
    implements DataProvider {
        MyPanel() {
            super((LayoutManager)new BorderLayout());
        }

        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffPanelSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            Object data2;
            DataProvider contentProvider = DataManagerImpl.getDataProviderEx(DiffRequestProcessor.this.myContentPanel.getTargetComponent());
            if (contentProvider != null && (data2 = contentProvider.getData(dataId)) != null) {
                return data2;
            }
            if (OpenInEditorAction.KEY.is(dataId)) {
                return new MyOpenInEditorAction();
            }
            if (DiffDataKeys.DIFF_REQUEST.is(dataId)) {
                return DiffRequestProcessor.this.myActiveRequest;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return DiffRequestProcessor.this.myProject;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                if (DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "reference.dialogs.diff.file";
            }
            if (DiffDataKeys.DIFF_CONTEXT.is(dataId)) {
                return DiffRequestProcessor.this.myContext;
            }
            if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
                return DiffRequestProcessor.this.myTouchbarActionGroup;
            }
            data2 = DiffRequestProcessor.this.myState.getData(dataId);
            if (data2 != null) {
                return data2;
            }
            DataProvider requestProvider = (DataProvider)DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (requestProvider != null && (data2 = requestProvider.getData(dataId)) != null) {
                return data2;
            }
            DataProvider contextProvider = (DataProvider)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data2 = contextProvider.getData(dataId)) != null) {
                return data2;
            }
            return null;
        }
    }

    protected class MyOpenInEditorAction
    extends OpenInEditorAction {
        @Override
        protected void onAfterEditorOpened() {
            DiffRequestProcessor.this.onAfterNavigate();
        }
    }

    protected class MyPrevChangeAction
    extends PrevChangeAction {
        public MyPrevChangeAction() {
            if (DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DIFF_IN_EDITOR, new UserDataHolder[]{DiffRequestProcessor.this.getContext()})) {
                DiffRequestProcessor.patchShortcutSet(this, "PreviousTab", "PreviousEditorTab");
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasPrevChange(true));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasPrevChange(false)) {
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(false);
        }
    }

    protected class MyNextChangeAction
    extends NextChangeAction {
        public MyNextChangeAction() {
            if (DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DIFF_IN_EDITOR, new UserDataHolder[]{DiffRequestProcessor.this.getContext()})) {
                DiffRequestProcessor.patchShortcutSet(this, "NextTab", "NextEditorTab");
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasNextChange(true));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasNextChange(false)) {
                return;
            }
            DiffRequestProcessor.this.goToNextChange(false);
        }
    }

    protected class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        public void update(@NotNull AnActionEvent e) {
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange(true)) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoPrev()) {
                iterable.goPrev();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange(false) && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.PREV) {
                DiffRequestProcessor.this.notifyMessage(e, false);
                DiffRequestProcessor.this.myIterationState = IterationState.PREV;
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(true);
        }
    }

    protected class MyNextDifferenceAction
    extends NextDifferenceAction {
        public void update(@NotNull AnActionEvent e) {
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange(true)) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoNext()) {
                iterable.goNext();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange(false) && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.NEXT) {
                DiffRequestProcessor.this.notifyMessage(e, true);
                DiffRequestProcessor.this.myIterationState = IterationState.NEXT;
                return;
            }
            DiffRequestProcessor.this.goToNextChange(true);
        }
    }

    private static enum IterationState {
        NEXT,
        PREV,
        NONE;

    }

    private class ShowActionGroupPopupAction
    extends DumbAwareAction {
        ShowActionGroupPopupAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowSettingsPopup");
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(DiffRequestProcessor.this.myPopupActionGroup.getChildrenCount() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DiffBundle.message((String)"diff.actions", (Object[])new Object[0]), (ActionGroup)DiffRequestProcessor.this.myPopupActionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup2.showInCenterOf((Component)DiffRequestProcessor.this.myPanel);
        }
    }

    private class DiffToolToggleAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final DiffTool myDiffTool;

        private DiffToolToggleAction(DiffTool tool) {
            super(tool.getName());
            this.myDiffTool = tool;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(DiffRequestProcessor.this.myForcedDiffTool == null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (DiffRequestProcessor.this.myState.getActiveTool() == this.myDiffTool) {
                return;
            }
            DiffUsageTriggerCollector.trigger("toggle.diff.tool", this.myDiffTool, (String)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.PLACE));
            DiffRequestProcessor.this.moveToolOnTop(this.myDiffTool);
            DiffRequestProcessor.this.updateRequest(true);
        }
    }

    private class MyChangeDiffToolAction
    extends ComboBoxAction
    implements DumbAware {
        private MyChangeDiffToolAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            DiffTool activeTool = DiffRequestProcessor.this.myState.getActiveTool();
            presentation2.setText(activeTool.getName());
            if (DiffRequestProcessor.this.myForcedDiffTool != null) {
                presentation2.setEnabledAndVisible(false);
                return;
            }
            for (DiffTool tool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                if (tool == activeTool) continue;
                presentation2.setEnabledAndVisible(true);
                return;
            }
            presentation2.setEnabledAndVisible(false);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (DiffTool tool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                group.add((AnAction)new DiffToolToggleAction(tool));
            }
            return group;
        }
    }

    private class ShowInExternalToolAction
    extends DumbAwareAction {
        ShowInExternalToolAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowInExternalTool");
        }

        public void update(@NotNull AnActionEvent e) {
            if (!ExternalDiffTool.isEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabled(ExternalDiffTool.canShow(DiffRequestProcessor.this.myActiveRequest));
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            try {
                ExternalDiffTool.showRequest(e.getProject(), DiffRequestProcessor.this.myActiveRequest);
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getMessage(), (String)DiffBundle.message((String)"can.t.show.diff.in.external.tool", (Object[])new Object[0]));
            }
        }
    }
}

