/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class SubiterableDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final DiffIterable myIterable;
    private final int myStart1;
    private final int myStart2;
    private final int myEnd1;
    private final int myEnd2;

    SubiterableDiffIterable(@NotNull DiffIterable iterable, int start1, int end1, int start2, int end2) {
        super(end1 - start1, end2 - start2);
        this.myIterable = iterable;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myEnd1 = end1;
        this.myEnd2 = end2;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new SubiterableChangeIterable(this.myIterable, this.myStart1, this.myEnd1, this.myStart2, this.myEnd2);
    }

    private static class SubiterableChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final Iterator<Range> myIterator;
        private final int myStart1;
        private final int myEnd1;
        private final int myStart2;
        private final int myEnd2;
        private Range myLast;

        SubiterableChangeIterable(@NotNull DiffIterable iterable, int start1, int end1, int start2, int end2) {
            this.myIterator = iterable.changes();
            this.myStart1 = start1;
            this.myEnd1 = end1;
            this.myStart2 = start2;
            this.myEnd2 = end2;
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = null;
            while (this.myIterator.hasNext()) {
                Range range2 = this.myIterator.next();
                if (range2.end1 < this.myStart1 || range2.end2 < this.myStart2) continue;
                if (range2.start1 > this.myEnd1 || range2.start2 > this.myEnd2) break;
                Range newRange = new Range(Math.max(this.myStart1, range2.start1) - this.myStart1, Math.min(this.myEnd1, range2.end1) - this.myStart1, Math.max(this.myStart2, range2.start2) - this.myStart2, Math.min(this.myEnd2, range2.end2) - this.myStart2);
                if (newRange.isEmpty()) continue;
                this.myLast = newRange;
                break;
            }
        }

        @Override
        public int getStart1() {
            return this.myLast.start1;
        }

        @Override
        public int getStart2() {
            return this.myLast.start2;
        }

        @Override
        public int getEnd1() {
            return this.myLast.end1;
        }

        @Override
        public int getEnd2() {
            return this.myLast.end2;
        }
    }
}

