/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class LineFragmentSplitter {
    @NotNull
    private final CharSequence myText1;
    @NotNull
    private final CharSequence myText2;
    @NotNull
    private final List<? extends ByWord.InlineChunk> myWords1;
    @NotNull
    private final List<? extends ByWord.InlineChunk> myWords2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    private final ProgressIndicator myIndicator;
    @NotNull
    private final List<WordBlock> myResult = new ArrayList<WordBlock>();
    private int last1 = -1;
    private int last2 = -1;
    private PendingChunk pendingChunk = null;

    LineFragmentSplitter(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<? extends ByWord.InlineChunk> words1, @NotNull List<? extends ByWord.InlineChunk> words2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        this.myText1 = text1;
        this.myText2 = text2;
        this.myWords1 = words1;
        this.myWords2 = words2;
        this.myIterable = iterable;
        this.myIndicator = indicator;
    }

    @NotNull
    public List<WordBlock> run() {
        boolean hasEqualWords = false;
        for (Range range2 : this.myIterable.iterateUnchanged()) {
            int count = range2.end1 - range2.start1;
            for (int i2 = 0; i2 < count; ++i2) {
                int index1 = range2.start1 + i2;
                int index2 = range2.start2 + i2;
                if (LineFragmentSplitter.isNewline(this.myWords1, index1) && LineFragmentSplitter.isNewline(this.myWords2, index2)) {
                    this.addLineChunk(index1, index2, hasEqualWords);
                    hasEqualWords = false;
                    continue;
                }
                if (LineFragmentSplitter.isFirstInLine(this.myWords1, index1) && LineFragmentSplitter.isFirstInLine(this.myWords2, index2)) {
                    this.addLineChunk(index1 - 1, index2 - 1, hasEqualWords);
                    hasEqualWords = false;
                }
                hasEqualWords = true;
            }
        }
        this.addLineChunk(this.myWords1.size(), this.myWords2.size(), hasEqualWords);
        if (this.pendingChunk != null) {
            this.myResult.add(this.pendingChunk.block);
        }
        return this.myResult;
    }

    private void addLineChunk(int end1, int end2, boolean hasEqualWords) {
        if (this.last1 > end1 || this.last2 > end2) {
            return;
        }
        PendingChunk chunk = this.createChunk(this.last1, this.last2, end1, end2, hasEqualWords);
        if (chunk.block.offsets.isEmpty()) {
            return;
        }
        if (this.pendingChunk != null && LineFragmentSplitter.shouldMergeChunks(this.pendingChunk, chunk)) {
            this.pendingChunk = LineFragmentSplitter.mergeChunks(this.pendingChunk, chunk);
        } else {
            if (this.pendingChunk != null) {
                this.myResult.add(this.pendingChunk.block);
            }
            this.pendingChunk = chunk;
        }
        this.last1 = end1;
        this.last2 = end2;
    }

    @NotNull
    private PendingChunk createChunk(int start1, int start2, int end1, int end2, boolean hasEqualWords) {
        int startOffset1 = LineFragmentSplitter.getOffset(this.myWords1, this.myText1, start1);
        int startOffset2 = LineFragmentSplitter.getOffset(this.myWords2, this.myText2, start2);
        int endOffset1 = LineFragmentSplitter.getOffset(this.myWords1, this.myText1, end1);
        int endOffset2 = LineFragmentSplitter.getOffset(this.myWords2, this.myText2, end2);
        start1 = Math.max(0, start1 + 1);
        start2 = Math.max(0, start2 + 1);
        end1 = Math.min(end1 + 1, this.myWords1.size());
        end2 = Math.min(end2 + 1, this.myWords2.size());
        WordBlock block = new WordBlock(new Range(start1, end1, start2, end2), new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        return new PendingChunk(block, hasEqualWords, this.hasWordsInside(block), this.isEqualsIgnoreWhitespace(block));
    }

    private static boolean shouldMergeChunks(@NotNull PendingChunk chunk1, @NotNull PendingChunk chunk2) {
        if (!chunk1.hasEqualWords && !chunk2.hasEqualWords) {
            return true;
        }
        if (chunk1.isEqualIgnoreWhitespaces && chunk2.isEqualIgnoreWhitespaces) {
            return true;
        }
        return !chunk1.hasWordsInside || !chunk2.hasWordsInside;
    }

    @NotNull
    private static PendingChunk mergeChunks(@NotNull PendingChunk chunk1, @NotNull PendingChunk chunk2) {
        WordBlock block1 = chunk1.block;
        WordBlock block2 = chunk2.block;
        WordBlock newBlock = new WordBlock(new Range(block1.words.start1, block2.words.end1, block1.words.start2, block2.words.end2), new Range(block1.offsets.start1, block2.offsets.end1, block1.offsets.start2, block2.offsets.end2));
        return new PendingChunk(newBlock, chunk1.hasEqualWords || chunk2.hasEqualWords, chunk1.hasWordsInside || chunk2.hasWordsInside, chunk1.isEqualIgnoreWhitespaces && chunk2.isEqualIgnoreWhitespaces);
    }

    private boolean isEqualsIgnoreWhitespace(@NotNull WordBlock block) {
        CharSequence sequence1 = this.myText1.subSequence(block.offsets.start1, block.offsets.end1);
        CharSequence sequence2 = this.myText2.subSequence(block.offsets.start2, block.offsets.end2);
        return StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2);
    }

    private boolean hasWordsInside(@NotNull WordBlock block) {
        int i2;
        for (i2 = block.words.start1; i2 < block.words.end1; ++i2) {
            if (this.myWords1.get(i2) instanceof ByWord.NewlineChunk) continue;
            return true;
        }
        for (i2 = block.words.start2; i2 < block.words.end2; ++i2) {
            if (this.myWords2.get(i2) instanceof ByWord.NewlineChunk) continue;
            return true;
        }
        return false;
    }

    private static int getOffset(@NotNull List<? extends ByWord.InlineChunk> words, @NotNull CharSequence text, int index) {
        if (index == -1) {
            return 0;
        }
        if (index == words.size()) {
            return text.length();
        }
        ByWord.InlineChunk chunk = words.get(index);
        assert (chunk instanceof ByWord.NewlineChunk);
        return chunk.getOffset2();
    }

    private static boolean isNewline(@NotNull List<? extends ByWord.InlineChunk> words1, int index) {
        return words1.get(index) instanceof ByWord.NewlineChunk;
    }

    private static boolean isFirstInLine(@NotNull List<? extends ByWord.InlineChunk> words1, int index) {
        if (index == 0) {
            return true;
        }
        return words1.get(index - 1) instanceof ByWord.NewlineChunk;
    }

    private static class PendingChunk {
        @NotNull
        public final WordBlock block;
        public final boolean hasEqualWords;
        public final boolean hasWordsInside;
        public final boolean isEqualIgnoreWhitespaces;

        PendingChunk(@NotNull WordBlock block, boolean hasEqualWords, boolean hasWordsInside, boolean isEqualIgnoreWhitespaces) {
            this.block = block;
            this.hasEqualWords = hasEqualWords;
            this.hasWordsInside = hasWordsInside;
            this.isEqualIgnoreWhitespaces = isEqualIgnoreWhitespaces;
        }
    }

    public static class WordBlock {
        @NotNull
        public final Range words;
        @NotNull
        public final Range offsets;

        public WordBlock(@NotNull Range words, @NotNull Range offsets2) {
            this.words = words;
            this.offsets = offsets2;
        }
    }
}

