/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFilesAction.DiffRequest");
    @NonNls
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    @NonNls
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        String text = ActionsBundle.message((String)"action.compare.files.text", (Object[])new Object[0]);
        if (files2 != null && files2.length == 1) {
            text = ActionsBundle.message((String)"action.compare.with.text", (Object[])new Object[0]);
        } else if (files2 != null && files2.length == 2) {
            Type type2;
            Type type1 = CompareFilesAction.getType(files2[0]);
            if (type1 != (type2 = CompareFilesAction.getType(files2[1]))) {
                text = ActionsBundle.message((String)"action.compare.text", (Object[])new Object[0]);
            } else {
                switch (type1) {
                    case FILE: {
                        text = ActionsBundle.message((String)"action.compare.files.text", (Object[])new Object[0]);
                        break;
                    }
                    case DIRECTORY: {
                        text = ActionsBundle.message((String)"action.CompareDirs.text", (Object[])new Object[0]);
                        break;
                    }
                    case ARCHIVE: {
                        text = ActionsBundle.message((String)"action.compare.archives.text", (Object[])new Object[0]);
                    }
                }
            }
        }
        e.getPresentation().setText(text);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        DiffRequest request2 = (DiffRequest)e.getData(DIFF_REQUEST);
        if (request2 != null) {
            return true;
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 == null) {
            return false;
        }
        if (files2.length == 1) {
            return CompareFilesAction.hasContent(files2[0]);
        }
        if (files2.length == 2) {
            return CompareFilesAction.hasContent(files2[0]) && CompareFilesAction.hasContent(files2[1]);
        }
        return false;
    }

    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        return (DiffRequest)e.getData(DIFF_REQUEST);
    }

    @Override
    @Nullable
    protected DiffRequestChain getDiffRequestChain(@NotNull AnActionEvent e) {
        VirtualFile file2;
        VirtualFile file1;
        Project project = e.getProject();
        DiffRequest diffRequest = this.getDiffRequest(e);
        if (diffRequest != null) {
            return new SimpleDiffRequestChain(diffRequest);
        }
        VirtualFile[] data2 = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (data2.length == 1) {
            file1 = data2[0];
            file2 = CompareFilesAction.getOtherFile(project, file1);
            if (file2 == null || !CompareFilesAction.hasContent(file2)) {
                return null;
            }
        } else {
            file1 = data2[0];
            file2 = data2[1];
        }
        if (!file1.isValid() || !file2.isValid()) {
            return null;
        }
        Type type1 = CompareFilesAction.getType(file1);
        Type type2 = CompareFilesAction.getType(file2);
        if (type1 == Type.DIRECTORY || type2 == Type.DIRECTORY) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("dir.diff");
        }
        if (type1 == Type.ARCHIVE || type2 == Type.ARCHIVE) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("jar.diff");
        }
        return CompareFilesAction.createMutableChainFromFiles(project, file1, file2);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project, @NotNull VirtualFile file2) {
        String key;
        FileChooserDescriptor descriptor2;
        Type type = CompareFilesAction.getType(file2);
        if (type == Type.DIRECTORY || type == Type.ARCHIVE) {
            descriptor2 = new FileChooserDescriptor(false, true, true, true, true, false);
            key = LAST_USED_FOLDER_KEY;
        } else {
            descriptor2 = new FileChooserDescriptor(true, false, false, true, true, false);
            key = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project, key, file2);
        VirtualFile otherFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)selectedFile);
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project, key, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file2) {
        if (project == null) {
            return file2;
        }
        String path = PropertiesComponent.getInstance((Project)project).getValue(key);
        if (path == null) {
            return file2;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path);
        return lastSelection != null ? lastSelection : file2;
    }

    private static void updateDefaultSelection(@Nullable Project project, @NotNull String key, @NotNull VirtualFile file2) {
        if (project == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project).setValue(key, file2.getPath());
    }

    @NotNull
    private static Type getType(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return Type.FILE;
        }
        if (file2.getFileType() instanceof ArchiveFileType) {
            return Type.ARCHIVE;
        }
        if (file2.isDirectory()) {
            return Type.DIRECTORY;
        }
        return Type.FILE;
    }

    private static enum Type {
        FILE,
        DIRECTORY,
        ARCHIVE;

    }
}

