/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.util.FileBackedHashMap;
import com.intellij.diagnostic.hprof.visitors.RemapIDsVisitor;
import gnu.trove.TLongIntHashMap;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H&J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\u0006H\u0016J_\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJ(\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/RemapIDsVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "()V", "currentID", "", "addMapping", "", "oldId", "", "newId", "getRemappingFunction", "Ljava/util/function/LongUnaryOperator;", "preVisit", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "Companion", "intellij.platform.ide.impl"})
public abstract class RemapIDsVisitor
extends HProfVisitor {
    private int currentID;
    private static final int KEY_SIZE = 8;
    private static final int VALUE_SIZE = 4;
    public static final Companion Companion = new Companion(null);

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.currentID = 1;
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(arrayObjectId, n);
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(classId, n);
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(arrayObjectId, n);
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        int n = this.currentID;
        this.currentID = n + 1;
        this.addMapping(objectId, n);
    }

    public abstract void addMapping(long var1, int var3);

    @NotNull
    public abstract LongUnaryOperator getRemappingFunction();

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/RemapIDsVisitor$Companion;", "", "()V", "KEY_SIZE", "", "VALUE_SIZE", "createFileBased", "Lcom/intellij/diagnostic/hprof/visitors/RemapIDsVisitor;", "channel", "Ljava/nio/channels/FileChannel;", "maxInstanceCount", "", "createMemoryBased", "isSupported", "", "instanceCount", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final RemapIDsVisitor createMemoryBased() {
            TLongIntHashMap map2 = new TLongIntHashMap();
            map2.put(0L, 0);
            return new RemapIDsVisitor(map2){
                final /* synthetic */ TLongIntHashMap $map;

                public void addMapping(long oldId, int newId) {
                    this.$map.put(oldId, newId);
                }

                @NotNull
                public LongUnaryOperator getRemappingFunction() {
                    return new LongUnaryOperator(this){
                        final /* synthetic */ createMemoryBased.1 this$0;

                        public final long applyAsLong(long it) {
                            return this.this$0.$map.get(it);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    };
                }
                {
                    this.$map = $captured_local_variable$0;
                }
            };
        }

        @NotNull
        public final RemapIDsVisitor createFileBased(@NotNull FileChannel channel, long maxInstanceCount) {
            FileBackedHashMap remapIDsMap = FileBackedHashMap.Companion.createEmpty(channel, maxInstanceCount, 8, 4);
            return new RemapIDsVisitor(remapIDsMap){
                final /* synthetic */ FileBackedHashMap $remapIDsMap;

                public void addMapping(long oldId, int newId) {
                    this.$remapIDsMap.put(oldId).putInt(newId);
                }

                @NotNull
                public LongUnaryOperator getRemappingFunction() {
                    return new LongUnaryOperator(this){
                        final /* synthetic */ createFileBased.1 this$0;

                        public final long applyAsLong(long operand) {
                            long l;
                            if (operand == 0L) {
                                l = 0L;
                            } else {
                                ByteBuffer byteBuffer = this.this$0.$remapIDsMap.get(operand);
                                if (byteBuffer == null) {
                                    Intrinsics.throwNpe();
                                }
                                l = byteBuffer.getInt();
                            }
                            return l;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    };
                }
                {
                    this.$remapIDsMap = $captured_local_variable$0;
                }
            };
        }

        public final boolean isSupported(long instanceCount) {
            return FileBackedHashMap.Companion.isSupported(instanceCount, 8, 4);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

