/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginConflictDialog
extends DialogWrapper {
    public static final int WIDTH = 450;
    @NotNull
    private final List<PluginId> myConflictingPlugins;
    private final boolean myIsConflictWithPlatform;
    @Nullable
    private final List<JBRadioButton> myRadioButtons;
    private JPanel myContentPane;
    private JBLabel myTopMessageLabel;
    private JPanel myConflictingPluginsListPanel;

    public PluginConflictDialog(@NotNull List<PluginId> conflictingPlugins, boolean isConflictWithPlatform) {
        super(false);
        this.myConflictingPlugins = conflictingPlugins;
        this.myIsConflictWithPlatform = isConflictWithPlatform;
        this.myRadioButtons = this.myIsConflictWithPlatform ? null : new ArrayList<JBRadioButton>();
        this.$$$setupUI$$$();
        this.setTitle(DiagnosticBundle.message("error.dialog.conflict.plugin.title", new Object[0]));
        this.init();
        this.setCrossClosesWindow(false);
        this.getOKAction().updateText();
        this.myTopMessageLabel.setText(PluginConflictDialog.getTopMessageText(conflictingPlugins, isConflictWithPlatform));
        this.myTopMessageLabel.setPreferredSize((Dimension)JBUI.size((int)450, (int)((int)this.myTopMessageLabel.getPreferredSize().getHeight())));
        this.myContentPane.setPreferredSize((Dimension)JBUI.size((int)450, (int)((int)this.myContentPane.getMinimumSize().getHeight())));
    }

    private static String getTopMessageText(@NotNull List<PluginId> conflictingPlugins, boolean isConflictWithPlatform) {
        int pluginsNumber = conflictingPlugins.size();
        if (isConflictWithPlatform) {
            return DiagnosticBundle.message("error.dialog.conflict.plugin.header.platform", pluginsNumber);
        }
        List names2 = conflictingPlugins.stream().map(PluginConflictDialog::getPluginNameOrId).map(s -> "<b>" + s + "</b>").collect(Collectors.toList());
        return DiagnosticBundle.message("error.dialog.conflict.plugin.header.each.other", StringUtil.join(names2.subList(0, pluginsNumber - 1), (String)", "), names2.get(pluginsNumber - 1));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.myConflictingPluginsListPanel = new JPanel(new GridLayout(0, 1));
        List pluginDescriptions = ContainerUtil.map(this.myConflictingPlugins, plugin -> this.getChooserPanelForPlugin(buttonGroup2, (PluginId)plugin));
        pluginDescriptions.forEach(this.myConflictingPluginsListPanel::add);
        if (!this.myIsConflictWithPlatform) {
            JPanel chooserPanelForPlugin = this.getChooserPanelForPlugin(buttonGroup2, null);
            this.myConflictingPluginsListPanel.add(chooserPanelForPlugin);
        }
        this.setUpDefaultSelection();
    }

    @NotNull
    private JPanel getChooserPanelForPlugin(@NotNull ButtonGroup buttonGroup2, @Nullable PluginId plugin) {
        JPanel panel2 = new JPanel(new BorderLayout());
        if (!this.myIsConflictWithPlatform) {
            assert (this.myRadioButtons != null);
            final JBRadioButton radioButton = new JBRadioButton();
            this.myRadioButtons.add(radioButton);
            buttonGroup2.add((AbstractButton)radioButton);
            radioButton.addChangeListener(e -> this.getOKAction().updateText());
            panel2.add((Component)radioButton, "West");
            panel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    radioButton.setSelected(true);
                }
            });
        }
        JPanel descriptionPanel = plugin != null ? PluginConflictDialog.getPluginDescriptionPanel(plugin, !this.myIsConflictWithPlatform) : PluginConflictDialog.getDisableAllPanel();
        descriptionPanel.setBorder((Border)new JBEmptyBorder(10, this.myIsConflictWithPlatform ? 10 : 0, 10, 20));
        panel2.add((Component)descriptionPanel, "Center");
        return panel2;
    }

    private void setUpDefaultSelection() {
        if (this.myIsConflictWithPlatform) {
            return;
        }
        assert (this.myRadioButtons != null && this.myRadioButtons.size() == this.myConflictingPlugins.size() + 1);
        for (int i2 = 0; i2 < this.myConflictingPlugins.size(); ++i2) {
            IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(this.myConflictingPlugins.get(i2));
            if (pluginDescriptor == null || !pluginDescriptor.isBundled() && !StringUtil.equalsIgnoreCase((CharSequence)pluginDescriptor.getVendor(), (CharSequence)"JetBrains")) continue;
            this.myRadioButtons.get(i2).setSelected(true);
            return;
        }
        this.myRadioButtons.get(this.myRadioButtons.size() - 1).setSelected(true);
    }

    @NotNull
    private static JPanel getPluginDescriptionPanel(@NotNull PluginId plugin, boolean addUseWord) {
        JPanel panel2 = new JPanel(new BorderLayout());
        IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(plugin);
        if (pluginDescriptor == null) {
            panel2.add((Component)new JBLabel(plugin.getIdString()), "Center");
            return panel2;
        }
        StringBuilder sb = new StringBuilder("<html>");
        if (addUseWord) {
            sb.append("Use ");
        }
        sb.append(pluginDescriptor.getName());
        if (pluginDescriptor.getVendor() != null) {
            sb.append(" by ").append(pluginDescriptor.getVendor());
        }
        sb.append("</html>");
        panel2.add((Component)new JBLabel(sb.toString()));
        return panel2;
    }

    @NotNull
    private static String getPluginNameOrId(@NotNull PluginId pluginId) {
        IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(pluginId);
        if (pluginDescriptor == null) {
            return pluginId.getIdString();
        }
        return pluginDescriptor.getName();
    }

    @NotNull
    private static JPanel getDisableAllPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JBLabel(DiagnosticBundle.message("error.dialog.conflict.plugin.disable.all", new Object[0])));
        return panel2;
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction()};
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction = new DisableAction();
    }

    @NotNull
    protected DisableAction getOKAction() {
        return (DisableAction)((Object)this.myOKAction);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(400, -1));
        this.myTopMessageLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = this.myConflictingPluginsListPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class DisableAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAction() {
            super((DialogWrapper)PluginConflictDialog.this, IdeBundle.message((String)"button.disable", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        public void updateText() {
            this.putValue("Name", this.getButtonText());
            PluginConflictDialog.this.repaint();
        }

        @NotNull
        private String getButtonText() {
            if (PluginConflictDialog.this.myIsConflictWithPlatform) {
                return DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]);
            }
            assert (PluginConflictDialog.this.myRadioButtons != null);
            for (int i2 = 0; i2 < PluginConflictDialog.this.myConflictingPlugins.size(); ++i2) {
                if (!((JBRadioButton)PluginConflictDialog.this.myRadioButtons.get(i2)).isSelected()) continue;
                return DiagnosticBundle.message("error.dialog.conflict.plugin.button.enable.and.restart", new Object[0]);
            }
            return DiagnosticBundle.message("error.dialog.conflict.plugin.button.disable.all", new Object[0]);
        }

        protected void doAction(ActionEvent e) {
            for (int i2 = 0; i2 < PluginConflictDialog.this.myConflictingPlugins.size(); ++i2) {
                if (PluginConflictDialog.this.myRadioButtons != null && ((JBRadioButton)PluginConflictDialog.this.myRadioButtons.get(i2)).isSelected()) continue;
                PluginManagerCore.disablePlugin((PluginId)PluginConflictDialog.this.myConflictingPlugins.get(i2));
            }
            PluginConflictDialog.this.close(0);
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }
}

