/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

class SettingsXmlFile {
    private final Path myFile;
    private final Document myDocument;
    private final Element myRootElement;

    SettingsXmlFile(@NotNull Path file2) throws CannotConvertException {
        this.myFile = file2;
        this.myDocument = JDomConvertingUtil.loadDocument(file2.toFile());
        this.myRootElement = this.myDocument.getRootElement();
    }

    public Path getFile() {
        return this.myFile;
    }

    public Element getRootElement() {
        return this.myRootElement;
    }

    public void save() throws IOException {
        JDOMUtil.writeDocument((Document)this.myDocument, (File)this.myFile.toFile(), (String)SystemProperties.getLineSeparator());
    }

    @Nullable
    public Element findComponent(String componentName) {
        return JDomSerializationUtil.findComponent((Element)this.myRootElement, (String)componentName);
    }
}

