/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class AsyncFutureResultImpl<V>
implements AsyncFutureResult<V> {
    private final SettableFuture<V> myFuture = SettableFuture.create();

    public void addConsumer(@NotNull Executor executor, @NotNull ResultConsumer<? super V> consumer) {
        this.myFuture.addListener(() -> {
            try {
                Object result2 = this.myFuture.get();
                consumer.onSuccess(result2);
            }
            catch (ExecutionException e) {
                consumer.onFailure(e.getCause());
            }
            catch (Throwable throwable) {
                consumer.onFailure(throwable);
            }
        }, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.myFuture.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.myFuture.isCancelled();
    }

    public boolean isDone() {
        return this.myFuture.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.myFuture.get();
    }

    public V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.myFuture.get(timeout, unit);
    }

    public void set(V value2) {
        if (!this.myFuture.set(value2)) {
            throw new Error("already set");
        }
    }

    public void setException(@NotNull Throwable t) {
        if (!this.myFuture.setException(t)) {
            throw new Error("already excepted");
        }
    }
}

