/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions.suppress;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.ThrowableRunnable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressActionSequentialTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(SuppressActionSequentialTask.class);
    private final SuppressableInspectionTreeNode[] myNodesToSuppress;
    @NotNull
    private final SuppressIntentionAction mySuppressAction;
    @NotNull
    private final InspectionToolWrapper myWrapper;
    private int myCount = 0;

    public SuppressActionSequentialTask(SuppressableInspectionTreeNode @NotNull [] nodesToSuppress, @NotNull SuppressIntentionAction suppressAction, @NotNull InspectionToolWrapper wrapper2) {
        this.myNodesToSuppress = nodesToSuppress;
        this.mySuppressAction = suppressAction;
        this.myWrapper = wrapper2;
    }

    public boolean iteration() {
        return true;
    }

    public boolean iteration(@NotNull ProgressIndicator indicator) {
        SuppressableInspectionTreeNode node = this.myNodesToSuppress[this.myCount++];
        indicator.setFraction((double)this.myCount / (double)this.myNodesToSuppress.length);
        Pair<PsiElement, CommonProblemDescriptor> content2 = node.getSuppressContent();
        if (content2.first != null) {
            this.suppress((PsiElement)content2.first, (CommonProblemDescriptor)content2.second, this.mySuppressAction, this.myWrapper, node);
        }
        return this.isDone();
    }

    public boolean isDone() {
        return this.myCount > this.myNodesToSuppress.length - 1;
    }

    public void prepare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(InspectionsBundle.message((String)"inspection.action.suppress", (Object[])new Object[]{this.myWrapper.getDisplayName()}));
        }
    }

    private void suppress(@NotNull PsiElement element2, @Nullable CommonProblemDescriptor descriptor2, @NotNull SuppressIntentionAction action2, @NotNull InspectionToolWrapper wrapper2, @NotNull SuppressableInspectionTreeNode node) {
        if (action2 instanceof SuppressIntentionActionFromFix && !(descriptor2 instanceof ProblemDescriptor)) {
            LOG.info("local suppression fix for specific problem descriptor:  " + wrapper2.getTool().getClass().getName());
        }
        Project project = element2.getProject();
        try {
            PsiElement container2 = null;
            if (action2 instanceof SuppressIntentionActionFromFix) {
                container2 = ((SuppressIntentionActionFromFix)action2).getContainer(element2);
            }
            if (container2 == null) {
                container2 = element2;
            }
            if (action2.isAvailable(project, null, element2)) {
                ThrowableRunnable runnable2 = () -> action2.invoke(project, null, element2);
                if (action2.startInWriteAction()) {
                    WriteAction.run((ThrowableRunnable)runnable2);
                } else {
                    runnable2.run();
                }
            }
            Set<GlobalInspectionContextImpl> globalInspectionContexts = ((InspectionManagerEx)InspectionManager.getInstance((Project)element2.getProject())).getRunningContexts();
            for (GlobalInspectionContextImpl context : globalInspectionContexts) {
                context.resolveElement(wrapper2.getTool(), container2);
                if (descriptor2 == null) continue;
                context.getPresentation(wrapper2).suppressProblem(descriptor2);
            }
        }
        catch (IncorrectOperationException e1) {
            LOG.error((Throwable)e1);
        }
        node.removeSuppressActionFromAvailable(this.mySuppressAction);
    }
}

