/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends SuppressableInspectionTreeNode {
    private final Icon myIcon;
    @Nullable
    private final RefEntity myRefEntity;

    public RefElementNode(@Nullable RefEntity refEntity, @NotNull InspectionToolPresentation presentation2, @NotNull InspectionTreeNode parent) {
        super(presentation2, parent);
        this.myRefEntity = refEntity;
        this.myIcon = refEntity == null ? null : refEntity.getIcon(false);
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.getElement() != null && this.getPresentation().isSuppressed(this.getElement());
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myRefEntity;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    protected String calculatePresentableName() {
        RefEntity element2 = this.getElement();
        if (element2 == null) {
            return AnalysisBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return element2.getRefManager().getRefinedElement(element2).getName();
    }

    @Override
    protected boolean calculateIsValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public boolean isExcluded() {
        RefEntity element2 = this.getElement();
        if (this.isLeaf() && element2 != null) {
            return this.getPresentation().isExcluded(element2);
        }
        return super.isExcluded();
    }

    @Override
    public void excludeElement() {
        RefEntity element2 = this.getElement();
        if (this.isLeaf() && element2 != null) {
            this.getPresentation().exclude(element2);
            return;
        }
        super.excludeElement();
    }

    @Override
    public void amnestyElement() {
        RefEntity element2 = this.getElement();
        if (this.isLeaf() && element2 != null) {
            this.getPresentation().amnesty(element2);
            return;
        }
        super.amnestyElement();
    }

    @Override
    public RefEntity getContainingFileLocalEntity() {
        RefEntity element2 = this.getElement();
        return element2 instanceof RefElement && !(element2 instanceof RefDirectory) ? element2 : super.getContainingFileLocalEntity();
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.isLeaf() && this.getPresentation().isProblemResolved(this.getElement());
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.getPresentation().isDummy()) {
            return "";
        }
        String customizedText = super.getTailText();
        if (customizedText != null) {
            return customizedText;
        }
        return this.isLeaf() ? "" : null;
    }

    @Override
    @NotNull
    public Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        PsiElement element2 = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
        return Pair.create((Object)element2, null);
    }
}

