/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.actions.suppress.SuppressActionWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickFixPreviewPanelFactory {
    private static final Logger LOG = Logger.getInstance(QuickFixPreviewPanelFactory.class);
    private static final int MAX_FIX_COUNT = 3;

    @Nullable
    public static JComponent create(@NotNull InspectionResultsView view) {
        if (view.isUpdating() && !view.getTree().areDescriptorNodesSelected()) {
            return new LoadingInProgressPreview(view);
        }
        QuickFixReadyPanel panel2 = new QuickFixReadyPanel(view);
        return panel2.isEmpty() ? null : panel2;
    }

    @NotNull
    private static SimpleColoredComponent getLabel(int problemsCount) {
        SimpleColoredComponent label2 = new SimpleColoredComponent();
        QuickFixPreviewPanelFactory.appendTextToLabel(label2, problemsCount);
        label2.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        return label2;
    }

    private static void appendTextToLabel(SimpleColoredComponent label2, int problemsCount) {
        label2.append(problemsCount + " " + StringUtil.pluralize((String)"problem", (int)problemsCount) + ":");
    }

    private static class LoadingInProgressPreview
    extends JPanel
    implements InspectionTreeLoadingProgressAware {
        private final InspectionResultsView myView;
        private final SimpleColoredComponent myWaitingLabel;

        private LoadingInProgressPreview(InspectionResultsView view) {
            this.myView = view;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder((Border)JBUI.Borders.empty((int)16, (int)9, (int)13, (int)0));
            AsyncProcessIcon waitingIcon = new AsyncProcessIcon("Inspection preview panel updating...");
            Disposer.register((Disposable)this, (Disposable)waitingIcon);
            this.myWaitingLabel = QuickFixPreviewPanelFactory.getLabel(this.myView.getTree().getSelectedProblemCount());
            this.add((Component)this.myWaitingLabel);
            this.add((Component)waitingIcon);
        }

        @Override
        public void updateLoadingProgress() {
            if (this.myWaitingLabel != null) {
                this.myWaitingLabel.clear();
                InspectionTree tree = this.myView.getTree();
                QuickFixPreviewPanelFactory.appendTextToLabel(this.myWaitingLabel, tree.getSelectedProblemCount());
            }
        }

        @Override
        public void treeLoaded() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myView.isDisposed()) {
                    this.myView.syncRightPanel();
                }
            });
        }
    }

    private static class QuickFixReadyPanel
    extends JPanel {
        @NotNull
        private final InspectionResultsView myView;
        private final InspectionToolWrapper myWrapper;
        private final boolean myEmpty;

        QuickFixReadyPanel(@NotNull InspectionResultsView view) {
            this.myView = view;
            this.myWrapper = view.getTree().getSelectedToolWrapper(true);
            LOG.assertTrue(this.myWrapper != null);
            QuickFixAction[] commonFixes = view.getProvider().getCommonQuickFixes(this.myWrapper, view.getTree());
            boolean multipleDescriptors = this.myView.getTree().getSelectedDescriptors().length > 1;
            QuickFixAction[] partialFixes = QuickFixAction.EMPTY;
            if (multipleDescriptors && commonFixes.length == 0) {
                partialFixes = view.getProvider().getPartialQuickFixes(this.myWrapper, view.getTree());
            }
            this.myEmpty = this.fillPanel(commonFixes, partialFixes, multipleDescriptors, view);
        }

        public boolean isEmpty() {
            return this.myEmpty;
        }

        private boolean fillPanel(QuickFixAction @NotNull [] fixes, QuickFixAction @NotNull [] partialFixes, boolean multipleDescriptors, @NotNull InspectionResultsView view) {
            AnAction suppressionCombo;
            int actualProblemCount;
            boolean hasFixes = fixes.length != 0;
            this.setLayout(new BoxLayout(this, 2));
            boolean hasComponents = false;
            InspectionTree tree = this.myView.getTree();
            InspectionToolPresentation presentation2 = tree.getContext().getPresentation(this.myWrapper);
            boolean showProblemCount = presentation2.showProblemCount();
            if (showProblemCount && ((actualProblemCount = tree.getSelectedProblemCount()) > 1 || actualProblemCount == 1 && multipleDescriptors)) {
                this.add((Component)QuickFixPreviewPanelFactory.getLabel(actualProblemCount));
                hasComponents = true;
            }
            DefaultActionGroup actions = new DefaultActionGroup();
            if (hasFixes) {
                actions.addAll(QuickFixReadyPanel.createFixActions(fixes, multipleDescriptors));
            }
            if ((suppressionCombo = QuickFixReadyPanel.createSuppressionCombo(this.myView)) != null) {
                actions.add(suppressionCombo);
            }
            if (partialFixes.length != 0) {
                actions.add(QuickFixReadyPanel.createPartialFixCombo(partialFixes));
            }
            if (actions.getChildrenCount() != 0) {
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("inspection.view.quick.fix.preview", (ActionGroup)actions, true);
                JComponent component2 = toolbar.getComponent();
                toolbar.setTargetComponent((JComponent)view);
                this.add(component2);
                hasComponents = true;
            }
            if (hasComponents) {
                int top = hasFixes ? 2 : 9;
                int left = hasFixes || multipleDescriptors ? 8 : 5;
                int bottom = hasFixes ? 0 : 8;
                this.setBorder((Border)JBUI.Borders.empty((int)top, (int)left, (int)bottom, (int)0));
            }
            return !hasComponents;
        }

        @NotNull
        private static AnAction createPartialFixCombo(QuickFixAction[] fixes) {
            final DefaultActionGroup group = new DefaultActionGroup();
            for (QuickFixAction fix : fixes) {
                group.add((AnAction)fix);
            }
            return new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer((String)"action.presentation.QuickFixPreviewPanelFactory.text", (Object[])new Object[0]));
                    this.setSmallVariant(false);
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
                    return group;
                }
            };
        }

        @Nullable
        private static AnAction createSuppressionCombo(InspectionResultsView view) {
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"CodeInspection", null, (DataContext)DataManager.getInstance().getDataContext((Component)view));
            AnAction[] suppressors = new SuppressActionWrapper().getChildren(event);
            final AnAction[] availableSuppressors = (AnAction[])Arrays.stream(suppressors).filter(s -> {
                event.getPresentation().setEnabled(false);
                s.update(event);
                return event.getPresentation().isEnabled();
            }).toArray(AnAction[]::new);
            if (availableSuppressors.length == 0) {
                return null;
            }
            ComboBoxAction action2 = new ComboBoxAction(){
                {
                    this.getTemplatePresentation().setText(CodeInsightBundle.messagePointer((String)"action.presentation.QuickFixPreviewPanelFactory.text.suppress", (Object[])new Object[0]));
                }

                @NotNull
                protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
                    DefaultCompactActionGroup group = new DefaultCompactActionGroup();
                    group.addAll(availableSuppressors);
                    return group;
                }
            };
            action2.setSmallVariant(false);
            return action2;
        }

        private static AnAction @NotNull [] createFixActions(final QuickFixAction[] fixes, final boolean multipleDescriptors) {
            if (fixes.length > 3) {
                ComboBoxAction fixComboBox = new ComboBoxAction(){
                    {
                        if (multipleDescriptors) {
                            this.getTemplatePresentation().setText(InspectionsBundle.message((String)"apply.quick.fixes.to.all.action.text", (Object[])new Object[0]));
                        } else {
                            this.getTemplatePresentation().setText(InspectionsBundle.message((String)"apply.quick.fixes.action.text", (Object[])new Object[0]));
                        }
                        this.getTemplatePresentation().setIcon(AllIcons.Actions.IntentionBulb);
                        this.setSmallVariant(false);
                    }

                    @NotNull
                    protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
                        DefaultActionGroup actionGroup = new DefaultActionGroup();
                        for (QuickFixAction fix : fixes) {
                            actionGroup.add((AnAction)fix);
                        }
                        return actionGroup;
                    }
                };
                return new AnAction[]{fixComboBox};
            }
            return fixes;
        }
    }
}

