/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InspectionViewChangeAdapter
extends PsiTreeChangeAdapter {
    private final InspectionResultsView myView;
    private final Alarm myAlarm;
    private final Set<VirtualFile> myUnPresentEditedFiles = Collections.synchronizedSet(ContainerUtil.createWeakSet());
    private final Set<VirtualFile> myFilesToProcess = new THashSet();
    private final AtomicBoolean myNeedReValidate = new AtomicBoolean(false);
    private final Alarm myUpdateQueue;

    InspectionViewChangeAdapter(@NotNull InspectionResultsView view) {
        this.myView = view;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)view);
        this.myUpdateQueue = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)view);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.processFileEvent(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        this.processFileOrDirEvent(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.processFileOrDirEvent(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (!this.processFileEvent(event)) {
            PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            if (oldParent instanceof PsiDirectory || newParent instanceof PsiDirectory) {
                this.needReValidateTree();
            }
        }
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.processFileOrDirEvent(event);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        this.processFileEvent(event);
    }

    private void needReValidateTree() {
        this.myNeedReValidate.set(true);
        this.invokeQueue();
    }

    private void processFileOrDirEvent(@NotNull PsiTreeChangeEvent event) {
        PsiElement parent;
        if (!this.processFileEvent(event) && (parent = event.getParent()) instanceof PsiDirectory) {
            this.needReValidateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFileEvent(@NotNull PsiTreeChangeEvent event) {
        PsiFile file2 = event.getFile();
        if (file2 != null) {
            VirtualFile vFile = file2.getVirtualFile();
            if (!this.myUnPresentEditedFiles.contains(vFile)) {
                Set<VirtualFile> set = this.myFilesToProcess;
                synchronized (set) {
                    this.myFilesToProcess.add(vFile);
                }
                this.invokeQueue();
            }
            return true;
        }
        return false;
    }

    private void invokeQueue() {
        this.myUpdateQueue.cancelAllRequests();
        this.myUpdateQueue.addRequest(() -> {
            THashSet filesToCheck;
            boolean[] needUpdateUI = new boolean[]{false};
            Processor nodeProcessor = null;
            if (this.myNeedReValidate.compareAndSet(true, false)) {
                nodeProcessor = node -> {
                    VirtualFile vFile;
                    SmartPsiElementPointer pointer;
                    RefElement element2;
                    if (this.myView.isDisposed()) {
                        return false;
                    }
                    if (node instanceof SuppressableInspectionTreeNode && (element2 = (RefElement)ObjectUtils.tryCast((Object)((SuppressableInspectionTreeNode)node).getElement(), RefElement.class)) != null && (pointer = element2.getPointer()) != null && ((vFile = pointer.getVirtualFile()) == null || !vFile.isValid())) {
                        ((SuppressableInspectionTreeNode)node).dropCache();
                        if (!needUpdateUI[0]) {
                            needUpdateUI[0] = true;
                        }
                    }
                    return true;
                };
            }
            Set<VirtualFile> set = this.myFilesToProcess;
            synchronized (set) {
                filesToCheck = new THashSet(this.myFilesToProcess);
                this.myFilesToProcess.clear();
            }
            THashSet unPresentFiles = new THashSet((Collection)filesToCheck);
            if (!filesToCheck.isEmpty()) {
                Processor fileCheckProcessor = arg_0 -> this.lambda$null$2((Set)filesToCheck, (Set)unPresentFiles, needUpdateUI, arg_0);
                nodeProcessor = CompositeProcessor.combine(fileCheckProcessor, nodeProcessor);
            }
            this.myView.getTree().getInspectionTreeModel().traverse(this.myView.getTree().getInspectionTreeModel().getRoot()).processEach(nodeProcessor);
            if (!unPresentFiles.isEmpty()) {
                this.myUnPresentEditedFiles.addAll((Collection<VirtualFile>)unPresentFiles);
            }
            if (needUpdateUI[0] && !this.myAlarm.isDisposed()) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myView.getTree().getInspectionTreeModel().reload(), 100, ModalityState.NON_MODAL);
            }
        }, 200);
    }

    private /* synthetic */ boolean lambda$null$2(Set filesToCheck, Set unPresentFiles, boolean[] needUpdateUI, InspectionTreeNode node) {
        VirtualFile vFile;
        SmartPsiElementPointer pointer;
        RefElement element2;
        if (this.myView.isDisposed()) {
            return false;
        }
        if (node instanceof SuppressableInspectionTreeNode && (element2 = (RefElement)ObjectUtils.tryCast((Object)((SuppressableInspectionTreeNode)node).getElement(), RefElement.class)) != null && (pointer = element2.getPointer()) != null && filesToCheck.contains(vFile = (VirtualFile)ReadAction.compute(() -> pointer.getVirtualFile()))) {
            unPresentFiles.remove(vFile);
            ((SuppressableInspectionTreeNode)node).dropCache();
            if (!needUpdateUI[0]) {
                needUpdateUI[0] = true;
            }
        }
        return true;
    }

    private static class CompositeProcessor<X>
    implements Processor<X> {
        private final Processor<? super X> myFirstProcessor;
        private boolean myFirstFinished;
        private final Processor<? super X> mySecondProcessor;
        private boolean mySecondFinished;

        private CompositeProcessor(@NotNull Processor<? super X> firstProcessor, @NotNull Processor<? super X> secondProcessor) {
            this.myFirstProcessor = firstProcessor;
            this.mySecondProcessor = secondProcessor;
        }

        public boolean process(X x) {
            if (!this.myFirstFinished && !this.myFirstProcessor.process(x)) {
                this.myFirstFinished = true;
            }
            if (!this.mySecondFinished && !this.mySecondProcessor.process(x)) {
                this.mySecondFinished = true;
            }
            return !this.myFirstFinished || !this.mySecondFinished;
        }

        @NotNull
        public static <X> Processor<? super X> combine(@NotNull Processor<? super X> processor1, @Nullable Processor<? super X> processor2) {
            return processor2 == null ? processor1 : new CompositeProcessor<X>(processor1, processor2);
        }
    }
}

