/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionResultsViewUtil {
    static void releaseEditor(@Nullable Editor editor) {
        if (editor != null && !editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
    }

    @Nullable
    static Navigatable getNavigatableForInvalidNode(ProblemDescriptionNode node) {
        PsiFile containingFile;
        RefEntity element2;
        for (element2 = node.getElement(); element2 != null && !element2.isValid(); element2 = element2.getOwner()) {
        }
        if (!(element2 instanceof RefElement)) {
            return null;
        }
        PsiElement containingElement = ((RefElement)element2).getPsiElement();
        if (!(containingElement instanceof NavigatablePsiElement) || !containingElement.isValid()) {
            return null;
        }
        int lineNumber = node.getLineNumber();
        if (lineNumber != -1 && (containingFile = containingElement.getContainingFile()) != null) {
            VirtualFile file2 = containingFile.getVirtualFile();
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null && document.getLineCount() > lineNumber) {
                return new OpenFileDescriptor(containingElement.getProject(), file2, lineNumber, 0);
            }
        }
        return (Navigatable)containingElement;
    }

    @NotNull
    static JLabel getNothingToShowTextLabel() {
        return InspectionResultsViewUtil.createLabelForText(InspectionViewNavigationPanel.getTitleText(false));
    }

    @NotNull
    static JComponent getInvalidEntityLabel(@NotNull RefEntity entity) {
        String name = entity.getName();
        return InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.invalid.label", (Object[])new Object[]{name}));
    }

    public static JComponent getPreviewIsNotAvailable(@NotNull RefEntity entity) {
        String name = entity.getQualifiedName();
        return InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.no.preview.label", (Object[])new Object[]{name}));
    }

    @NotNull
    static JComponent getApplyingFixLabel(@NotNull InspectionToolWrapper wrapper2) {
        return InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.applying.quick.label", (Object[])new Object[]{wrapper2.getDisplayName()}));
    }

    @NotNull
    static JLabel createLabelForText(@Nls String text) {
        JBLabel multipleSelectionLabel = new JBLabel(text);
        multipleSelectionLabel.setVerticalAlignment(1);
        multipleSelectionLabel.setBorder((Border)JBUI.Borders.empty((int)16, (int)12, (int)0, (int)0));
        return multipleSelectionLabel;
    }
}

