/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.JsonInspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSingleFileInspectionsReportConverter
extends JsonInspectionsReportConverter {
    @Override
    public String getFormatName() {
        return "json-single-file";
    }

    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified");
        }
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputPath, new String[0]), CharsetToolkit.UTF8_CHARSET, new OpenOption[0]);
             JsonWriter jsonWriter = gson2.newJsonWriter((Writer)writer);){
            jsonWriter.beginObject();
            File patches2 = (File)ContainerUtil.find(inspectionsResults, file2 -> FileUtil.getNameWithoutExtension((File)file2).equals("fixes"));
            if (patches2 != null) {
                Element patchesElement = JDOMUtil.loadDocument((File)patches2).getRootElement();
                jsonWriter.name("patch").value(patchesElement.getTextTrim());
                jsonWriter.name("patchedFiles");
                jsonWriter.beginArray();
                for (Element element2 : patchesElement.getChildren("patchedFile")) {
                    jsonWriter.beginObject();
                    jsonWriter.name("path").value(element2.getAttributeValue("path"));
                    jsonWriter.name("content").value(element2.getTextTrim());
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.name("problems");
            jsonWriter.beginArray();
            HashSet<String> seenProblemIds = new HashSet<String>();
            for (File file3 : inspectionsResults) {
                if (FileUtil.getNameWithoutExtension((File)file3).equals(".descriptions")) continue;
                seenProblemIds.add(FileUtil.getNameWithoutExtension((File)file3));
                Document doc = JDOMUtil.loadDocument((File)file3);
                for (Element problem : doc.getRootElement().getChildren("problem")) {
                    JsonSingleFileInspectionsReportConverter.convertProblem(jsonWriter, problem);
                }
            }
            jsonWriter.endArray();
            File descriptionsFile = (File)ContainerUtil.find(inspectionsResults, file2 -> FileUtil.getNameWithoutExtension((File)file2).equals(".descriptions"));
            if (descriptionsFile != null) {
                JsonSingleFileInspectionsReportConverter.convertDescriptionsContents(jsonWriter, JDOMUtil.loadDocument((File)descriptionsFile), id2 -> seenProblemIds.contains(id2));
            }
            jsonWriter.endObject();
        }
        catch (IOException | JDOMException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot convert file: " + e.getMessage());
        }
    }
}

